/*
 * Copyright 2022 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.drools.ruleunits.dsl.patterns;

import org.drools.model.Condition;
import org.drools.model.view.ViewItem;

import static org.drools.model.DSL.exists;
import static org.drools.model.DSL.not;

public class ExistentialPatternDef implements InternalPatternDef {

    private final Condition.Type type;
    private final InternalPatternDef pattern;

    public ExistentialPatternDef(Condition.Type type, InternalPatternDef pattern) {
        this.type = type;
        this.pattern = pattern;
    }

    @Override
    public ViewItem toExecModelItem() {
        if (type == Condition.Type.NOT) {
            return not(pattern.toExecModelItem());
        }
        if (type == Condition.Type.EXISTS) {
            return exists(pattern.toExecModelItem());
        }
        throw new UnsupportedOperationException();
    }
}
