/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.dsl;

import java.util.Map;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.impl.RuleBase;
import org.drools.model.Model;
import org.drools.modelcompiler.KieBaseBuilder;
import org.drools.ruleunits.api.DataProcessor;
import org.drools.ruleunits.api.DataSource;
import org.drools.ruleunits.api.RuleUnit;
import org.drools.ruleunits.api.RuleUnitData;
import org.drools.ruleunits.api.RuleUnitInstance;
import org.drools.ruleunits.dsl.RuleUnitDefinition;
import org.drools.ruleunits.dsl.RulesFactory;
import org.drools.ruleunits.dsl.UnitGlobalsResolver;
import org.drools.ruleunits.impl.EntryPointDataProcessor;
import org.drools.ruleunits.impl.ReteEvaluatorBasedRuleUnitInstance;
import org.drools.ruleunits.impl.RuleUnitProviderImpl;
import org.drools.ruleunits.impl.factory.AbstractRuleUnit;
import org.drools.ruleunits.impl.sessions.RuleUnitExecutorImpl;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.runtime.rule.EntryPoint;

public class RuleUnitProviderForDSL
extends RuleUnitProviderImpl {
    private static final boolean DUMP_GENERATED_RETE = false;

    public int servicePriority() {
        return 1;
    }

    protected <T extends RuleUnitData> Map<Class<? extends RuleUnitData>, RuleUnit> generateRuleUnit(T ruleUnitData) {
        if (ruleUnitData instanceof RuleUnitDefinition) {
            RuleUnitDefinition ruleUnitDef = (RuleUnitDefinition)ruleUnitData;
            RulesFactory rulesFactory = new RulesFactory(ruleUnitDef);
            ruleUnitDef.defineRules(rulesFactory);
            ModelRuleUnit ruleUnit = new ModelRuleUnit(ruleUnitData.getClass(), rulesFactory.toModel(), rulesFactory.getUnitGlobalsResolver());
            return Map.of(ruleUnitData.getClass(), ruleUnit);
        }
        return super.generateRuleUnit(ruleUnitData);
    }

    public static class DSLRuleUnitInstance<T extends RuleUnitData>
    extends ReteEvaluatorBasedRuleUnitInstance<T> {
        public DSLRuleUnitInstance(RuleUnit<T> unit, T workingMemory, ReteEvaluator reteEvaluator, UnitGlobalsResolver unitGlobalsResolver) {
            super(unit, workingMemory, reteEvaluator);
            this.internalBind(unitGlobalsResolver);
        }

        protected void bind(ReteEvaluator reteEvaluator, T workingMemory) {
        }

        private void internalBind(UnitGlobalsResolver unitGlobalsResolver) {
            for (String dataSourceName : unitGlobalsResolver.getGlobalNames()) {
                Object v = unitGlobalsResolver.resolveGlobalObject(this.ruleUnitData(), dataSourceName);
                if (v instanceof DataSource) {
                    DataSource o = (DataSource)v;
                    WorkingMemoryEntryPoint ep = ((ReteEvaluator)this.getEvaluator()).getEntryPoint(dataSourceName);
                    if (ep != null) {
                        o.subscribe((DataProcessor)new EntryPointDataProcessor((EntryPoint)ep));
                    }
                }
                try {
                    ((ReteEvaluator)this.getEvaluator()).setGlobal(dataSourceName, v);
                }
                catch (RuntimeException runtimeException) {}
            }
        }
    }

    public static class ModelRuleUnit<T extends RuleUnitData>
    extends AbstractRuleUnit<T> {
        private final UnitGlobalsResolver unitGlobalsResolver;
        private final RuleBase ruleBase;

        public ModelRuleUnit(Class<T> type, Model model, UnitGlobalsResolver unitGlobalsResolver) {
            super(type);
            this.unitGlobalsResolver = unitGlobalsResolver;
            this.ruleBase = KieBaseBuilder.createKieBaseFromModel((Model)model, (KieBaseOption[])new KieBaseOption[0]);
        }

        public RuleUnitInstance<T> internalCreateInstance(T data) {
            RuleUnitExecutorImpl reteEvaluator = new RuleUnitExecutorImpl(this.ruleBase);
            return new DSLRuleUnitInstance<T>(this, data, (ReteEvaluator)reteEvaluator, this.unitGlobalsResolver);
        }
    }
}

