/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.dsl;

import java.io.Serializable;
import org.drools.model.Index;
import org.drools.model.functions.Block1;
import org.drools.model.functions.Block2;
import org.drools.model.functions.Function1;
import org.drools.ruleunits.api.DataSource;
import org.drools.ruleunits.api.DataStore;
import org.drools.ruleunits.dsl.RuleUnitDefinition;
import org.drools.ruleunits.dsl.RulesFactory;
import org.drools.ruleunits.dsl.domain.Person;

public class InferenceUnit
implements RuleUnitDefinition {
    private final DataStore<String> strings;
    private final DataStore<Person> persons;

    public InferenceUnit() {
        this((DataStore<String>)DataSource.createStore(), (DataStore<Person>)DataSource.createStore());
    }

    public InferenceUnit(DataStore<String> strings, DataStore<Person> persons) {
        this.strings = strings;
        this.persons = persons;
    }

    public DataStore<String> getStrings() {
        return this.strings;
    }

    public DataStore<Person> getPersons() {
        return this.persons;
    }

    public void defineRules(RulesFactory rulesFactory) {
        rulesFactory.rule().on(this.strings).filter((Function1 & Serializable)s -> s.length(), Index.ConstraintType.GREATER_THAN, (Object)4).executeOnDataStore(this.persons, (Block2 & Serializable)(ps, s) -> ps.add((Object)new Person((String)s, 17)));
        rulesFactory.rule().on(this.persons).filter("name", (Function1 & Serializable)p -> p.getName(), Index.ConstraintType.EQUAL, (Object)"Mario").executeOnDataStore(this.persons, (Block2 & Serializable)(ps, p) -> {
            p.setAge(p.getAge() + 1);
            ps.update(p, new String[]{"age"});
        });
        rulesFactory.rule().on(this.persons).filter("age", (Function1 & Serializable)p -> p.getAge(), Index.ConstraintType.GREATER_OR_EQUAL, (Object)18).executeOnDataStore(this.strings, (Block1 & Serializable)s -> s.add((Object)"ok"));
    }
}

