/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.dsl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.model.Index;
import org.drools.model.functions.Block1;
import org.drools.model.functions.Block2;
import org.drools.model.functions.Block3;
import org.drools.model.functions.Function1;
import org.drools.model.functions.Predicate1;
import org.drools.ruleunits.api.DataSource;
import org.drools.ruleunits.api.DataStore;
import org.drools.ruleunits.api.RuleUnitData;
import org.drools.ruleunits.api.RuleUnitInstance;
import org.drools.ruleunits.api.RuleUnitProvider;
import org.drools.ruleunits.dsl.SyntheticRuleUnit;
import org.drools.ruleunits.dsl.SyntheticRuleUnitBuilder;
import org.junit.jupiter.api.Test;

public class SyntheticRuleUnitsTest {
    @Test
    public void testHelloWorld() {
        DataStore strings = DataSource.createStore();
        DataStore ints = DataSource.createStore();
        ArrayList results = new ArrayList();
        SyntheticRuleUnit unit = SyntheticRuleUnitBuilder.build((String)"HelloWorld").registerDataSource("strings", (DataSource)strings, String.class).registerDataSource("ints", (DataSource)ints, Integer.class).registerGlobal("results", results).defineRules(rulesFactory -> {
            rulesFactory.rule().on((DataSource)strings).filter(Index.ConstraintType.EQUAL, (Object)"Hello World").execute((Object)results, (Block1 & Serializable)r -> r.add("it worked!"));
            rulesFactory.rule().on((DataSource)strings).filter((Function1 & Serializable)s -> s.length(), Index.ConstraintType.GREATER_THAN, (Object)5).execute((Object)results, (Block2 & Serializable)(r, s) -> r.add("it also worked with " + s.toUpperCase()));
            rulesFactory.rule("MyRule").on((DataSource)strings).filter("length", (Function1 & Serializable)s -> s.length(), Index.ConstraintType.LESS_THAN, (Object)5).execute((Object)results, (Block1 & Serializable)r -> r.add("this shouldn't fire"));
            rulesFactory.rule().on((DataSource)strings).filter("length", (Predicate1 & Serializable)s -> s.length() > 5).join((Function1 & Serializable)rule -> rule.on((DataSource)ints).filter(Index.ConstraintType.GREATER_THAN, (Object)5)).filter(Index.ConstraintType.EQUAL, String::length).execute((Object)results, (Block3 & Serializable)(r, s, i) -> r.add("String '" + s + "' is " + i + " characters long"));
        });
        RuleUnitInstance unitInstance = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)unit);
        strings.add((Object)"Hello World");
        Assertions.assertThat((int)unitInstance.fire()).isEqualTo(2);
        Assertions.assertThat(results).containsExactlyInAnyOrder((Object[])new String[]{"it worked!", "it also worked with HELLO WORLD"});
        results.clear();
        ints.add((Object)11);
        Assertions.assertThat((int)unitInstance.fire()).isEqualTo(1);
        Assertions.assertThat(results).containsExactly((Object[])new String[]{"String 'Hello World' is 11 characters long"});
        unitInstance.close();
    }

    @Test
    public void testSeparatedUnitCreation() {
        SyntheticRuleUnit unit = this.createSyntheticRuleUnit();
        RuleUnitInstance unitInstance = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)unit);
        unit.getDataStore("strings", String.class).add((Object)"Hello World");
        Assertions.assertThat((int)unitInstance.fire()).isEqualTo(2);
        Assertions.assertThat((List)((List)unit.getGlobal("results", List.class))).containsExactlyInAnyOrder(new Object[]{"it worked!", "it also worked with HELLO WORLD"});
        ((List)unit.getGlobal("results", List.class)).clear();
        unit.getDataStore("ints", Integer.class).add((Object)11);
        Assertions.assertThat((int)unitInstance.fire()).isEqualTo(1);
        Assertions.assertThat((List)((List)unit.getGlobal("results", List.class))).containsExactly(new Object[]{"String 'Hello World' is 11 characters long"});
        unitInstance.close();
    }

    private SyntheticRuleUnit createSyntheticRuleUnit() {
        DataStore strings = DataSource.createStore();
        DataStore ints = DataSource.createStore();
        ArrayList results = new ArrayList();
        return SyntheticRuleUnitBuilder.build((String)"HelloWorld").registerDataSource("strings", (DataSource)strings, String.class).registerDataSource("ints", (DataSource)ints, Integer.class).registerGlobal("results", results).defineRules(rulesFactory -> {
            rulesFactory.rule().on((DataSource)strings).filter(Index.ConstraintType.EQUAL, (Object)"Hello World").execute((Object)results, (Block1 & Serializable)r -> r.add("it worked!"));
            rulesFactory.rule().on((DataSource)strings).filter((Function1 & Serializable)s -> s.length(), Index.ConstraintType.GREATER_THAN, (Object)5).execute((Object)results, (Block2 & Serializable)(r, s) -> r.add("it also worked with " + s.toUpperCase()));
            rulesFactory.rule("MyRule").on((DataSource)strings).filter("length", (Function1 & Serializable)s -> s.length(), Index.ConstraintType.LESS_THAN, (Object)5).execute((Object)results, (Block1 & Serializable)r -> r.add("this shouldn't fire"));
            rulesFactory.rule().on((DataSource)strings).filter("length", (Predicate1 & Serializable)s -> s.length() > 5).join((Function1 & Serializable)rule -> rule.on((DataSource)ints).filter(Index.ConstraintType.GREATER_THAN, (Object)5)).filter(Index.ConstraintType.EQUAL, String::length).execute((Object)results, (Block3 & Serializable)(r, s, i) -> r.add("String '" + s + "' is " + i + " characters long"));
        });
    }
}

