/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.dsl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.drools.model.Index;
import org.drools.model.functions.Block2;
import org.drools.model.functions.Block3;
import org.drools.model.functions.Function1;
import org.drools.ruleunits.api.DataSource;
import org.drools.ruleunits.api.DataStore;
import org.drools.ruleunits.api.SingletonStore;
import org.drools.ruleunits.dsl.Accumulators;
import org.drools.ruleunits.dsl.RuleUnitDefinition;
import org.drools.ruleunits.dsl.RulesFactory;

public class AccumulateUnit
implements RuleUnitDefinition {
    private final DataStore<String> strings;
    private final SingletonStore<Integer> threshold;
    private final List<String> results = new ArrayList<String>();

    public AccumulateUnit() {
        this((DataStore<String>)DataSource.createStore(), (SingletonStore<Integer>)DataSource.createSingleton());
    }

    public AccumulateUnit(DataStore<String> strings, SingletonStore<Integer> threshold) {
        this.strings = strings;
        this.threshold = threshold;
    }

    public DataStore<String> getStrings() {
        return this.strings;
    }

    public List<String> getResults() {
        return this.results;
    }

    public SingletonStore<Integer> getThreshold() {
        return this.threshold;
    }

    public void defineRules(RulesFactory rulesFactory) {
        rulesFactory.rule("Sum length of String starting with A").accumulate((Function1 & Serializable)rule -> rule.on(this.strings).filter((Function1 & Serializable)s -> s.substring(0, 1), Index.ConstraintType.EQUAL, (Object)"A"), Accumulators.sum(String::length)).execute(this.results, (Block2 & Serializable)(r, sum) -> r.add("Sum of length of Strings starting with A is " + sum));
        rulesFactory.rule("Find mac length of String not starting with A").accumulate((Function1 & Serializable)rule -> rule.on(this.strings).filter((Function1 & Serializable)s -> s.substring(0, 1), Index.ConstraintType.NOT_EQUAL, (Object)"A"), Accumulators.max(String::length)).execute(this.results, (Block2 & Serializable)(r, max) -> r.add("Max length of Strings not starting with A is " + max));
        rulesFactory.rule("Find average length of String above a threshold").on(this.threshold).accumulate((Function1 & Serializable)rule -> rule.on(this.strings).filter(String::length, Index.ConstraintType.GREATER_THAN, Function1.identity()), Accumulators.avg(String::length)).execute(this.results, (Block3 & Serializable)(r, t, avg) -> r.add("Average length of Strings longer than threshold " + t + " is " + avg));
        rulesFactory.rule("Count Strings having length above a threshold").accumulate((Function1 & Serializable)rule -> rule.on(this.threshold).on(this.strings).filter(String::length, Index.ConstraintType.GREATER_THAN, Function1.identity()), Accumulators.count()).execute(this.results, (Block2 & Serializable)(r, count) -> r.add("Count of Strings above threshold is " + count));
    }
}

