/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.dsl.constraints;

import java.io.Serializable;
import java.util.UUID;
import org.drools.model.Index;
import org.drools.model.PatternDSL;
import org.drools.model.Variable;
import org.drools.model.functions.Function1;
import org.drools.model.functions.Predicate1;
import org.drools.ruleunits.dsl.constraints.AbstractConstraint;

public class AlphaConstraintWithRightExtractor<L, R>
extends AbstractConstraint<L, R> {
    private final String rightFieldName;
    private final Function1<L, R> rightExtractor;

    public AlphaConstraintWithRightExtractor(Variable<L> variable, String fieldName, Function1<L, R> leftExtractor, Index.ConstraintType constraintType, String rightFieldName, Function1<L, R> rightExtractor) {
        super(variable, fieldName, leftExtractor, constraintType);
        this.rightFieldName = rightFieldName;
        this.rightExtractor = rightExtractor;
    }

    @Override
    public void addConstraintToPattern(PatternDSL.PatternDef<L> patternDef) {
        String exprId;
        PatternDSL.ReactOn reactOn = null;
        if (this.leftFieldName != null) {
            exprId = this.rightFieldName != null ? "expr:" + this.leftVariable.getType().getCanonicalName() + ":" + this.leftFieldName + ":" + this.constraintType + ":" + this.rightFieldName : UUID.randomUUID().toString();
            reactOn = this.rightFieldName != null ? PatternDSL.reactOn((String[])new String[]{this.leftFieldName, this.rightFieldName}) : PatternDSL.reactOn((String[])new String[]{this.leftFieldName});
        } else {
            exprId = UUID.randomUUID().toString();
        }
        patternDef.expr(exprId, (Predicate1 & Serializable)p -> this.constraintType.asPredicate().test(this.leftExtractor.apply(p), this.rightExtractor.apply(p)), null, reactOn);
    }
}

