/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.dsl;

import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.drools.ruleunits.api.RuleUnitData;
import org.drools.ruleunits.api.RuleUnitInstance;
import org.drools.ruleunits.api.RuleUnitProvider;
import org.drools.ruleunits.dsl.DynamicHelloWorldUnit;
import org.drools.ruleunits.dsl.NamedHelloWorldUnit;
import org.junit.jupiter.api.Test;

class RuleUnitRebuildTest {
    RuleUnitRebuildTest() {
    }

    @Test
    void dynamicHelloWorld() {
        DynamicHelloWorldUnit unit = new DynamicHelloWorldUnit("Hello World");
        unit.getStrings().add((Object)"Hello World");
        try (RuleUnitInstance unitInstance = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)unit);){
            Assertions.assertThat((int)unitInstance.fire()).isEqualTo(1);
            Assertions.assertThat(unit.getResults()).containsExactly((Object[])new String[]{"it worked!"});
        }
        int invalidated = RuleUnitProvider.get().invalidateRuleUnits(DynamicHelloWorldUnit.class);
        ((AbstractIntegerAssert)Assertions.assertThat((int)invalidated).as("Invalidate 1 rule unit", new Object[0])).isEqualTo(1);
        DynamicHelloWorldUnit newUnit = new DynamicHelloWorldUnit("Goodbye World");
        newUnit.getStrings().add((Object)"Hello World");
        try (RuleUnitInstance newUnitInstance = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)newUnit);){
            Assertions.assertThat((int)newUnitInstance.fire()).isZero();
            Assertions.assertThat(newUnit.getResults()).isEmpty();
            newUnit.getStrings().add((Object)"Goodbye World");
            Assertions.assertThat((int)newUnitInstance.fire()).isEqualTo(1);
            Assertions.assertThat(newUnit.getResults()).containsExactly((Object[])new String[]{"it worked!"});
        }
    }

    @Test
    void invalidateMultipleNamedRuleUnits() {
        NamedHelloWorldUnit unit1 = new NamedHelloWorldUnit("Name-1");
        unit1.getStrings().add((Object)"Name-1");
        try (RuleUnitInstance unitInstance = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)unit1);){
            Assertions.assertThat((int)unitInstance.fire()).isEqualTo(1);
            Assertions.assertThat(unit1.getResults()).containsExactly((Object[])new String[]{"it worked!"});
        }
        NamedHelloWorldUnit unit2 = new NamedHelloWorldUnit("Name-2");
        unit2.getStrings().add((Object)"Name-2");
        try (RuleUnitInstance unitInstance = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)unit2);){
            Assertions.assertThat((int)unitInstance.fire()).isEqualTo(1);
            Assertions.assertThat(unit2.getResults()).containsExactly((Object[])new String[]{"it worked!"});
        }
        int invalidated = RuleUnitProvider.get().invalidateRuleUnits(NamedHelloWorldUnit.class);
        ((AbstractIntegerAssert)Assertions.assertThat((int)invalidated).as("Invalidate 2 rule units", new Object[0])).isEqualTo(2);
        NamedHelloWorldUnit unit3 = new NamedHelloWorldUnit("Name-3");
        unit3.getStrings().add((Object)"Name-3");
        try (RuleUnitInstance newUnitInstance = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)unit3);){
            Assertions.assertThat((int)newUnitInstance.fire()).isEqualTo(1);
            Assertions.assertThat(unit3.getResults()).containsExactly((Object[])new String[]{"it worked!"});
        }
    }
}

