/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.impl;

import java.util.ArrayList;
import java.util.List;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.spi.Activation;
import org.drools.core.util.bitmask.BitMask;
import org.drools.ruleunits.api.DataHandle;
import org.drools.ruleunits.api.DataProcessor;
import org.drools.ruleunits.api.SingletonStore;
import org.drools.ruleunits.impl.EntryPointDataProcessor;
import org.drools.ruleunits.impl.InternalStoreCallback;
import org.drools.ruleunits.impl.facthandles.RuleUnitInternalFactHandle;
import org.drools.ruleunits.impl.factory.DataHandleImpl;
import org.kie.api.runtime.rule.FactHandle;

public class FieldDataStore<T>
implements SingletonStore<T>,
InternalStoreCallback {
    private DataHandle handle = null;
    private final List<EntryPointDataProcessor> entryPointSubscribers = new ArrayList<EntryPointDataProcessor>();
    private final List<DataProcessor<T>> subscribers = new ArrayList<DataProcessor<T>>();

    public DataHandle set(T t) {
        if (this.handle == null && t != null) {
            this.insert(t);
        } else {
            this.clear();
            if (t != null) {
                this.insert(t);
            }
        }
        return this.handle;
    }

    private void insert(T t) {
        this.handle = this.createDataHandle(t);
        this.entryPointSubscribers.forEach(s -> this.internalInsert(this.handle, (DataProcessor)s));
        this.subscribers.forEach(s -> this.internalInsert(this.handle, (DataProcessor)s));
    }

    protected DataHandle createDataHandle(T t) {
        return new DataHandleImpl(t);
    }

    public void update() {
        if (this.handle == null) {
            return;
        }
        DataHandle dh = this.handle;
        this.entryPointSubscribers.forEach(s -> s.update(dh, dh.getObject()));
        this.subscribers.forEach(s -> s.update(dh, dh.getObject()));
    }

    public void clear() {
        if (this.handle == null) {
            return;
        }
        DataHandle dh = this.handle;
        this.handle = null;
        this.entryPointSubscribers.forEach(s -> s.delete(dh));
        this.subscribers.forEach(s -> s.delete(dh));
    }

    public void subscribe(DataProcessor processor) {
        if (processor instanceof EntryPointDataProcessor) {
            EntryPointDataProcessor subscriber = (EntryPointDataProcessor)processor;
            this.entryPointSubscribers.add(subscriber);
        } else {
            this.subscribers.add(processor);
        }
        if (this.handle != null) {
            this.internalInsert(this.handle, processor);
        }
    }

    @Override
    public void update(RuleUnitInternalFactHandle fh, Object obj, BitMask mask, Class<?> modifiedClass, Activation activation) {
        DataHandle dh = fh.getDataHandle();
        this.entryPointSubscribers.forEach(s -> s.update(dh, obj, mask, modifiedClass, activation));
        this.subscribers.forEach(s -> s.update(dh, obj));
    }

    @Override
    public void delete(RuleUnitInternalFactHandle fh, RuleImpl rule, TerminalNode terminalNode, FactHandle.State fhState) {
        DataHandle dh = fh.getDataHandle();
        if (dh != this.handle) {
            throw new IllegalArgumentException("The given handle is not contained in this DataStore");
        }
        this.entryPointSubscribers.forEach(s -> s.delete(dh, rule, terminalNode, fhState));
        this.subscribers.forEach(s -> s.delete(dh));
        this.handle = null;
    }

    private void internalInsert(DataHandle dh, DataProcessor processor) {
        FactHandle fh = processor.insert(dh, dh == null ? null : dh.getObject());
        if (fh != null) {
            ((RuleUnitInternalFactHandle)fh).setDataStore(this);
            ((RuleUnitInternalFactHandle)fh).setDataHandle(dh);
        }
    }
}

