/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.impl;

import org.drools.ruleunits.api.RuleUnitInstance;
import org.drools.ruleunits.impl.HelloWorld;
import org.drools.ruleunits.impl.InMemoryRuleUnitInstanceFactory;
import org.drools.ruleunits.impl.InterpretedRuleUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class InterpretedRuleUnitTest {
    @Test
    public void testHelloWorldInterpreted() {
        HelloWorld unit = new HelloWorld();
        unit.getStrings().add((Object)"Hello World");
        RuleUnitInstance<HelloWorld> unitInstance = InterpretedRuleUnit.instance(unit, false);
        Assertions.assertEquals((int)1, (int)unitInstance.fire());
        Assertions.assertTrue((boolean)unit.getResults().contains("it worked!"));
    }

    @Test
    public void testHelloWorldCompiled() {
        HelloWorld unit = new HelloWorld();
        unit.getStrings().add((Object)"Hello World");
        RuleUnitInstance<HelloWorld> unitInstance = InterpretedRuleUnit.instance(unit, true);
        Assertions.assertEquals((int)1, (int)unitInstance.fire());
        Assertions.assertTrue((boolean)unit.getResults().contains("it worked!"));
    }

    @Test
    public void testHelloWorldGenerated() {
        HelloWorld unit = new HelloWorld();
        unit.getStrings().add((Object)"Hello World");
        RuleUnitInstance<HelloWorld> unitInstance = InMemoryRuleUnitInstanceFactory.generateAndInstance(unit, new String[0]);
        Assertions.assertEquals((int)1, (int)unitInstance.fire());
        Assertions.assertTrue((boolean)unit.getResults().contains("it worked!"));
    }
}

