/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.impl;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.drools.ruleunits.impl.ReflectiveRuleUnitDescription;
import org.drools.ruleunits.impl.SimpleFact;
import org.drools.ruleunits.impl.TestRuleUnit;
import org.drools.ruleunits.impl.UndefinedRuleUnitVariableException;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RuleUnitDescriptionTest {
    private ReflectiveRuleUnitDescription ruleUnitDescr;

    @BeforeEach
    public void prepareRuleUnitDescr() {
        this.ruleUnitDescr = new ReflectiveRuleUnitDescription(TestRuleUnit.class);
    }

    @Test
    public void getRuleUnitClass() {
        Assertions.assertThat((String)this.ruleUnitDescr.getRuleUnitName()).isEqualTo(TestRuleUnit.class.getName());
    }

    @Test
    public void getRuleUnitName() {
        Assertions.assertThat((String)this.ruleUnitDescr.getRuleUnitName()).isEqualTo(TestRuleUnit.class.getName());
    }

    @Test
    public void getRuleUnitVariable() {
        Assertions.assertThat((Object)this.ruleUnitDescr.getVar("number")).isNotNull();
        Assertions.assertThatThrownBy(() -> this.ruleUnitDescr.getVar("undefinedField")).isInstanceOf(UndefinedRuleUnitVariableException.class);
    }

    @Test
    public void getEntryPointId() {
        String entryPointId = this.ruleUnitDescr.getEntryPointName("nonexisting");
        Assertions.assertThat((String)entryPointId).isNotNull();
        this.assertEntryPointIdExists("numbersArray");
        this.assertEntryPointIdExists("number");
        this.assertEntryPointIdExists("stringList");
        this.assertEntryPointIdExists("simpleFactList");
    }

    @Test
    public void getDatasourceType() {
        Optional dataSourceType = this.ruleUnitDescr.getDatasourceType("nonexisting");
        Assertions.assertThat((Optional)dataSourceType).isNotPresent();
        this.assertDataSourceType("strings", String.class);
    }

    @Test
    public void getVarType() {
        Optional varType = this.ruleUnitDescr.getVarType("nonexisting");
        Assertions.assertThat((Optional)varType).isNotPresent();
        this.assertVarType("number", (Type)((Object)BigDecimal.class));
        this.assertVarType("numbersArray", (Type)((Object)Integer[].class));
        this.assertVarType("stringList", new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return new Type[]{String.class};
            }

            @Override
            public Type getRawType() {
                return List.class;
            }

            @Override
            public Type getOwnerType() {
                return null;
            }
        });
        this.assertVarType("simpleFactList", new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return new Type[]{SimpleFact.class};
            }

            @Override
            public Type getRawType() {
                return List.class;
            }

            @Override
            public Type getOwnerType() {
                return null;
            }
        });
    }

    @Test
    public void hasVar() {
        Assertions.assertThat((boolean)this.ruleUnitDescr.hasVar("nonexisting")).isFalse();
        Assertions.assertThat((boolean)this.ruleUnitDescr.hasVar("numbers")).isFalse();
        Assertions.assertThat((boolean)this.ruleUnitDescr.hasVar("number")).isTrue();
        Assertions.assertThat((boolean)this.ruleUnitDescr.hasVar("numbersArray")).isTrue();
        Assertions.assertThat((boolean)this.ruleUnitDescr.hasVar("stringList")).isTrue();
        Assertions.assertThat((boolean)this.ruleUnitDescr.hasVar("simpleFactList")).isTrue();
    }

    @Test
    public void getUnitVars() {
        Collection unitVars = this.ruleUnitDescr.getUnitVars();
        Assertions.assertThat((Collection)unitVars).isNotEmpty();
        Assertions.assertThat((Collection)unitVars).hasSize(6);
        Assertions.assertThat((Collection)unitVars).containsExactlyInAnyOrder((Object[])new String[]{"strings", "bound", "number", "numbersArray", "stringList", "simpleFactList"});
    }

    @Test
    public void getUnitVarAccessors() {
        Collection unitVarAccessors = this.ruleUnitDescr.getUnitVarDeclarations();
        Assertions.assertThat((Collection)unitVarAccessors).isNotEmpty();
        Assertions.assertThat((Collection)unitVarAccessors).hasSize(6);
        Assertions.assertThat((Collection)unitVarAccessors).extracting("name", String.class).containsExactlyInAnyOrder((Object[])new String[]{"strings", "bound", "number", "numbersArray", "stringList", "simpleFactList"});
    }

    @Test
    public void hasDataSource() {
        Assertions.assertThat((boolean)this.ruleUnitDescr.hasDataSource("nonexisting")).isFalse();
        Assertions.assertThat((boolean)this.ruleUnitDescr.hasDataSource("numbers")).isFalse();
        Assertions.assertThat((boolean)this.ruleUnitDescr.hasDataSource("strings")).isTrue();
    }

    private void assertEntryPointIdExists(String entryPointIdName) {
        String entryPointId = this.ruleUnitDescr.getEntryPointName(entryPointIdName);
        Assertions.assertThat((String)entryPointId).isNotNull();
        Assertions.assertThat((String)(TestRuleUnit.class.getName() + "." + entryPointIdName)).isEqualTo(entryPointId);
    }

    private void assertDataSourceType(String dataSourceName, Class<?> expectedType) {
        Optional dataSourceType = this.ruleUnitDescr.getDatasourceType(dataSourceName);
        Assertions.assertThat((Optional)dataSourceType).isPresent();
        Assertions.assertThat(expectedType).isEqualTo(dataSourceType.get());
    }

    private void assertVarType(String varName, Type expectedType) {
        Optional variableTable = this.ruleUnitDescr.getVarType(varName);
        Assertions.assertThat((Optional)variableTable).isPresent();
        Assertions.assertThat((Object)((Type)variableTable.get())).isEqualTo((Object)expectedType);
    }
}

