/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.impl;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.ruleunits.api.DataHandle;
import org.drools.ruleunits.api.DataProcessor;
import org.drools.ruleunits.api.DataSource;
import org.drools.ruleunits.api.DataStream;
import org.junit.jupiter.api.Test;
import org.kie.api.runtime.rule.FactHandle;

public class BufferedDataStreamTest {
    @Test
    public void testCreate() {
        Collector collector = new Collector();
        DataStream integers = DataSource.createBufferedStream((int)2);
        integers.append((Object)1);
        integers.append((Object)2);
        integers.append((Object)3);
        integers.subscribe(collector);
        Assertions.assertThat((int)collector.size()).isEqualTo(2);
        Assertions.assertThat(collector.getList()).containsExactly(new Object[]{2, 3});
    }

    @Test
    public void testAppend() {
        Collector collector = new Collector();
        DataStream integers = DataSource.createBufferedStream((int)2);
        integers.subscribe(collector);
        Assertions.assertThat((int)collector.size()).isEqualTo(0);
        integers.append((Object)10);
        Assertions.assertThat((int)collector.size()).isEqualTo(1);
        integers.append((Object)20);
        integers.append((Object)30);
        Assertions.assertThat((int)collector.size()).isEqualTo(3);
    }

    private static class Collector<T>
    implements DataProcessor<T> {
        private final List<T> list = new ArrayList<T>();

        private Collector() {
        }

        public FactHandle insert(DataHandle handle, T object) {
            this.list.add(object);
            return null;
        }

        public void update(DataHandle handle, T object) {
        }

        public void delete(DataHandle handle) {
        }

        public int size() {
            return this.list.size();
        }

        public List<T> getList() {
            return this.list;
        }
    }
}

