/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.api.model;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.SimulationDescriptor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SimulationDescriptorTest {
    SimulationDescriptor simulationDescriptor;
    FactIdentifier factIdentifier;
    ExpressionIdentifier expressionIdentifier;

    @Before
    public void init() {
        this.simulationDescriptor = new SimulationDescriptor();
        this.factIdentifier = FactIdentifier.create((String)"test fact", (String)String.class.getCanonicalName());
        this.expressionIdentifier = ExpressionIdentifier.create((String)"test expression", (FactMappingType)FactMappingType.EXPECT);
    }

    @Test(expected=IllegalArgumentException.class)
    public void addFactMappingTest() {
        this.simulationDescriptor.addFactMapping(this.factIdentifier, this.expressionIdentifier);
        this.simulationDescriptor.addFactMapping(this.factIdentifier, this.expressionIdentifier);
    }

    @Test(expected=IllegalArgumentException.class)
    public void addFactMappingIndexTest() {
        this.simulationDescriptor.addFactMapping(1, this.factIdentifier, this.expressionIdentifier);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void removeFactMappingByIndex() {
        int testingIndex = 0;
        this.simulationDescriptor.addFactMapping(this.factIdentifier, this.expressionIdentifier);
        Assert.assertNotNull((Object)this.simulationDescriptor.getFactMappingByIndex(testingIndex));
        this.simulationDescriptor.removeFactMappingByIndex(testingIndex);
        this.simulationDescriptor.getFactMappingByIndex(testingIndex);
    }

    @Test
    public void removeFactMapping() {
        FactMapping retrieved = this.simulationDescriptor.addFactMapping(this.factIdentifier, this.expressionIdentifier);
        Assert.assertTrue((boolean)this.simulationDescriptor.getUnmodifiableFactMappings().contains(retrieved));
        this.simulationDescriptor.removeFactMapping(retrieved);
        Assert.assertFalse((boolean)this.simulationDescriptor.getUnmodifiableFactMappings().contains(retrieved));
    }

    @Test
    public void getIndexByIdentifierTest() {
        List originalFactMappings = IntStream.range(0, 2).boxed().map(i -> this.simulationDescriptor.addFactMapping(FactIdentifier.create((String)("test " + i), (String)String.class.getCanonicalName()), this.expressionIdentifier)).collect(Collectors.toList());
        int indexToCheck = 0;
        int indexRetrieved = this.simulationDescriptor.getIndexByIdentifier(((FactMapping)originalFactMappings.get(indexToCheck)).getFactIdentifier(), this.expressionIdentifier);
        Assert.assertEquals((long)indexToCheck, (long)indexRetrieved);
        indexToCheck = 1;
        indexRetrieved = this.simulationDescriptor.getIndexByIdentifier(((FactMapping)originalFactMappings.get(indexToCheck)).getFactIdentifier(), this.expressionIdentifier);
        Assert.assertEquals((long)indexToCheck, (long)indexRetrieved);
    }

    @Test
    public void moveFactMappingTest() {
        ExpressionIdentifier expressionIdentifier2 = ExpressionIdentifier.create((String)"Test expression 2", (FactMappingType)FactMappingType.GIVEN);
        ExpressionIdentifier expressionIdentifier3 = ExpressionIdentifier.create((String)"Test expression 3", (FactMappingType)FactMappingType.GIVEN);
        FactMapping factMapping1 = this.simulationDescriptor.addFactMapping(this.factIdentifier, this.expressionIdentifier);
        FactMapping factMapping2 = this.simulationDescriptor.addFactMapping(this.factIdentifier, expressionIdentifier2);
        FactMapping factMapping3 = this.simulationDescriptor.addFactMapping(this.factIdentifier, expressionIdentifier3);
        List factMappings = this.simulationDescriptor.getUnmodifiableFactMappings();
        Assert.assertEquals(factMappings.get(0), (Object)factMapping1);
        Assert.assertEquals(factMappings.get(1), (Object)factMapping2);
        Assert.assertEquals(factMappings.get(2), (Object)factMapping3);
        this.simulationDescriptor.moveFactMapping(0, 1);
        factMappings = this.simulationDescriptor.getUnmodifiableFactMappings();
        Assert.assertEquals(factMappings.get(0), (Object)factMapping2);
        Assert.assertEquals(factMappings.get(1), (Object)factMapping1);
        Assert.assertEquals(factMappings.get(2), (Object)factMapping3);
        this.simulationDescriptor.moveFactMapping(2, 1);
        factMappings = this.simulationDescriptor.getUnmodifiableFactMappings();
        Assert.assertEquals(factMappings.get(0), (Object)factMapping2);
        Assert.assertEquals(factMappings.get(1), (Object)factMapping3);
        Assert.assertEquals(factMappings.get(2), (Object)factMapping1);
        this.simulationDescriptor.moveFactMapping(2, 2);
        factMappings = this.simulationDescriptor.getUnmodifiableFactMappings();
        Assert.assertEquals(factMappings.get(0), (Object)factMapping2);
        Assert.assertEquals(factMappings.get(1), (Object)factMapping3);
        Assert.assertEquals(factMappings.get(2), (Object)factMapping1);
    }

    @Test
    public void moveFactMappingOldFailTest() {
        ExpressionIdentifier expressionIdentifier2 = ExpressionIdentifier.create((String)"Test expression 2", (FactMappingType)FactMappingType.GIVEN);
        this.simulationDescriptor.addFactMapping(this.factIdentifier, this.expressionIdentifier);
        this.simulationDescriptor.addFactMapping(this.factIdentifier, expressionIdentifier2);
        this.muteException(() -> {
            this.simulationDescriptor.moveFactMapping(2, 0);
            Assert.fail();
        }, IllegalArgumentException.class);
        this.muteException(() -> {
            this.simulationDescriptor.moveFactMapping(-1, 0);
            Assert.fail();
        }, IllegalArgumentException.class);
        this.muteException(() -> {
            this.simulationDescriptor.moveFactMapping(0, 2);
            Assert.fail();
        }, IllegalArgumentException.class);
        this.muteException(() -> {
            this.simulationDescriptor.moveFactMapping(0, -1);
            Assert.fail();
        }, IllegalArgumentException.class);
    }

    private <T extends Throwable> void muteException(Runnable toBeExecuted, Class<T> expected) {
        block2: {
            try {
                toBeExecuted.run();
            }
            catch (Throwable t) {
                if (t.getClass().isAssignableFrom(expected)) break block2;
                throw t;
            }
        }
    }
}

