/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.api.model;

import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.Simulation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SimulationTest {
    Simulation simulation;
    Scenario originalScenario;

    @Before
    public void setup() {
        this.simulation = new Simulation();
        FactIdentifier factIdentifier = FactIdentifier.create((String)"Test", (String)String.class.getCanonicalName());
        ExpressionIdentifier expressionIdentifier = ExpressionIdentifier.create((String)"Test", (FactMappingType)FactMappingType.GIVEN);
        this.simulation.getSimulationDescriptor().addFactMapping(factIdentifier, expressionIdentifier);
        this.originalScenario = this.simulation.addScenario();
        this.originalScenario.setDescription("Test Description");
        this.originalScenario.addMappingValue(factIdentifier, expressionIdentifier, (Object)"TEST");
    }

    @Test
    public void addScenarioTest() {
        this.simulation.addScenario(1);
        this.muteException(() -> {
            this.simulation.addScenario(-1);
            Assert.fail();
        }, IllegalArgumentException.class);
        this.muteException(() -> {
            this.simulation.addScenario(3);
            Assert.fail();
        }, IllegalArgumentException.class);
    }

    @Test
    public void cloneScenarioTest() {
        Scenario clonedScenario = this.simulation.cloneScenario(0, 1);
        Assert.assertEquals((Object)this.originalScenario.getDescription(), (Object)clonedScenario.getDescription());
        Assert.assertEquals((long)this.originalScenario.getUnmodifiableFactMappingValues().size(), (long)clonedScenario.getUnmodifiableFactMappingValues().size());
        Assert.assertEquals((Object)this.originalScenario, (Object)this.simulation.getScenarioByIndex(0));
        Assert.assertEquals((Object)clonedScenario, (Object)this.simulation.getScenarioByIndex(1));
        Assert.assertNotEquals((Object)this.originalScenario, (Object)clonedScenario);
        Assert.assertNotEquals(this.originalScenario.getUnmodifiableFactMappingValues().get(0), clonedScenario.getUnmodifiableFactMappingValues().get(0));
    }

    @Test
    public void cloneScenarioFail() {
        this.muteException(() -> {
            this.simulation.cloneScenario(-1, 1);
            Assert.fail();
        }, IllegalArgumentException.class);
        this.muteException(() -> {
            this.simulation.cloneScenario(2, 1);
            Assert.fail();
        }, IllegalArgumentException.class);
        this.muteException(() -> {
            this.simulation.cloneScenario(0, -1);
            Assert.fail();
        }, IllegalArgumentException.class);
        this.muteException(() -> {
            this.simulation.cloneScenario(0, 2);
            Assert.fail();
        }, IllegalArgumentException.class);
    }

    @Test
    public void removeFactMappingByIndex() {
        Assert.assertEquals((long)2L, (long)((Scenario)this.simulation.getUnmodifiableScenarios().get(0)).getUnmodifiableFactMappingValues().size());
        Assert.assertEquals((long)1L, (long)this.simulation.getSimulationDescriptor().getUnmodifiableFactMappings().size());
        this.simulation.removeFactMappingByIndex(0);
        Assert.assertEquals((long)1L, (long)((Scenario)this.simulation.getUnmodifiableScenarios().get(0)).getUnmodifiableFactMappingValues().size());
        Assert.assertEquals((long)0L, (long)this.simulation.getSimulationDescriptor().getUnmodifiableFactMappings().size());
    }

    @Test
    public void removeFactMapping() {
        Assert.assertEquals((long)2L, (long)((Scenario)this.simulation.getUnmodifiableScenarios().get(0)).getUnmodifiableFactMappingValues().size());
        Assert.assertEquals((long)1L, (long)this.simulation.getSimulationDescriptor().getUnmodifiableFactMappings().size());
        this.simulation.removeFactMapping(this.simulation.getSimulationDescriptor().getFactMappingByIndex(0));
        Assert.assertEquals((long)1L, (long)((Scenario)this.simulation.getUnmodifiableScenarios().get(0)).getUnmodifiableFactMappingValues().size());
        Assert.assertEquals((long)0L, (long)this.simulation.getSimulationDescriptor().getUnmodifiableFactMappings().size());
    }

    private <T extends Throwable> void muteException(Runnable toBeExecuted, Class<T> expected) {
        block2: {
            try {
                toBeExecuted.run();
            }
            catch (Throwable t) {
                if (t.getClass().isAssignableFrom(expected)) break block2;
                throw t;
            }
        }
    }
}

