/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.api.model;

import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.FactMappingValueStatus;
import org.junit.Test;

public class FactMappingValueTest {
    @Test
    public void emptyFactMappingValue() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new FactMappingValue(null, ExpressionIdentifier.DESCRIPTION, null)).isInstanceOf(NullPointerException.class)).hasMessage("FactIdentifier has to be not null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new FactMappingValue(FactIdentifier.DESCRIPTION, null, null)).isInstanceOf(NullPointerException.class)).hasMessage("ExpressionIdentifier has to be not null");
    }

    @Test
    public void resetStatus() {
        FactMappingValue value = new FactMappingValue();
        value.resetStatus();
        Assertions.assertThat((Comparable)value.getStatus()).isEqualTo((Object)FactMappingValueStatus.SUCCESS);
        Assertions.assertThat((String)value.getExceptionMessage()).isNull();
        Assertions.assertThat((Object)value.getErrorValue()).isNull();
    }

    @Test
    public void setErrorValue() {
        String errorValue = "value";
        FactMappingValue value = new FactMappingValue();
        value.setErrorValue((Object)errorValue);
        Assertions.assertThat((Comparable)value.getStatus()).isEqualTo((Object)FactMappingValueStatus.FAILED_WITH_ERROR);
        Assertions.assertThat((String)value.getExceptionMessage()).isNull();
        Assertions.assertThat((Object)value.getErrorValue()).isEqualTo((Object)errorValue);
    }

    @Test
    public void setExceptionMessage() {
        String exceptionValue = "Exception";
        FactMappingValue value = new FactMappingValue();
        value.setExceptionMessage(exceptionValue);
        Assertions.assertThat((Comparable)value.getStatus()).isEqualTo((Object)FactMappingValueStatus.FAILED_WITH_EXCEPTION);
        Assertions.assertThat((String)value.getExceptionMessage()).isEqualTo((Object)exceptionValue);
        Assertions.assertThat((Object)value.getErrorValue()).isNull();
    }
}

