/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.api.model;

import java.util.Optional;
import org.drools.scenariosimulation.api.model.Background;
import org.drools.scenariosimulation.api.model.BackgroundData;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.ScesimModelDescriptor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BackgroundDataTest {
    private ScesimModelDescriptor scesimModelDescriptor;
    private BackgroundData backgroundData;
    private FactIdentifier factIdentifier;
    private ExpressionIdentifier expressionIdentifier;
    private Background background;

    @Before
    public void init() {
        this.background = new Background();
        this.scesimModelDescriptor = this.background.getScesimModelDescriptor();
        this.backgroundData = (BackgroundData)this.background.addData();
        this.factIdentifier = FactIdentifier.create((String)"test fact", (String)String.class.getCanonicalName());
        this.expressionIdentifier = ExpressionIdentifier.create((String)"test expression", (FactMappingType)FactMappingType.EXPECT);
    }

    @Test
    public void removeFactMappingValueByIdentifiersTest() {
        this.backgroundData.addMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)"test value");
        Optional retrieved = this.backgroundData.getFactMappingValue(this.factIdentifier, this.expressionIdentifier);
        Assert.assertTrue((boolean)retrieved.isPresent());
        this.backgroundData.removeFactMappingValueByIdentifiers(this.factIdentifier, this.expressionIdentifier);
        retrieved = this.backgroundData.getFactMappingValue(this.factIdentifier, this.expressionIdentifier);
        Assert.assertFalse((boolean)retrieved.isPresent());
    }

    @Test
    public void removeFactMappingValue() {
        this.backgroundData.addMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)"test value");
        Optional retrieved = this.backgroundData.getFactMappingValue(this.factIdentifier, this.expressionIdentifier);
        Assert.assertTrue((boolean)retrieved.isPresent());
        this.backgroundData.removeFactMappingValue((FactMappingValue)retrieved.get());
        retrieved = this.backgroundData.getFactMappingValue(this.factIdentifier, this.expressionIdentifier);
        Assert.assertFalse((boolean)retrieved.isPresent());
    }

    @Test(expected=IllegalArgumentException.class)
    public void addMappingValueTest() {
        this.backgroundData.addMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)"test value");
        this.backgroundData.addMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)"test value");
    }

    @Test
    public void getDescriptionTest() {
        Assert.assertEquals((Object)"", (Object)this.backgroundData.getDescription());
        String description = "Test Description";
        this.backgroundData.addMappingValue(FactIdentifier.DESCRIPTION, ExpressionIdentifier.DESCRIPTION, (Object)description);
        Assert.assertEquals((Object)description, (Object)this.backgroundData.getDescription());
        BackgroundData scenarioWithDescriptionNull = (BackgroundData)this.background.addData();
        scenarioWithDescriptionNull.setDescription(null);
        Assert.assertEquals((Object)"", (Object)scenarioWithDescriptionNull.getDescription());
    }

    @Test
    public void addOrUpdateMappingValue() {
        String value1 = "Test 1";
        String value2 = "Test 2";
        FactMappingValue factMappingValue = this.backgroundData.addMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)value1);
        Assert.assertEquals((Object)factMappingValue.getRawValue(), (Object)value1);
        FactMappingValue factMappingValue1 = this.backgroundData.addOrUpdateMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)value2);
        Assert.assertEquals((Object)factMappingValue, (Object)factMappingValue1);
        Assert.assertEquals((Object)factMappingValue1.getRawValue(), (Object)value2);
    }
}

