/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.api.model;

import java.util.List;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.api.model.Background;
import org.drools.scenariosimulation.api.model.BackgroundData;
import org.drools.scenariosimulation.api.model.BackgroundDataWithIndex;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.ScesimModelDescriptor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BackgroundTest {
    private Background background;
    private BackgroundData originalBackgroundData;

    @Before
    public void setup() {
        this.background = new Background();
        FactIdentifier factIdentifier = FactIdentifier.create((String)"Test", (String)String.class.getCanonicalName());
        ExpressionIdentifier expressionIdentifier = ExpressionIdentifier.create((String)"Test", (FactMappingType)FactMappingType.GIVEN);
        this.background.getScesimModelDescriptor().addFactMapping(factIdentifier, expressionIdentifier);
        this.originalBackgroundData = (BackgroundData)this.background.addData();
        this.originalBackgroundData.setDescription("Test Description");
        this.originalBackgroundData.addMappingValue(factIdentifier, expressionIdentifier, (Object)"TEST");
    }

    @Test
    public void addData() {
        this.background.addData(1);
        Assertions.assertThatThrownBy(() -> this.background.addData(-1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.background.addData(3)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    public void cloneModel() {
        Background cloned = this.background.cloneModel();
        Assert.assertNotNull((Object)cloned);
        ScesimModelDescriptor originalDescriptor = this.background.getScesimModelDescriptor();
        ScesimModelDescriptor clonedDescriptor = cloned.getScesimModelDescriptor();
        Assert.assertEquals((long)originalDescriptor.getUnmodifiableFactMappings().size(), (long)clonedDescriptor.getUnmodifiableFactMappings().size());
        IntStream.range(0, originalDescriptor.getUnmodifiableFactMappings().size()).forEach(index -> Assert.assertEquals(originalDescriptor.getUnmodifiableFactMappings().get(index), clonedDescriptor.getUnmodifiableFactMappings().get(index)));
        Assert.assertEquals((long)this.background.getUnmodifiableData().size(), (long)cloned.getUnmodifiableData().size());
        IntStream.range(0, this.background.getUnmodifiableData().size()).forEach(index -> Assert.assertEquals((Object)((BackgroundData)this.background.getUnmodifiableData().get(index)).getDescription(), (Object)((BackgroundData)cloned.getUnmodifiableData().get(index)).getDescription()));
    }

    @Test
    public void cloneData() {
        BackgroundData clonedBackgroundData = (BackgroundData)this.background.cloneData(0, 1);
        Assert.assertEquals((Object)this.originalBackgroundData.getDescription(), (Object)clonedBackgroundData.getDescription());
        Assert.assertEquals((long)this.originalBackgroundData.getUnmodifiableFactMappingValues().size(), (long)clonedBackgroundData.getUnmodifiableFactMappingValues().size());
        Assert.assertEquals((Object)this.originalBackgroundData, (Object)this.background.getDataByIndex(0));
        Assert.assertEquals((Object)clonedBackgroundData, (Object)this.background.getDataByIndex(1));
        Assert.assertNotEquals((Object)this.originalBackgroundData, (Object)clonedBackgroundData);
        Assert.assertNotEquals(this.originalBackgroundData.getUnmodifiableFactMappingValues().get(0), clonedBackgroundData.getUnmodifiableFactMappingValues().get(0));
    }

    @Test
    public void cloneScesimDataFail() {
        Assertions.assertThatThrownBy(() -> {
            BackgroundData cfr_ignored_0 = (BackgroundData)this.background.cloneData(-1, 1);
        }).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> {
            BackgroundData cfr_ignored_0 = (BackgroundData)this.background.cloneData(2, 1);
        }).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> {
            BackgroundData cfr_ignored_0 = (BackgroundData)this.background.cloneData(0, -1);
        }).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> {
            BackgroundData cfr_ignored_0 = (BackgroundData)this.background.cloneData(0, 2);
        }).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    public void removeFactMappingByIndex() {
        Assert.assertEquals((long)2L, (long)((BackgroundData)this.background.getUnmodifiableData().get(0)).getUnmodifiableFactMappingValues().size());
        Assert.assertEquals((long)1L, (long)this.background.getScesimModelDescriptor().getUnmodifiableFactMappings().size());
        this.background.removeFactMappingByIndex(0);
        Assert.assertEquals((long)1L, (long)((BackgroundData)this.background.getUnmodifiableData().get(0)).getUnmodifiableFactMappingValues().size());
        Assert.assertEquals((long)0L, (long)this.background.getScesimModelDescriptor().getUnmodifiableFactMappings().size());
    }

    @Test
    public void removeFactMapping() {
        Assert.assertEquals((long)2L, (long)((BackgroundData)this.background.getUnmodifiableData().get(0)).getUnmodifiableFactMappingValues().size());
        Assert.assertEquals((long)1L, (long)this.background.getScesimModelDescriptor().getUnmodifiableFactMappings().size());
        this.background.removeFactMapping(this.background.getScesimModelDescriptor().getFactMappingByIndex(0));
        Assert.assertEquals((long)1L, (long)((BackgroundData)this.background.getUnmodifiableData().get(0)).getUnmodifiableFactMappingValues().size());
        Assert.assertEquals((long)0L, (long)this.background.getScesimModelDescriptor().getUnmodifiableFactMappings().size());
    }

    @Test
    public void getBackgroundDataWithIndex() {
        List backgroundDataWithIndex = this.background.getBackgroundDataWithIndex();
        Assert.assertEquals((long)this.background.getUnmodifiableData().size(), (long)backgroundDataWithIndex.size());
        BackgroundDataWithIndex backgroundData = (BackgroundDataWithIndex)backgroundDataWithIndex.get(0);
        int index = backgroundData.getIndex();
        Assert.assertEquals((Object)this.background.getDataByIndex(index - 1), (Object)backgroundData.getScesimData());
    }
}

