/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.api.model;

import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.junit.Assert;
import org.junit.Test;

public class FactIdentifierTest {
    @Test
    public void getClassNameWithoutPackage() {
        this.commonGetClassNameWithoutPackage("test", "com.Test", "Test");
    }

    @Test
    public void getClassNameWithoutPackage_LongPackage() {
        this.commonGetClassNameWithoutPackage("test", "com.project.Test", "Test");
    }

    @Test
    public void getClassNameWithoutPackage_NoPackage() {
        this.commonGetClassNameWithoutPackage("test", "Test", "Test");
    }

    private void commonGetClassNameWithoutPackage(String name, String className, String expectedClassName) {
        FactIdentifier factIdentifier = new FactIdentifier(name, className);
        Assert.assertEquals((Object)expectedClassName, (Object)factIdentifier.getClassNameWithoutPackage());
    }

    @Test
    public void getPackageWithoutClassName() {
        this.commonGetPackageWithoutClassName("test", "com.Test", "com");
    }

    @Test
    public void getPackageWithoutClassName_LongPackage() {
        this.commonGetPackageWithoutClassName("test", "com.project.Test", "com.project");
    }

    @Test
    public void getPackageWithoutClassName_NoPackage() {
        this.commonGetPackageWithoutClassName("test", "Test", "");
    }

    private void commonGetPackageWithoutClassName(String name, String className, String expectedPackage) {
        FactIdentifier factIdentifier = new FactIdentifier(name, className);
        Assert.assertEquals((Object)expectedPackage, (Object)factIdentifier.getPackageWithoutClassName());
    }
}

