/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.api.model;

import java.util.ArrayList;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.junit.Assert;
import org.junit.Test;

public class FactMappingTest {
    @Test
    public void cloneFactMapping() {
        FactMapping original = new FactMapping("FACT_ALIAS", FactIdentifier.create((String)"FI_TEST", (String)"com.test.Foo"), new ExpressionIdentifier("EI_TEST", FactMappingType.GIVEN));
        original.addExpressionElement("FIRST_STEP", String.class.getName());
        original.setExpressionAlias("EA_TEST");
        original.setGenericTypes(new ArrayList());
        FactMapping retrieved = original.cloneFactMapping();
        Assert.assertTrue((boolean)retrieved.equals((Object)original));
    }

    @Test
    public void getExpressionElementsWithoutClass() {
        FactMapping original = new FactMapping("FACT_ALIAS", FactIdentifier.create((String)"FI_TEST", (String)"com.test.Foo"), new ExpressionIdentifier("EI_TEST", FactMappingType.GIVEN));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((FactMapping)original).getExpressionElementsWithoutClass()).isInstanceOf(IllegalStateException.class)).hasMessage("ExpressionElements malformed");
        Assert.assertEquals((long)0L, (long)original.getExpressionElements().size());
        original.addExpressionElement("STEP", String.class.getCanonicalName());
        Assert.assertEquals((long)0L, (long)original.getExpressionElementsWithoutClass().size());
        Assert.assertEquals((long)1L, (long)original.getExpressionElements().size());
    }
}

