/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.api.model;

import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.Settings;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SettingsTest {
    private static final String DMO_SESSION = "dmoSession";
    private static final String DMN_PATH = "dmnfile.dmn";
    private static final String DMN_NAME = "dmnName";
    private static final String DMN_NAMESPACE = "dmnNameSpace";
    private static final String RULE_FLOW_GROUP = "ruleFlowGroup";
    private static final String FILENAME = "fileName";
    private static final String KIE_BASE = "kieBase";
    private static final String KIE_SESSION = "kieSession";
    private Settings settings;

    @Before
    public void setup() {
        this.settings = new Settings();
        this.settings.setDmoSession(DMO_SESSION);
        this.settings.setDmnFilePath(DMN_PATH);
        this.settings.setDmnName(DMN_NAME);
        this.settings.setDmnNamespace(DMN_NAMESPACE);
        this.settings.setRuleFlowGroup(RULE_FLOW_GROUP);
        this.settings.setType(ScenarioSimulationModel.Type.RULE);
        this.settings.setStateless(true);
        this.settings.setSkipFromBuild(true);
        this.settings.setFileName(FILENAME);
        this.settings.setKieBase(KIE_BASE);
        this.settings.setKieSession(KIE_SESSION);
    }

    @Test
    public void cloneEmptySettings() {
        Settings cloneSettings = new Settings().cloneSettings();
        Assert.assertNull((Object)cloneSettings.getDmoSession());
        Assert.assertNull((Object)cloneSettings.getDmnFilePath());
        Assert.assertNull((Object)cloneSettings.getDmnName());
        Assert.assertNull((Object)cloneSettings.getDmnNamespace());
        Assert.assertNull((Object)cloneSettings.getRuleFlowGroup());
        Assert.assertNull((Object)cloneSettings.getType());
        Assert.assertFalse((boolean)cloneSettings.isStateless());
        Assert.assertFalse((boolean)cloneSettings.isSkipFromBuild());
        Assert.assertNull((Object)cloneSettings.getFileName());
        Assert.assertNull((Object)cloneSettings.getKieBase());
        Assert.assertNull((Object)cloneSettings.getKieSession());
    }

    @Test
    public void cloneSettings() {
        Settings cloneSettings = this.settings.cloneSettings();
        Assert.assertEquals((Object)DMO_SESSION, (Object)cloneSettings.getDmoSession());
        Assert.assertEquals((Object)DMN_PATH, (Object)cloneSettings.getDmnFilePath());
        Assert.assertEquals((Object)DMN_NAME, (Object)cloneSettings.getDmnName());
        Assert.assertEquals((Object)DMN_NAMESPACE, (Object)cloneSettings.getDmnNamespace());
        Assert.assertEquals((Object)RULE_FLOW_GROUP, (Object)cloneSettings.getRuleFlowGroup());
        Assert.assertEquals((Object)ScenarioSimulationModel.Type.RULE, (Object)cloneSettings.getType());
        Assert.assertTrue((boolean)cloneSettings.isStateless());
        Assert.assertTrue((boolean)cloneSettings.isSkipFromBuild());
        Assert.assertEquals((Object)FILENAME, (Object)cloneSettings.getFileName());
        Assert.assertEquals((Object)KIE_BASE, (Object)cloneSettings.getKieBase());
        Assert.assertEquals((Object)KIE_SESSION, (Object)cloneSettings.getKieSession());
    }

    @Test
    public void cloneSettingsAndModifyIt() {
        Settings cloneSettings = this.settings.cloneSettings();
        cloneSettings.setDmoSession("dmoSessioncl");
        this.settings.setDmnFilePath("src/dmnfile.dmn");
        this.settings.setDmnName("cldmnName");
        this.settings.setDmnNamespace("cldmnNameSpace");
        this.settings.setRuleFlowGroup("clruleFlowGroup");
        this.settings.setType(ScenarioSimulationModel.Type.DMN);
        this.settings.setStateless(false);
        this.settings.setSkipFromBuild(false);
        this.settings.setFileName("clfileName");
        this.settings.setKieBase("clkieBase");
        this.settings.setKieSession("clkieSession");
        Assert.assertNotEquals((Object)this.settings.getDmoSession(), (Object)cloneSettings.getDmoSession());
        Assert.assertNotEquals((Object)this.settings.getDmnFilePath(), (Object)cloneSettings.getDmnFilePath());
        Assert.assertNotEquals((Object)this.settings.getDmnName(), (Object)cloneSettings.getDmnName());
        Assert.assertNotEquals((Object)this.settings.getDmnNamespace(), (Object)cloneSettings.getDmnNamespace());
        Assert.assertNotEquals((Object)this.settings.getRuleFlowGroup(), (Object)cloneSettings.getRuleFlowGroup());
        Assert.assertNotEquals((Object)this.settings.getType(), (Object)cloneSettings.getType());
        Assert.assertNotEquals((Object)this.settings.isStateless(), (Object)cloneSettings.isStateless());
        Assert.assertNotEquals((Object)this.settings.isSkipFromBuild(), (Object)cloneSettings.isSkipFromBuild());
        Assert.assertNotEquals((Object)this.settings.getFileName(), (Object)cloneSettings.getFileName());
        Assert.assertNotEquals((Object)this.settings.getKieBase(), (Object)cloneSettings.getKieBase());
        Assert.assertNotEquals((Object)this.settings.getKieSession(), (Object)cloneSettings.getKieSession());
    }
}

