/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.api.model;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.drools.scenariosimulation.api.model.ExpressionElement;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.FactMappingValueType;

public class FactMapping {
    private List<ExpressionElement> expressionElements = new LinkedList<ExpressionElement>();
    private ExpressionIdentifier expressionIdentifier;
    private FactIdentifier factIdentifier;
    private String className;
    private String factAlias;
    private String expressionAlias;
    private List<String> genericTypes;
    private FactMappingValueType factMappingValueType = FactMappingValueType.NOT_EXPRESSION;
    private Double columnWidth;

    public FactMapping() {
    }

    public FactMapping(FactIdentifier factIdentifier, ExpressionIdentifier expressionIdentifier) {
        this(factIdentifier.getName(), factIdentifier, expressionIdentifier);
    }

    public FactMapping(String factAlias, FactIdentifier factIdentifier, ExpressionIdentifier expressionIdentifier) {
        this.factAlias = factAlias;
        this.expressionIdentifier = expressionIdentifier;
        this.className = factIdentifier.getClassName();
        this.factIdentifier = factIdentifier;
    }

    private FactMapping(FactMapping original) {
        original.expressionElements.forEach(expressionElement -> this.addExpressionElement(expressionElement.getStep(), original.className));
        this.expressionIdentifier = original.expressionIdentifier;
        this.factIdentifier = original.factIdentifier;
        this.className = original.className;
        this.factAlias = original.factAlias;
        this.expressionAlias = original.expressionAlias;
        this.genericTypes = original.genericTypes;
        this.factMappingValueType = original.factMappingValueType;
        this.columnWidth = original.columnWidth;
    }

    public String getFullExpression() {
        return this.expressionElements.stream().map(ExpressionElement::getStep).collect(Collectors.joining("."));
    }

    public List<ExpressionElement> getExpressionElementsWithoutClass() {
        if (this.expressionElements.isEmpty()) {
            throw new IllegalStateException("ExpressionElements malformed");
        }
        return this.expressionElements.subList(1, this.expressionElements.size());
    }

    public List<ExpressionElement> getExpressionElements() {
        return this.expressionElements;
    }

    public void addExpressionElement(String stepName, String className) {
        this.className = className;
        this.expressionElements.add(new ExpressionElement(stepName));
    }

    public String getClassName() {
        return this.className;
    }

    public ExpressionIdentifier getExpressionIdentifier() {
        return this.expressionIdentifier;
    }

    public FactIdentifier getFactIdentifier() {
        return this.factIdentifier;
    }

    public String getFactAlias() {
        return this.factAlias;
    }

    public void setFactAlias(String factAlias) {
        this.factAlias = factAlias;
    }

    public String getExpressionAlias() {
        return this.expressionAlias;
    }

    public void setExpressionAlias(String expressionAlias) {
        this.expressionAlias = expressionAlias;
    }

    public List<String> getGenericTypes() {
        return this.genericTypes;
    }

    public void setGenericTypes(List<String> genericTypes) {
        this.genericTypes = genericTypes;
    }

    public FactMapping cloneFactMapping() {
        return new FactMapping(this);
    }

    public static String getPlaceHolder(FactMappingType factMappingType) {
        return factMappingType.name();
    }

    public static String getPlaceHolder(FactMappingType factMappingType, int index) {
        return FactMapping.getPlaceHolder(factMappingType) + " " + index;
    }

    public FactMappingValueType getFactMappingValueType() {
        return this.factMappingValueType;
    }

    public void setFactMappingValueType(FactMappingValueType factMappingValueType) {
        this.factMappingValueType = factMappingValueType;
    }

    public static String getInstancePlaceHolder(int index) {
        return "INSTANCE " + index;
    }

    public static String getPropertyPlaceHolder(int index) {
        return "PROPERTY " + index;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FactMapping that = (FactMapping)o;
        return this.getExpressionElements().equals(that.getExpressionElements()) && Objects.equals(this.getExpressionIdentifier(), that.getExpressionIdentifier()) && Objects.equals(this.getFactIdentifier(), that.getFactIdentifier()) && Objects.equals(this.getClassName(), that.getClassName()) && Objects.equals(this.getFactAlias(), that.getFactAlias()) && Objects.equals(this.getExpressionAlias(), that.getExpressionAlias()) && Objects.equals(this.getGenericTypes(), that.getGenericTypes()) && Objects.equals((Object)this.getFactMappingValueType(), (Object)that.getFactMappingValueType());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getExpressionElements(), this.getExpressionIdentifier(), this.getFactIdentifier(), this.getClassName(), this.getFactAlias(), this.getExpressionAlias(), this.getGenericTypes(), this.getFactMappingValueType()});
    }

    public Double getColumnWidth() {
        return this.columnWidth;
    }

    public void setColumnWidth(Double columnWidth) {
        this.columnWidth = columnWidth;
    }
}

