/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.api.model;

import java.util.List;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.api.model.Background;
import org.drools.scenariosimulation.api.model.BackgroundData;
import org.drools.scenariosimulation.api.model.BackgroundDataWithIndex;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.ScesimModelDescriptor;
import org.junit.Before;
import org.junit.Test;

public class BackgroundTest {
    private Background background;
    private BackgroundData originalBackgroundData;

    @Before
    public void setup() {
        this.background = new Background();
        FactIdentifier factIdentifier = FactIdentifier.create((String)"Test", (String)String.class.getCanonicalName());
        ExpressionIdentifier expressionIdentifier = ExpressionIdentifier.create((String)"Test", (FactMappingType)FactMappingType.GIVEN);
        this.background.getScesimModelDescriptor().addFactMapping(factIdentifier, expressionIdentifier);
        this.originalBackgroundData = (BackgroundData)this.background.addData();
        this.originalBackgroundData.setDescription("Test Description");
        this.originalBackgroundData.addMappingValue(factIdentifier, expressionIdentifier, (Object)"TEST");
    }

    @Test
    public void addData() {
        this.background.addData(1);
        Assertions.assertThatThrownBy(() -> this.background.addData(-1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.background.addData(3)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    public void cloneModel() {
        Background cloned = this.background.cloneModel();
        Assertions.assertThat((Object)cloned).isNotNull();
        ScesimModelDescriptor originalDescriptor = this.background.getScesimModelDescriptor();
        ScesimModelDescriptor clonedDescriptor = cloned.getScesimModelDescriptor();
        Assertions.assertThat((int)clonedDescriptor.getUnmodifiableFactMappings().size()).isEqualTo(originalDescriptor.getUnmodifiableFactMappings().size());
        IntStream.range(0, originalDescriptor.getUnmodifiableFactMappings().size()).forEach(index -> Assertions.assertThat((Object)((FactMapping)clonedDescriptor.getUnmodifiableFactMappings().get(index))).isEqualTo(originalDescriptor.getUnmodifiableFactMappings().get(index)));
        Assertions.assertThat((int)cloned.getUnmodifiableData().size()).isEqualTo(this.background.getUnmodifiableData().size());
        IntStream.range(0, this.background.getUnmodifiableData().size()).forEach(index -> Assertions.assertThat((String)((BackgroundData)cloned.getUnmodifiableData().get(index)).getDescription()).isEqualTo(((BackgroundData)this.background.getUnmodifiableData().get(index)).getDescription()));
    }

    @Test
    public void cloneData() {
        BackgroundData clonedBackgroundData = (BackgroundData)this.background.cloneData(0, 1);
        Assertions.assertThat((String)clonedBackgroundData.getDescription()).isEqualTo(this.originalBackgroundData.getDescription());
        Assertions.assertThat((int)clonedBackgroundData.getUnmodifiableFactMappingValues().size()).isEqualTo(this.originalBackgroundData.getUnmodifiableFactMappingValues().size());
        Assertions.assertThat((Object)((BackgroundData)this.background.getDataByIndex(0))).isEqualTo((Object)this.originalBackgroundData);
        Assertions.assertThat((Object)((BackgroundData)this.background.getDataByIndex(1))).isEqualTo((Object)clonedBackgroundData);
        Assertions.assertThat((Object)clonedBackgroundData).isNotEqualTo((Object)this.originalBackgroundData);
        Assertions.assertThat((Object)((FactMappingValue)clonedBackgroundData.getUnmodifiableFactMappingValues().get(0))).isNotEqualTo(this.originalBackgroundData.getUnmodifiableFactMappingValues().get(0));
    }

    @Test
    public void cloneScesimDataFail() {
        Assertions.assertThatThrownBy(() -> this.background.cloneData(-1, 1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.background.cloneData(2, 1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.background.cloneData(0, -1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.background.cloneData(0, 2)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    public void removeFactMappingByIndex() {
        Assertions.assertThat((int)((BackgroundData)this.background.getUnmodifiableData().get(0)).getUnmodifiableFactMappingValues().size()).isEqualTo(2);
        Assertions.assertThat((int)this.background.getScesimModelDescriptor().getUnmodifiableFactMappings().size()).isEqualTo(1);
        this.background.removeFactMappingByIndex(0);
        Assertions.assertThat((int)((BackgroundData)this.background.getUnmodifiableData().get(0)).getUnmodifiableFactMappingValues().size()).isEqualTo(1);
        Assertions.assertThat((int)this.background.getScesimModelDescriptor().getUnmodifiableFactMappings().size()).isEqualTo(0);
    }

    @Test
    public void removeFactMapping() {
        Assertions.assertThat((int)((BackgroundData)this.background.getUnmodifiableData().get(0)).getUnmodifiableFactMappingValues().size()).isEqualTo(2);
        Assertions.assertThat((int)this.background.getScesimModelDescriptor().getUnmodifiableFactMappings().size()).isEqualTo(1);
        this.background.removeFactMapping(this.background.getScesimModelDescriptor().getFactMappingByIndex(0));
        Assertions.assertThat((int)((BackgroundData)this.background.getUnmodifiableData().get(0)).getUnmodifiableFactMappingValues().size()).isEqualTo(1);
        Assertions.assertThat((int)this.background.getScesimModelDescriptor().getUnmodifiableFactMappings().size()).isEqualTo(0);
    }

    @Test
    public void getBackgroundDataWithIndex() {
        List backgroundDataWithIndex = this.background.getBackgroundDataWithIndex();
        Assertions.assertThat((int)backgroundDataWithIndex.size()).isEqualTo(this.background.getUnmodifiableData().size());
        BackgroundDataWithIndex backgroundData = (BackgroundDataWithIndex)backgroundDataWithIndex.get(0);
        int index = backgroundData.getIndex();
        Assertions.assertThat((Object)((BackgroundData)backgroundData.getScesimData())).isEqualTo((Object)this.background.getDataByIndex(index - 1));
    }
}

