/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.api.model;

import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScesimModelDescriptor;
import org.drools.scenariosimulation.api.model.Simulation;
import org.junit.Before;
import org.junit.Test;

public class ScenarioTest {
    private ScesimModelDescriptor scesimModelDescriptor;
    private Scenario scenario;
    private FactIdentifier factIdentifier;
    private ExpressionIdentifier expressionIdentifier;
    private Simulation simulation;

    @Before
    public void init() {
        this.simulation = new Simulation();
        this.scesimModelDescriptor = this.simulation.getScesimModelDescriptor();
        this.scenario = (Scenario)this.simulation.addData();
        this.factIdentifier = FactIdentifier.create((String)"test fact", (String)String.class.getCanonicalName());
        this.expressionIdentifier = ExpressionIdentifier.create((String)"test expression", (FactMappingType)FactMappingType.EXPECT);
    }

    @Test
    public void removeFactMappingValueByIdentifiersTest() {
        this.scenario.addMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)"test value");
        Optional retrieved = this.scenario.getFactMappingValue(this.factIdentifier, this.expressionIdentifier);
        Assertions.assertThat((boolean)retrieved.isPresent()).isTrue();
        this.scenario.removeFactMappingValueByIdentifiers(this.factIdentifier, this.expressionIdentifier);
        retrieved = this.scenario.getFactMappingValue(this.factIdentifier, this.expressionIdentifier);
        Assertions.assertThat((boolean)retrieved.isPresent()).isFalse();
    }

    @Test
    public void removeFactMappingValue() {
        this.scenario.addMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)"test value");
        Optional retrieved = this.scenario.getFactMappingValue(this.factIdentifier, this.expressionIdentifier);
        Assertions.assertThat((boolean)retrieved.isPresent()).isTrue();
        this.scenario.removeFactMappingValue((FactMappingValue)retrieved.get());
        retrieved = this.scenario.getFactMappingValue(this.factIdentifier, this.expressionIdentifier);
        Assertions.assertThat((boolean)retrieved.isPresent()).isFalse();
    }

    @Test(expected=IllegalArgumentException.class)
    public void addMappingValueTest() {
        this.scenario.addMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)"test value");
        this.scenario.addMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)"test value");
    }

    @Test
    public void getDescriptionTest() {
        Assertions.assertThat((String)this.scenario.getDescription()).isEqualTo("");
        String description = "Test Description";
        this.scenario.addMappingValue(FactIdentifier.DESCRIPTION, ExpressionIdentifier.DESCRIPTION, (Object)description);
        Assertions.assertThat((String)this.scenario.getDescription()).isEqualTo(description);
        Scenario scenarioWithDescriptionNull = (Scenario)this.simulation.addData();
        scenarioWithDescriptionNull.setDescription(null);
        Assertions.assertThat((String)scenarioWithDescriptionNull.getDescription()).isEqualTo("");
    }

    @Test
    public void addOrUpdateMappingValue() {
        String value1 = "Test 1";
        String value2 = "Test 2";
        FactMappingValue factMappingValue = this.scenario.addMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)value1);
        Assertions.assertThat((Object)value1).isEqualTo(factMappingValue.getRawValue());
        FactMappingValue factMappingValue1 = this.scenario.addOrUpdateMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)value2);
        Assertions.assertThat((Object)factMappingValue1).isEqualTo((Object)factMappingValue);
        Assertions.assertThat((Object)value2).isEqualTo(factMappingValue1.getRawValue());
    }
}

