/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.api.model;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.ScesimModelDescriptor;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ScesimModelDescriptorTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private ScesimModelDescriptor scesimModelDescriptor;
    private FactIdentifier factIdentifier;
    private ExpressionIdentifier expressionIdentifier;
    private FactIdentifier factIdentifier2;
    private ExpressionIdentifier expressionIdentifier2;

    @Before
    public void init() {
        this.scesimModelDescriptor = new ScesimModelDescriptor();
        this.factIdentifier = FactIdentifier.create((String)"test fact", (String)String.class.getCanonicalName());
        this.expressionIdentifier = ExpressionIdentifier.create((String)"test expression", (FactMappingType)FactMappingType.EXPECT);
        this.factIdentifier2 = FactIdentifier.create((String)"test fact 2", (String)Integer.class.getCanonicalName());
        this.expressionIdentifier2 = ExpressionIdentifier.create((String)"test expression 2", (FactMappingType)FactMappingType.GIVEN);
    }

    @Test
    public void getFactIdentifiers() {
        this.scesimModelDescriptor.addFactMapping(this.factIdentifier, this.expressionIdentifier);
        Set retrieved = this.scesimModelDescriptor.getFactIdentifiers();
        Assertions.assertThat((Iterable)retrieved).isNotNull();
        Assertions.assertThat((int)retrieved.size()).isEqualTo(1);
        Assertions.assertThat((Object)((FactIdentifier)retrieved.iterator().next())).isEqualTo((Object)this.factIdentifier);
    }

    @Test
    public void addFactMappingByIndexAndFactMapping() {
        FactMapping toClone = new FactMapping();
        toClone.setFactAlias("ALIAS");
        toClone.setExpressionAlias("EXPRESSION_ALIAS");
        FactMapping cloned = this.scesimModelDescriptor.addFactMapping(0, toClone);
        Assertions.assertThat((String)cloned.getFactAlias()).isEqualTo(toClone.getFactAlias());
        Assertions.assertThat((String)cloned.getExpressionAlias()).isEqualTo(toClone.getExpressionAlias());
    }

    @Test
    public void addFactMappingByFactIdentifierAndExpressionIdentifier() {
        this.scesimModelDescriptor.addFactMapping(this.factIdentifier, this.expressionIdentifier);
        this.scesimModelDescriptor.addFactMapping(this.factIdentifier2, this.expressionIdentifier2);
        Assertions.assertThat((String)this.scesimModelDescriptor.getFactMappingByIndex(0).getFactAlias()).isEqualTo(this.factIdentifier.getName());
        Assertions.assertThat((Object)this.scesimModelDescriptor.getFactMappingByIndex(0).getFactIdentifier()).isEqualTo((Object)this.factIdentifier);
        Assertions.assertThat((Object)this.scesimModelDescriptor.getFactMappingByIndex(0).getExpressionIdentifier()).isEqualTo((Object)this.expressionIdentifier);
        Assertions.assertThat((String)this.scesimModelDescriptor.getFactMappingByIndex(1).getFactAlias()).isEqualTo(this.factIdentifier2.getName());
        Assertions.assertThat((Object)this.scesimModelDescriptor.getFactMappingByIndex(1).getFactIdentifier()).isEqualTo((Object)this.factIdentifier2);
        Assertions.assertThat((Object)this.scesimModelDescriptor.getFactMappingByIndex(1).getExpressionIdentifier()).isEqualTo((Object)this.expressionIdentifier2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void addFactMappingByFactIdentifierAndExpressionIdentifierFail() {
        this.scesimModelDescriptor.addFactMapping(this.factIdentifier, this.expressionIdentifier);
        this.scesimModelDescriptor.addFactMapping(this.factIdentifier, this.expressionIdentifier);
    }

    @Test
    public void addFactMappingByIndexAndFactIdentifierAndExpressionIdentifier() {
        this.scesimModelDescriptor.addFactMapping(0, this.factIdentifier, this.expressionIdentifier);
        this.scesimModelDescriptor.addFactMapping(0, this.factIdentifier2, this.expressionIdentifier2);
        Assertions.assertThat((String)this.scesimModelDescriptor.getFactMappingByIndex(1).getFactAlias()).isEqualTo(this.factIdentifier.getName());
        Assertions.assertThat((Object)this.scesimModelDescriptor.getFactMappingByIndex(1).getFactIdentifier()).isEqualTo((Object)this.factIdentifier);
        Assertions.assertThat((Object)this.scesimModelDescriptor.getFactMappingByIndex(1).getExpressionIdentifier()).isEqualTo((Object)this.expressionIdentifier);
        Assertions.assertThat((String)this.scesimModelDescriptor.getFactMappingByIndex(0).getFactAlias()).isEqualTo(this.factIdentifier2.getName());
        Assertions.assertThat((Object)this.scesimModelDescriptor.getFactMappingByIndex(0).getFactIdentifier()).isEqualTo((Object)this.factIdentifier2);
        Assertions.assertThat((Object)this.scesimModelDescriptor.getFactMappingByIndex(0).getExpressionIdentifier()).isEqualTo((Object)this.expressionIdentifier2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void addFactMappingByIndexAndFactIdentifierAndExpressionIdentifierFail() {
        this.scesimModelDescriptor.addFactMapping(1, this.factIdentifier, this.expressionIdentifier);
    }

    @Test
    public void removeFactMappingByIndex() {
        int testingIndex = 0;
        this.scesimModelDescriptor.addFactMapping(this.factIdentifier, this.expressionIdentifier);
        Assertions.assertThat((Object)this.scesimModelDescriptor.getFactMappingByIndex(testingIndex)).isNotNull();
        this.scesimModelDescriptor.removeFactMappingByIndex(testingIndex);
        this.expectedException.expect(IndexOutOfBoundsException.class);
        this.scesimModelDescriptor.getFactMappingByIndex(testingIndex);
    }

    @Test
    public void removeFactMapping() {
        FactMapping retrieved = this.scesimModelDescriptor.addFactMapping(this.factIdentifier, this.expressionIdentifier);
        Assertions.assertThat((boolean)this.scesimModelDescriptor.getUnmodifiableFactMappings().contains(retrieved)).isTrue();
        this.scesimModelDescriptor.removeFactMapping(retrieved);
        Assertions.assertThat((boolean)this.scesimModelDescriptor.getUnmodifiableFactMappings().contains(retrieved)).isFalse();
    }

    @Test
    public void getIndexByIdentifierTest() {
        List originalFactMappings = IntStream.range(0, 2).boxed().map(i -> this.scesimModelDescriptor.addFactMapping(FactIdentifier.create((String)("test " + i), (String)String.class.getCanonicalName()), this.expressionIdentifier)).collect(Collectors.toList());
        int indexToCheck = 0;
        int indexRetrieved = this.scesimModelDescriptor.getIndexByIdentifier(((FactMapping)originalFactMappings.get(indexToCheck)).getFactIdentifier(), this.expressionIdentifier);
        Assertions.assertThat((int)indexRetrieved).isEqualTo(indexToCheck);
        indexToCheck = 1;
        indexRetrieved = this.scesimModelDescriptor.getIndexByIdentifier(((FactMapping)originalFactMappings.get(indexToCheck)).getFactIdentifier(), this.expressionIdentifier);
        Assertions.assertThat((int)indexRetrieved).isEqualTo(indexToCheck);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getIndexByIdentifierTestFail() {
        IntStream.range(0, 2).forEach(i -> this.scesimModelDescriptor.addFactMapping(FactIdentifier.create((String)("test " + i), (String)String.class.getCanonicalName()), this.expressionIdentifier));
        FactIdentifier notExisting = new FactIdentifier();
        this.scesimModelDescriptor.getIndexByIdentifier(notExisting, this.expressionIdentifier);
    }

    @Test
    public void getFactMappingsByFactName() {
        IntStream.range(0, 2).forEach(i -> this.scesimModelDescriptor.addFactMapping(FactIdentifier.create((String)"test", (String)String.class.getCanonicalName()), ExpressionIdentifier.create((String)("test expression " + i), (FactMappingType)FactMappingType.EXPECT)));
        this.scesimModelDescriptor.addFactMapping(FactIdentifier.create((String)"TEST", (String)String.class.getCanonicalName()), ExpressionIdentifier.create((String)"test expression 2", (FactMappingType)FactMappingType.EXPECT));
        this.scesimModelDescriptor.addFactMapping(FactIdentifier.create((String)"Test", (String)String.class.getCanonicalName()), ExpressionIdentifier.create((String)"test expression 3", (FactMappingType)FactMappingType.EXPECT));
        this.scesimModelDescriptor.addFactMapping(FactIdentifier.create((String)"tEsT", (String)String.class.getCanonicalName()), ExpressionIdentifier.create((String)"test expression 4", (FactMappingType)FactMappingType.EXPECT));
        Stream retrieved = this.scesimModelDescriptor.getFactMappingsByFactName("test");
        Assertions.assertThat((Stream)retrieved).isNotNull();
        Assertions.assertThat((long)retrieved.count()).isEqualTo(5L);
    }

    @Test
    public void moveFactMappingTest() {
        ExpressionIdentifier expressionIdentifier2 = ExpressionIdentifier.create((String)"Test expression 2", (FactMappingType)FactMappingType.GIVEN);
        ExpressionIdentifier expressionIdentifier3 = ExpressionIdentifier.create((String)"Test expression 3", (FactMappingType)FactMappingType.GIVEN);
        FactMapping factMapping1 = this.scesimModelDescriptor.addFactMapping(this.factIdentifier, this.expressionIdentifier);
        FactMapping factMapping2 = this.scesimModelDescriptor.addFactMapping(this.factIdentifier, expressionIdentifier2);
        FactMapping factMapping3 = this.scesimModelDescriptor.addFactMapping(this.factIdentifier, expressionIdentifier3);
        List factMappings = this.scesimModelDescriptor.getUnmodifiableFactMappings();
        Assertions.assertThat((Object)factMapping1).isEqualTo(factMappings.get(0));
        Assertions.assertThat((Object)factMapping2).isEqualTo(factMappings.get(1));
        Assertions.assertThat((Object)factMapping3).isEqualTo(factMappings.get(2));
        this.scesimModelDescriptor.moveFactMapping(0, 1);
        factMappings = this.scesimModelDescriptor.getUnmodifiableFactMappings();
        Assertions.assertThat((Object)factMapping2).isEqualTo(factMappings.get(0));
        Assertions.assertThat((Object)factMapping1).isEqualTo(factMappings.get(1));
        Assertions.assertThat((Object)factMapping3).isEqualTo(factMappings.get(2));
        this.scesimModelDescriptor.moveFactMapping(2, 1);
        factMappings = this.scesimModelDescriptor.getUnmodifiableFactMappings();
        Assertions.assertThat((Object)factMapping2).isEqualTo(factMappings.get(0));
        Assertions.assertThat((Object)factMapping3).isEqualTo(factMappings.get(1));
        Assertions.assertThat((Object)factMapping1).isEqualTo(factMappings.get(2));
        this.scesimModelDescriptor.moveFactMapping(2, 2);
        factMappings = this.scesimModelDescriptor.getUnmodifiableFactMappings();
        Assertions.assertThat((Object)factMapping2).isEqualTo(factMappings.get(0));
        Assertions.assertThat((Object)factMapping3).isEqualTo(factMappings.get(1));
        Assertions.assertThat((Object)factMapping1).isEqualTo(factMappings.get(2));
    }

    @Test
    public void moveFactMappingOldFailTest() {
        ExpressionIdentifier expressionIdentifier2 = ExpressionIdentifier.create((String)"Test expression 2", (FactMappingType)FactMappingType.GIVEN);
        this.scesimModelDescriptor.addFactMapping(this.factIdentifier, this.expressionIdentifier);
        this.scesimModelDescriptor.addFactMapping(this.factIdentifier, expressionIdentifier2);
        this.muteException(() -> {
            this.scesimModelDescriptor.moveFactMapping(2, 0);
            Assertions.fail((String)"Unexpected execution path");
        }, IndexOutOfBoundsException.class);
        this.muteException(() -> {
            this.scesimModelDescriptor.moveFactMapping(-1, 0);
            Assertions.fail((String)"Unexpected execution path");
        }, IndexOutOfBoundsException.class);
        this.muteException(() -> {
            this.scesimModelDescriptor.moveFactMapping(0, 2);
            Assertions.fail((String)"Unexpected execution path");
        }, IndexOutOfBoundsException.class);
        this.muteException(() -> {
            this.scesimModelDescriptor.moveFactMapping(0, -1);
            Assertions.fail((String)"Unexpected execution path");
        }, IndexOutOfBoundsException.class);
    }

    private <T extends Throwable> void muteException(Runnable toBeExecuted, Class<T> expected) {
        block2: {
            try {
                toBeExecuted.run();
            }
            catch (Throwable t) {
                if (t.getClass().isAssignableFrom(expected)) break block2;
                throw t;
            }
        }
    }
}

