/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.api.model;

import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.Settings;
import org.junit.Before;
import org.junit.Test;

public class SettingsTest {
    private static final String DMO_SESSION = "dmoSession";
    private static final String DMN_PATH = "dmnfile.dmn";
    private static final String DMN_NAME = "dmnName";
    private static final String DMN_NAMESPACE = "dmnNameSpace";
    private static final String RULE_FLOW_GROUP = "ruleFlowGroup";
    private static final String FILENAME = "fileName";
    private static final String KIE_BASE = "kieBase";
    private static final String KIE_SESSION = "kieSession";
    private Settings settings;

    @Before
    public void setup() {
        this.settings = new Settings();
        this.settings.setDmoSession(DMO_SESSION);
        this.settings.setDmnFilePath(DMN_PATH);
        this.settings.setDmnName(DMN_NAME);
        this.settings.setDmnNamespace(DMN_NAMESPACE);
        this.settings.setRuleFlowGroup(RULE_FLOW_GROUP);
        this.settings.setType(ScenarioSimulationModel.Type.RULE);
        this.settings.setStateless(true);
        this.settings.setSkipFromBuild(true);
        this.settings.setFileName(FILENAME);
        this.settings.setKieBase(KIE_BASE);
        this.settings.setKieSession(KIE_SESSION);
    }

    @Test
    public void cloneEmptySettings() {
        Settings cloneSettings = new Settings().cloneSettings();
        Assertions.assertThat((String)cloneSettings.getDmoSession()).isNull();
        Assertions.assertThat((String)cloneSettings.getDmnFilePath()).isNull();
        Assertions.assertThat((String)cloneSettings.getDmnName()).isNull();
        Assertions.assertThat((String)cloneSettings.getDmnNamespace()).isNull();
        Assertions.assertThat((String)cloneSettings.getRuleFlowGroup()).isNull();
        Assertions.assertThat((Comparable)cloneSettings.getType()).isNull();
        Assertions.assertThat((boolean)cloneSettings.isStateless()).isFalse();
        Assertions.assertThat((boolean)cloneSettings.isSkipFromBuild()).isFalse();
        Assertions.assertThat((String)cloneSettings.getFileName()).isNull();
        Assertions.assertThat((String)cloneSettings.getKieBase()).isNull();
        Assertions.assertThat((String)cloneSettings.getKieSession()).isNull();
    }

    @Test
    public void cloneSettings() {
        Settings cloneSettings = this.settings.cloneSettings();
        Assertions.assertThat((String)cloneSettings.getDmoSession()).isEqualTo(DMO_SESSION);
        Assertions.assertThat((String)cloneSettings.getDmnFilePath()).isEqualTo(DMN_PATH);
        Assertions.assertThat((String)cloneSettings.getDmnName()).isEqualTo(DMN_NAME);
        Assertions.assertThat((String)cloneSettings.getDmnNamespace()).isEqualTo(DMN_NAMESPACE);
        Assertions.assertThat((String)cloneSettings.getRuleFlowGroup()).isEqualTo(RULE_FLOW_GROUP);
        Assertions.assertThat((Comparable)cloneSettings.getType()).isEqualTo((Object)ScenarioSimulationModel.Type.RULE);
        Assertions.assertThat((boolean)cloneSettings.isStateless()).isTrue();
        Assertions.assertThat((boolean)cloneSettings.isSkipFromBuild()).isTrue();
        Assertions.assertThat((String)cloneSettings.getFileName()).isEqualTo(FILENAME);
        Assertions.assertThat((String)cloneSettings.getKieBase()).isEqualTo(KIE_BASE);
        Assertions.assertThat((String)cloneSettings.getKieSession()).isEqualTo(KIE_SESSION);
    }

    @Test
    public void cloneSettingsAndModifyIt() {
        Settings cloneSettings = this.settings.cloneSettings();
        cloneSettings.setDmoSession("dmoSessioncl");
        this.settings.setDmnFilePath("src/dmnfile.dmn");
        this.settings.setDmnName("cldmnName");
        this.settings.setDmnNamespace("cldmnNameSpace");
        this.settings.setRuleFlowGroup("clruleFlowGroup");
        this.settings.setType(ScenarioSimulationModel.Type.DMN);
        this.settings.setStateless(false);
        this.settings.setSkipFromBuild(false);
        this.settings.setFileName("clfileName");
        this.settings.setKieBase("clkieBase");
        this.settings.setKieSession("clkieSession");
        Assertions.assertThat((String)cloneSettings.getDmoSession()).isNotEqualTo((Object)this.settings.getDmoSession());
        Assertions.assertThat((String)cloneSettings.getDmnFilePath()).isNotEqualTo((Object)this.settings.getDmnFilePath());
        Assertions.assertThat((String)cloneSettings.getDmnName()).isNotEqualTo((Object)this.settings.getDmnName());
        Assertions.assertThat((String)cloneSettings.getDmnNamespace()).isNotEqualTo((Object)this.settings.getDmnNamespace());
        Assertions.assertThat((String)cloneSettings.getRuleFlowGroup()).isNotEqualTo((Object)this.settings.getRuleFlowGroup());
        Assertions.assertThat((Comparable)cloneSettings.getType()).isNotEqualTo((Object)this.settings.getType());
        Assertions.assertThat((boolean)cloneSettings.isStateless()).isNotEqualTo(this.settings.isStateless());
        Assertions.assertThat((boolean)cloneSettings.isSkipFromBuild()).isNotEqualTo(this.settings.isSkipFromBuild());
        Assertions.assertThat((String)cloneSettings.getFileName()).isNotEqualTo((Object)this.settings.getFileName());
        Assertions.assertThat((String)cloneSettings.getKieBase()).isNotEqualTo((Object)this.settings.getKieBase());
        Assertions.assertThat((String)cloneSettings.getKieSession()).isNotEqualTo((Object)this.settings.getKieSession());
    }
}

