/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.api.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.api.utils.ScenarioSimulationSharedUtils;
import org.junit.Test;

public class ScenarioSimulationSharedUtilsTest {
    List<String> listValues = Arrays.asList(List.class.getCanonicalName(), ArrayList.class.getCanonicalName(), LinkedList.class.getCanonicalName());
    List<String> mapValues = Arrays.asList(Map.class.getCanonicalName(), HashMap.class.getCanonicalName(), LinkedHashMap.class.getCanonicalName(), TreeMap.class.getCanonicalName());

    @Test
    public void isCollectionOrMap() {
        Assertions.assertThat((boolean)this.listValues.stream().allMatch(ScenarioSimulationSharedUtils::isCollectionOrMap)).isTrue();
        Assertions.assertThat((boolean)this.mapValues.stream().allMatch(ScenarioSimulationSharedUtils::isCollectionOrMap)).isTrue();
        Assertions.assertThat((boolean)ScenarioSimulationSharedUtils.isCollectionOrMap((String)Collection.class.getCanonicalName())).isTrue();
    }

    @Test
    public void isCollection() {
        Assertions.assertThat((boolean)this.listValues.stream().allMatch(ScenarioSimulationSharedUtils::isCollection)).isTrue();
        Assertions.assertThat((boolean)this.mapValues.stream().allMatch(ScenarioSimulationSharedUtils::isCollection)).isFalse();
        Assertions.assertThat((boolean)ScenarioSimulationSharedUtils.isCollectionOrMap((String)Collection.class.getCanonicalName())).isTrue();
    }

    @Test
    public void isList() {
        Assertions.assertThat((boolean)this.listValues.stream().allMatch(ScenarioSimulationSharedUtils::isList)).isTrue();
        Assertions.assertThat((boolean)this.mapValues.stream().allMatch(ScenarioSimulationSharedUtils::isList)).isFalse();
        Assertions.assertThat((boolean)ScenarioSimulationSharedUtils.isList((String)Collection.class.getCanonicalName())).isFalse();
    }

    @Test
    public void isMap() {
        Assertions.assertThat((boolean)this.mapValues.stream().allMatch(ScenarioSimulationSharedUtils::isMap)).isTrue();
    }

    @Test
    public void isEnumCanonicalName() {
        Assertions.assertThat((boolean)ScenarioSimulationSharedUtils.isEnumCanonicalName((String)Enum.class.getCanonicalName())).isTrue();
        Assertions.assertThat((boolean)ScenarioSimulationSharedUtils.isEnumCanonicalName((String)Enum.class.getSimpleName())).isFalse();
    }
}

