/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.api.model;

import java.util.List;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.api.model.AbstractScesimData;
import org.drools.scenariosimulation.api.model.AbstractScesimModel;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.Scenario;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class AbstractScesimModelTest {
    private static final int SCENARIO_DATA = 5;
    private static final int FACT_MAPPINGS = 3;
    private AbstractScesimModel<Scenario> abstractScesimModelSpy;

    @Before
    public void init() {
        this.abstractScesimModelSpy = (AbstractScesimModel)Mockito.spy((Object)new AbstractScesimModel<Scenario>(){

            public AbstractScesimModel cloneModel() {
                return null;
            }

            public Scenario addData(int index) {
                return null;
            }
        });
        IntStream.range(0, 5).forEach(index -> this.abstractScesimModelSpy.scesimData.add(this.getSpyScenario(index)));
        IntStream.range(0, 3).forEach(index -> this.abstractScesimModelSpy.scesimModelDescriptor.getFactMappings().add(this.getSpyFactMapping()));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void getUnmodifiableData() {
        List retrieved = this.abstractScesimModelSpy.getUnmodifiableData();
        Assertions.assertThat((List)retrieved).isNotNull();
        Assert.assertEquals((long)5L, (long)retrieved.size());
        retrieved.add(new Scenario());
    }

    @Test
    public void removeDataByIndex() {
        Scenario dataByIndex = (Scenario)this.abstractScesimModelSpy.getDataByIndex(3);
        Assert.assertEquals((long)5L, (long)this.abstractScesimModelSpy.scesimData.size());
        Assert.assertTrue((boolean)this.abstractScesimModelSpy.scesimData.contains(dataByIndex));
        this.abstractScesimModelSpy.removeDataByIndex(3);
        Assert.assertEquals((long)4L, (long)this.abstractScesimModelSpy.scesimData.size());
        Assert.assertFalse((boolean)this.abstractScesimModelSpy.scesimData.contains(dataByIndex));
    }

    @Test
    public void removeData() {
        Scenario dataByIndex = (Scenario)this.abstractScesimModelSpy.getDataByIndex(3);
        Assert.assertEquals((long)5L, (long)this.abstractScesimModelSpy.scesimData.size());
        Assert.assertTrue((boolean)this.abstractScesimModelSpy.scesimData.contains(dataByIndex));
        this.abstractScesimModelSpy.removeData((AbstractScesimData)dataByIndex);
        Assert.assertEquals((long)4L, (long)this.abstractScesimModelSpy.scesimData.size());
        Assert.assertFalse((boolean)this.abstractScesimModelSpy.scesimData.contains(dataByIndex));
    }

    @Test
    public void getDataByIndex() {
        Scenario retrieved = (Scenario)this.abstractScesimModelSpy.getDataByIndex(3);
        Assertions.assertThat((Object)retrieved).isNotNull();
    }

    @Test
    public void replaceData() {
        Assert.assertEquals((long)5L, (long)this.abstractScesimModelSpy.scesimData.size());
        Scenario replaced = (Scenario)this.abstractScesimModelSpy.getDataByIndex(3);
        Scenario replacement = new Scenario();
        this.abstractScesimModelSpy.replaceData(3, (AbstractScesimData)replacement);
        Assert.assertEquals((long)5L, (long)this.abstractScesimModelSpy.scesimData.size());
        Assert.assertFalse((boolean)this.abstractScesimModelSpy.scesimData.contains(replaced));
        Assert.assertEquals((Object)replacement, this.abstractScesimModelSpy.scesimData.get(3));
    }

    @Test
    public void cloneData() {
        Assert.assertEquals((long)5L, (long)this.abstractScesimModelSpy.scesimData.size());
        Scenario cloned = (Scenario)this.abstractScesimModelSpy.getDataByIndex(3);
        Scenario clone = (Scenario)this.abstractScesimModelSpy.cloneData(3, 4);
        Assertions.assertThat((Object)clone).isNotNull();
        Assert.assertEquals((Object)clone, this.abstractScesimModelSpy.scesimData.get(4));
        Assert.assertEquals((Object)cloned.getDescription(), (Object)clone.getDescription());
    }

    @Test
    public void clear() {
        this.abstractScesimModelSpy.clear();
        ((AbstractScesimModel)Mockito.verify(this.abstractScesimModelSpy, (VerificationMode)Mockito.times((int)1))).clearDatas();
    }

    @Test
    public void clearDatas() {
        Assert.assertEquals((long)5L, (long)this.abstractScesimModelSpy.scesimData.size());
        this.abstractScesimModelSpy.clearDatas();
        Assert.assertTrue((boolean)this.abstractScesimModelSpy.scesimData.isEmpty());
    }

    @Test
    public void resetErrors() {
        this.abstractScesimModelSpy.resetErrors();
        this.abstractScesimModelSpy.scesimData.forEach(scesimData -> ((Scenario)Mockito.verify((Object)scesimData, (VerificationMode)Mockito.times((int)1))).resetErrors());
    }

    @Test
    public void removeFactMappingByIndex() {
        Assert.assertEquals((long)3L, (long)this.abstractScesimModelSpy.scesimModelDescriptor.getFactMappings().size());
        FactMapping factMappingByIndex = this.abstractScesimModelSpy.scesimModelDescriptor.getFactMappingByIndex(2);
        this.abstractScesimModelSpy.removeFactMappingByIndex(2);
        ((AbstractScesimModel)Mockito.verify(this.abstractScesimModelSpy, (VerificationMode)Mockito.times((int)1))).clearDatas((FactMapping)ArgumentMatchers.eq((Object)factMappingByIndex));
        Assert.assertEquals((long)2L, (long)this.abstractScesimModelSpy.scesimModelDescriptor.getFactMappings().size());
        Assert.assertFalse((boolean)this.abstractScesimModelSpy.scesimModelDescriptor.getFactMappings().contains(factMappingByIndex));
    }

    @Test
    public void removeFactMapping() {
        Assert.assertEquals((long)3L, (long)this.abstractScesimModelSpy.scesimModelDescriptor.getFactMappings().size());
        FactMapping factMappingByIndex = this.abstractScesimModelSpy.scesimModelDescriptor.getFactMappingByIndex(2);
        this.abstractScesimModelSpy.removeFactMapping(factMappingByIndex);
        ((AbstractScesimModel)Mockito.verify(this.abstractScesimModelSpy, (VerificationMode)Mockito.times((int)1))).clearDatas((FactMapping)ArgumentMatchers.eq((Object)factMappingByIndex));
        Assert.assertEquals((long)2L, (long)this.abstractScesimModelSpy.scesimModelDescriptor.getFactMappings().size());
        Assert.assertFalse((boolean)this.abstractScesimModelSpy.scesimModelDescriptor.getFactMappings().contains(factMappingByIndex));
    }

    @Test
    public void clearDatasByFactMapping() {
        FactMapping factMappingByIndex = this.abstractScesimModelSpy.scesimModelDescriptor.getFactMappingByIndex(2);
        this.abstractScesimModelSpy.clearDatas(factMappingByIndex);
        FactIdentifier factIdentifier = factMappingByIndex.getFactIdentifier();
        ExpressionIdentifier expressionIdentifier = factMappingByIndex.getExpressionIdentifier();
        this.abstractScesimModelSpy.scesimData.forEach(scesimData -> ((Scenario)Mockito.verify((Object)scesimData, (VerificationMode)Mockito.times((int)1))).removeFactMappingValueByIdentifiers((FactIdentifier)ArgumentMatchers.eq((Object)factIdentifier), (ExpressionIdentifier)ArgumentMatchers.eq((Object)expressionIdentifier)));
    }

    private Scenario getSpyScenario(int index) {
        Scenario toReturn = (Scenario)Mockito.spy((Object)new Scenario());
        toReturn.setDescription("INDEX-" + index);
        return toReturn;
    }

    private FactMapping getSpyFactMapping() {
        FactMapping toReturn = (FactMapping)Mockito.spy((Object)new FactMapping());
        Mockito.when((Object)toReturn.getFactIdentifier()).thenReturn((Object)((FactIdentifier)Mockito.mock(FactIdentifier.class)));
        Mockito.when((Object)toReturn.getExpressionIdentifier()).thenReturn((Object)((ExpressionIdentifier)Mockito.mock(ExpressionIdentifier.class)));
        return (FactMapping)Mockito.spy((Object)new FactMapping());
    }
}

