/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.api.model;

import java.util.List;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.ScesimModelDescriptor;
import org.drools.scenariosimulation.api.model.Simulation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SimulationTest {
    private Simulation simulation;
    private Scenario originalScenario;

    @Before
    public void setup() {
        this.simulation = new Simulation();
        FactIdentifier factIdentifier = FactIdentifier.create((String)"Test", (String)String.class.getCanonicalName());
        ExpressionIdentifier expressionIdentifier = ExpressionIdentifier.create((String)"Test", (FactMappingType)FactMappingType.GIVEN);
        this.simulation.getScesimModelDescriptor().addFactMapping(factIdentifier, expressionIdentifier);
        this.originalScenario = (Scenario)this.simulation.addData();
        this.originalScenario.setDescription("Test Description");
        this.originalScenario.addMappingValue(factIdentifier, expressionIdentifier, (Object)"TEST");
    }

    @Test
    public void addData() {
        this.simulation.addData(1);
        Assertions.assertThatThrownBy(() -> this.simulation.addData(-1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.simulation.addData(3)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    public void cloneModel() {
        Simulation cloned = this.simulation.cloneModel();
        Assertions.assertThat((Object)cloned).isNotNull();
        ScesimModelDescriptor originalDescriptor = this.simulation.getScesimModelDescriptor();
        ScesimModelDescriptor clonedDescriptor = cloned.getScesimModelDescriptor();
        Assert.assertEquals((long)originalDescriptor.getUnmodifiableFactMappings().size(), (long)clonedDescriptor.getUnmodifiableFactMappings().size());
        IntStream.range(0, originalDescriptor.getUnmodifiableFactMappings().size()).forEach(index -> Assert.assertEquals(originalDescriptor.getUnmodifiableFactMappings().get(index), clonedDescriptor.getUnmodifiableFactMappings().get(index)));
        Assert.assertEquals((long)this.simulation.getUnmodifiableData().size(), (long)cloned.getUnmodifiableData().size());
        IntStream.range(0, this.simulation.getUnmodifiableData().size()).forEach(index -> Assert.assertEquals((Object)((Scenario)this.simulation.getUnmodifiableData().get(index)).getDescription(), (Object)((Scenario)cloned.getUnmodifiableData().get(index)).getDescription()));
    }

    @Test
    public void cloneData() {
        Scenario clonedScenario = (Scenario)this.simulation.cloneData(0, 1);
        Assert.assertEquals((Object)this.originalScenario.getDescription(), (Object)clonedScenario.getDescription());
        Assert.assertEquals((long)this.originalScenario.getUnmodifiableFactMappingValues().size(), (long)clonedScenario.getUnmodifiableFactMappingValues().size());
        Assert.assertEquals((Object)this.originalScenario, (Object)this.simulation.getDataByIndex(0));
        Assert.assertEquals((Object)clonedScenario, (Object)this.simulation.getDataByIndex(1));
        Assert.assertNotEquals((Object)this.originalScenario, (Object)clonedScenario);
        Assert.assertNotEquals(this.originalScenario.getUnmodifiableFactMappingValues().get(0), clonedScenario.getUnmodifiableFactMappingValues().get(0));
    }

    @Test
    public void cloneScenarioFail() {
        Assertions.assertThatThrownBy(() -> this.simulation.cloneData(-1, 1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.simulation.cloneData(2, 1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.simulation.cloneData(0, -1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.simulation.cloneData(0, 2)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    public void removeFactMappingByIndex() {
        Assert.assertEquals((long)2L, (long)((Scenario)this.simulation.getUnmodifiableData().get(0)).getUnmodifiableFactMappingValues().size());
        Assert.assertEquals((long)1L, (long)this.simulation.getScesimModelDescriptor().getUnmodifiableFactMappings().size());
        this.simulation.removeFactMappingByIndex(0);
        Assert.assertEquals((long)1L, (long)((Scenario)this.simulation.getUnmodifiableData().get(0)).getUnmodifiableFactMappingValues().size());
        Assert.assertEquals((long)0L, (long)this.simulation.getScesimModelDescriptor().getUnmodifiableFactMappings().size());
    }

    @Test
    public void removeFactMapping() {
        Assert.assertEquals((long)2L, (long)((Scenario)this.simulation.getUnmodifiableData().get(0)).getUnmodifiableFactMappingValues().size());
        Assert.assertEquals((long)1L, (long)this.simulation.getScesimModelDescriptor().getUnmodifiableFactMappings().size());
        this.simulation.removeFactMapping(this.simulation.getScesimModelDescriptor().getFactMappingByIndex(0));
        Assert.assertEquals((long)1L, (long)((Scenario)this.simulation.getUnmodifiableData().get(0)).getUnmodifiableFactMappingValues().size());
        Assert.assertEquals((long)0L, (long)this.simulation.getScesimModelDescriptor().getUnmodifiableFactMappings().size());
    }

    @Test
    public void getScenarioWithIndex() {
        List scenarioWithIndex = this.simulation.getScenarioWithIndex();
        Assert.assertEquals((long)this.simulation.getUnmodifiableData().size(), (long)scenarioWithIndex.size());
        ScenarioWithIndex scenario = (ScenarioWithIndex)scenarioWithIndex.get(0);
        int index = scenario.getIndex();
        Assert.assertEquals((Object)this.simulation.getDataByIndex(index - 1), (Object)scenario.getScesimData());
    }
}

