/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.api.model;

import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.api.model.Background;
import org.drools.scenariosimulation.api.model.BackgroundData;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.ScesimModelDescriptor;
import org.junit.Before;
import org.junit.Test;

public class BackgroundDataTest {
    private ScesimModelDescriptor scesimModelDescriptor;
    private BackgroundData backgroundData;
    private FactIdentifier factIdentifier;
    private ExpressionIdentifier expressionIdentifier;
    private Background background;

    @Before
    public void init() {
        this.background = new Background();
        this.scesimModelDescriptor = this.background.getScesimModelDescriptor();
        this.backgroundData = (BackgroundData)this.background.addData();
        this.factIdentifier = FactIdentifier.create((String)"test fact", (String)String.class.getCanonicalName());
        this.expressionIdentifier = ExpressionIdentifier.create((String)"test expression", (FactMappingType)FactMappingType.EXPECT);
    }

    @Test
    public void removeFactMappingValueByIdentifiersTest() {
        this.backgroundData.addMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)"test value");
        Optional retrieved = this.backgroundData.getFactMappingValue(this.factIdentifier, this.expressionIdentifier);
        Assertions.assertThat((boolean)retrieved.isPresent()).isTrue();
        this.backgroundData.removeFactMappingValueByIdentifiers(this.factIdentifier, this.expressionIdentifier);
        retrieved = this.backgroundData.getFactMappingValue(this.factIdentifier, this.expressionIdentifier);
        Assertions.assertThat((boolean)retrieved.isPresent()).isFalse();
    }

    @Test
    public void removeFactMappingValue() {
        this.backgroundData.addMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)"test value");
        Optional retrieved = this.backgroundData.getFactMappingValue(this.factIdentifier, this.expressionIdentifier);
        Assertions.assertThat((boolean)retrieved.isPresent()).isTrue();
        this.backgroundData.removeFactMappingValue((FactMappingValue)retrieved.get());
        retrieved = this.backgroundData.getFactMappingValue(this.factIdentifier, this.expressionIdentifier);
        Assertions.assertThat((boolean)retrieved.isPresent()).isFalse();
    }

    @Test(expected=IllegalArgumentException.class)
    public void addMappingValueTest() {
        this.backgroundData.addMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)"test value");
        this.backgroundData.addMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)"test value");
    }

    @Test
    public void getDescriptionTest() {
        Assertions.assertThat((String)this.backgroundData.getDescription()).isEqualTo("");
        String description = "Test Description";
        this.backgroundData.addMappingValue(FactIdentifier.DESCRIPTION, ExpressionIdentifier.DESCRIPTION, (Object)description);
        Assertions.assertThat((String)this.backgroundData.getDescription()).isEqualTo(description);
        BackgroundData scenarioWithDescriptionNull = (BackgroundData)this.background.addData();
        scenarioWithDescriptionNull.setDescription(null);
        Assertions.assertThat((String)scenarioWithDescriptionNull.getDescription()).isEqualTo("");
    }

    @Test
    public void addOrUpdateMappingValue() {
        String value1 = "Test 1";
        String value2 = "Test 2";
        FactMappingValue factMappingValue = this.backgroundData.addMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)value1);
        Assertions.assertThat((Object)value1).isEqualTo(factMappingValue.getRawValue());
        FactMappingValue factMappingValue1 = this.backgroundData.addOrUpdateMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)value2);
        Assertions.assertThat((Object)factMappingValue1).isEqualTo((Object)factMappingValue);
        Assertions.assertThat((Object)value2).isEqualTo(factMappingValue1.getRawValue());
    }
}

