/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.api.model;

import java.util.List;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.ScesimModelDescriptor;
import org.drools.scenariosimulation.api.model.Simulation;
import org.junit.Before;
import org.junit.Test;

public class SimulationTest {
    private Simulation simulation;
    private Scenario originalScenario;

    @Before
    public void setup() {
        this.simulation = new Simulation();
        FactIdentifier factIdentifier = FactIdentifier.create((String)"Test", (String)String.class.getCanonicalName());
        ExpressionIdentifier expressionIdentifier = ExpressionIdentifier.create((String)"Test", (FactMappingType)FactMappingType.GIVEN);
        this.simulation.getScesimModelDescriptor().addFactMapping(factIdentifier, expressionIdentifier);
        this.originalScenario = (Scenario)this.simulation.addData();
        this.originalScenario.setDescription("Test Description");
        this.originalScenario.addMappingValue(factIdentifier, expressionIdentifier, (Object)"TEST");
    }

    @Test
    public void addData() {
        this.simulation.addData(1);
        Assertions.assertThatThrownBy(() -> this.simulation.addData(-1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.simulation.addData(3)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    public void cloneModel() {
        Simulation cloned = this.simulation.cloneModel();
        Assertions.assertThat((Object)cloned).isNotNull();
        ScesimModelDescriptor originalDescriptor = this.simulation.getScesimModelDescriptor();
        ScesimModelDescriptor clonedDescriptor = cloned.getScesimModelDescriptor();
        Assertions.assertThat((int)clonedDescriptor.getUnmodifiableFactMappings().size()).isEqualTo(originalDescriptor.getUnmodifiableFactMappings().size());
        IntStream.range(0, originalDescriptor.getUnmodifiableFactMappings().size()).forEach(index -> Assertions.assertThat((Object)((FactMapping)clonedDescriptor.getUnmodifiableFactMappings().get(index))).isEqualTo(originalDescriptor.getUnmodifiableFactMappings().get(index)));
        Assertions.assertThat((int)cloned.getUnmodifiableData().size()).isEqualTo(this.simulation.getUnmodifiableData().size());
        IntStream.range(0, this.simulation.getUnmodifiableData().size()).forEach(index -> Assertions.assertThat((String)((Scenario)cloned.getUnmodifiableData().get(index)).getDescription()).isEqualTo(((Scenario)this.simulation.getUnmodifiableData().get(index)).getDescription()));
    }

    @Test
    public void cloneData() {
        Scenario clonedScenario = (Scenario)this.simulation.cloneData(0, 1);
        Assertions.assertThat((String)clonedScenario.getDescription()).isEqualTo(this.originalScenario.getDescription());
        Assertions.assertThat((int)clonedScenario.getUnmodifiableFactMappingValues().size()).isEqualTo(this.originalScenario.getUnmodifiableFactMappingValues().size());
        Assertions.assertThat((Object)((Scenario)this.simulation.getDataByIndex(0))).isEqualTo((Object)this.originalScenario);
        Assertions.assertThat((Object)((Scenario)this.simulation.getDataByIndex(1))).isEqualTo((Object)clonedScenario);
        Assertions.assertThat((Object)clonedScenario).isNotEqualTo((Object)this.originalScenario);
        Assertions.assertThat((Object)((FactMappingValue)clonedScenario.getUnmodifiableFactMappingValues().get(0))).isNotEqualTo(this.originalScenario.getUnmodifiableFactMappingValues().get(0));
    }

    @Test
    public void cloneScenarioFail() {
        Assertions.assertThatThrownBy(() -> this.simulation.cloneData(-1, 1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.simulation.cloneData(2, 1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.simulation.cloneData(0, -1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.simulation.cloneData(0, 2)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    public void removeFactMappingByIndex() {
        Assertions.assertThat((int)((Scenario)this.simulation.getUnmodifiableData().get(0)).getUnmodifiableFactMappingValues().size()).isEqualTo(2);
        Assertions.assertThat((int)this.simulation.getScesimModelDescriptor().getUnmodifiableFactMappings().size()).isEqualTo(1);
        this.simulation.removeFactMappingByIndex(0);
        Assertions.assertThat((int)((Scenario)this.simulation.getUnmodifiableData().get(0)).getUnmodifiableFactMappingValues().size()).isEqualTo(1);
        Assertions.assertThat((int)this.simulation.getScesimModelDescriptor().getUnmodifiableFactMappings().size()).isEqualTo(0);
    }

    @Test
    public void removeFactMapping() {
        Assertions.assertThat((int)((Scenario)this.simulation.getUnmodifiableData().get(0)).getUnmodifiableFactMappingValues().size()).isEqualTo(2);
        Assertions.assertThat((int)this.simulation.getScesimModelDescriptor().getUnmodifiableFactMappings().size()).isEqualTo(1);
        this.simulation.removeFactMapping(this.simulation.getScesimModelDescriptor().getFactMappingByIndex(0));
        Assertions.assertThat((int)((Scenario)this.simulation.getUnmodifiableData().get(0)).getUnmodifiableFactMappingValues().size()).isEqualTo(1);
        Assertions.assertThat((int)this.simulation.getScesimModelDescriptor().getUnmodifiableFactMappings().size()).isEqualTo(0);
    }

    @Test
    public void getScenarioWithIndex() {
        List scenarioWithIndex = this.simulation.getScenarioWithIndex();
        Assertions.assertThat((int)scenarioWithIndex.size()).isEqualTo(this.simulation.getUnmodifiableData().size());
        ScenarioWithIndex scenario = (ScenarioWithIndex)scenarioWithIndex.get(0);
        int index = scenario.getIndex();
        Assertions.assertThat((Object)((Scenario)scenario.getScesimData())).isEqualTo((Object)this.simulation.getDataByIndex(index - 1));
    }
}

