/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.api.model;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.ScesimModelDescriptor;
import org.drools.scenariosimulation.api.model.Simulation;
import org.junit.Before;
import org.junit.Test;

public class SimulationTest {
    private Simulation simulation;
    private Scenario originalScenario;

    @Before
    public void setup() {
        this.simulation = new Simulation();
        FactIdentifier factIdentifier = FactIdentifier.create((String)"Test", (String)String.class.getCanonicalName());
        ExpressionIdentifier expressionIdentifier = ExpressionIdentifier.create((String)"Test", (FactMappingType)FactMappingType.GIVEN);
        this.simulation.getScesimModelDescriptor().addFactMapping(factIdentifier, expressionIdentifier);
        this.originalScenario = (Scenario)this.simulation.addData();
        this.originalScenario.setDescription("Test Description");
        this.originalScenario.addMappingValue(factIdentifier, expressionIdentifier, (Object)"TEST");
    }

    @Test
    public void addData_failsOutsideBoundaries() {
        this.simulation.addData(1);
        Assertions.assertThatThrownBy(() -> this.simulation.addData(-1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.simulation.addData(3)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    public void cloneModel() {
        Simulation cloned = this.simulation.cloneModel();
        Assertions.assertThat((Object)cloned).isNotNull();
        ScesimModelDescriptor originalDescriptor = this.simulation.getScesimModelDescriptor();
        ScesimModelDescriptor clonedDescriptor = cloned.getScesimModelDescriptor();
        Assertions.assertThat((List)clonedDescriptor.getUnmodifiableFactMappings()).hasSameSizeAs((Iterable)originalDescriptor.getUnmodifiableFactMappings());
        Assertions.assertThat((List)clonedDescriptor.getUnmodifiableFactMappings()).isEqualTo((Object)originalDescriptor.getUnmodifiableFactMappings());
        Assertions.assertThat((List)cloned.getUnmodifiableData()).hasSameSizeAs((Iterable)this.simulation.getUnmodifiableData());
        ((ListAssert)Assertions.assertThat((List)cloned.getUnmodifiableData()).usingElementComparator((x, y) -> x.getDescription().compareTo(y.getDescription()))).isEqualTo((Object)this.simulation.getUnmodifiableData());
    }

    @Test
    public void cloneData() {
        Scenario clonedScenario = (Scenario)this.simulation.cloneData(0, 1);
        Assertions.assertThat((String)clonedScenario.getDescription()).isEqualTo(this.originalScenario.getDescription());
        Assertions.assertThat((List)clonedScenario.getUnmodifiableFactMappingValues()).hasSameSizeAs((Iterable)this.originalScenario.getUnmodifiableFactMappingValues());
        Assertions.assertThat((Object)((Scenario)this.simulation.getDataByIndex(0))).isEqualTo((Object)this.originalScenario);
        Assertions.assertThat((Object)((Scenario)this.simulation.getDataByIndex(1))).isEqualTo((Object)clonedScenario);
        Assertions.assertThat((Object)clonedScenario).isNotEqualTo((Object)this.originalScenario);
        Assertions.assertThat((Object)((FactMappingValue)clonedScenario.getUnmodifiableFactMappingValues().get(0))).isNotEqualTo(this.originalScenario.getUnmodifiableFactMappingValues().get(0));
    }

    @Test
    public void cloneData_failOutsideBoundaries() {
        Assertions.assertThatThrownBy(() -> this.simulation.cloneData(-1, 1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.simulation.cloneData(2, 1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.simulation.cloneData(0, -1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.simulation.cloneData(0, 2)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    public void removeFactMappingByIndex() {
        this.simulation.removeFactMappingByIndex(0);
        Assertions.assertThat((List)((Scenario)this.simulation.getUnmodifiableData().get(0)).getUnmodifiableFactMappingValues()).hasSize(1);
        Assertions.assertThat((List)this.simulation.getScesimModelDescriptor().getUnmodifiableFactMappings()).hasSize(0);
    }

    @Test
    public void removeFactMapping() {
        this.simulation.removeFactMapping(this.simulation.getScesimModelDescriptor().getFactMappingByIndex(0));
        Assertions.assertThat((List)((Scenario)this.simulation.getUnmodifiableData().get(0)).getUnmodifiableFactMappingValues()).hasSize(1);
        Assertions.assertThat((List)this.simulation.getScesimModelDescriptor().getUnmodifiableFactMappings()).hasSize(0);
    }

    @Test
    public void getScenarioWithIndex() {
        List scenarios = this.simulation.getScenarioWithIndex();
        Assertions.assertThat((List)scenarios).hasSameSizeAs((Iterable)this.simulation.getUnmodifiableData());
        ScenarioWithIndex scenario = (ScenarioWithIndex)scenarios.get(0);
        int index = scenario.getIndex();
        Assertions.assertThat((Object)((Scenario)scenario.getScesimData())).isEqualTo((Object)this.simulation.getDataByIndex(index - 1));
    }
}

