/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.api.model;

import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.junit.Test;

public class FactIdentifierTest {
    @Test
    public void importedFactIdentifierTest() {
        String importedBookName = "imported.Book";
        FactIdentifier factIdentifier = FactIdentifier.create((String)importedBookName, (String)importedBookName, (String)"imported");
        Assertions.assertThat((String)factIdentifier.getName()).isEqualTo(importedBookName);
        Assertions.assertThat((String)factIdentifier.getClassName()).isEqualTo(importedBookName);
        Assertions.assertThat((String)factIdentifier.getImportPrefix()).isEqualTo("imported");
    }

    @Test
    public void getClassNameWithoutPackage() {
        this.commonGetClassNameWithoutPackage("test", "com.Test", "Test");
    }

    @Test
    public void getClassNameWithoutPackage_LongPackage() {
        this.commonGetClassNameWithoutPackage("test", "com.project.Test", "Test");
    }

    @Test
    public void getClassNameWithoutPackage_NoPackage() {
        this.commonGetClassNameWithoutPackage("test", "Test", "Test");
    }

    @Test
    public void getPackageWithoutClassName() {
        this.commonGetPackageWithoutClassName("test", "com.Test", "com");
    }

    @Test
    public void getPackageWithoutClassName_LongPackage() {
        this.commonGetPackageWithoutClassName("test", "com.project.Test", "com.project");
    }

    @Test
    public void getPackageWithoutClassName_NoPackage() {
        this.commonGetPackageWithoutClassName("test", "Test", "");
    }

    private void commonGetPackageWithoutClassName(String name, String className, String expectedPackage) {
        FactIdentifier factIdentifier = FactIdentifier.create((String)name, (String)className);
        Assertions.assertThat((String)factIdentifier.getPackageWithoutClassName()).isEqualTo(expectedPackage);
    }

    private void commonGetClassNameWithoutPackage(String name, String className, String expectedClassName) {
        FactIdentifier factIdentifier = FactIdentifier.create((String)name, (String)className);
        Assertions.assertThat((String)factIdentifier.getClassNameWithoutPackage()).isEqualTo(expectedClassName);
    }
}

