/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.api.model;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.FactMappingValueStatus;
import org.junit.Before;
import org.junit.Test;

public class FactMappingValueTest {
    private FactMappingValue value;

    @Before
    public void setUp() throws Exception {
        this.value = new FactMappingValue();
    }

    @Test
    public void emptyFactMappingValue() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new FactMappingValue(null, ExpressionIdentifier.DESCRIPTION, null)).isInstanceOf(NullPointerException.class)).hasMessage("FactIdentifier has to be not null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new FactMappingValue(FactIdentifier.DESCRIPTION, null, null)).isInstanceOf(NullPointerException.class)).hasMessage("ExpressionIdentifier has to be not null");
    }

    @Test
    public void resetStatus() {
        this.value.resetStatus();
        Assertions.assertThat((Comparable)this.value.getStatus()).isEqualTo((Object)FactMappingValueStatus.SUCCESS);
        Assertions.assertThat((String)this.value.getExceptionMessage()).isNull();
        Assertions.assertThat((Object)this.value.getErrorValue()).isNull();
        Assertions.assertThat((List)this.value.getCollectionPathToValue()).isNull();
    }

    @Test
    public void setErrorValue() {
        this.value.setErrorValue((Object)"value");
        Assertions.assertThat((Comparable)this.value.getStatus()).isEqualTo((Object)FactMappingValueStatus.FAILED_WITH_ERROR);
        Assertions.assertThat((String)this.value.getExceptionMessage()).isNull();
        Assertions.assertThat((List)this.value.getCollectionPathToValue()).isNull();
        Assertions.assertThat((Object)this.value.getErrorValue()).isEqualTo((Object)"value");
    }

    @Test
    public void setExceptionMessage() {
        String exceptionValue = "Exception";
        this.value.setExceptionMessage(exceptionValue);
        Assertions.assertThat((Comparable)this.value.getStatus()).isEqualTo((Object)FactMappingValueStatus.FAILED_WITH_EXCEPTION);
        Assertions.assertThat((String)this.value.getExceptionMessage()).isEqualTo(exceptionValue);
        Assertions.assertThat((Object)this.value.getErrorValue()).isNull();
        Assertions.assertThat((List)this.value.getCollectionPathToValue()).isNull();
    }

    @Test
    public void setPathToValue() {
        List<String> path = Arrays.asList("Step1", "Step2");
        this.value.setCollectionPathToValue(path);
        Assertions.assertThat((Comparable)this.value.getStatus()).isEqualTo((Object)FactMappingValueStatus.FAILED_WITH_ERROR);
        Assertions.assertThat((String)this.value.getExceptionMessage()).isNull();
        Assertions.assertThat((Object)this.value.getErrorValue()).isNull();
        Assertions.assertThat((List)this.value.getCollectionPathToValue()).isSameAs(path);
    }
}

