/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.api.model;

import java.util.List;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.drools.scenariosimulation.api.model.AbstractScesimData;
import org.drools.scenariosimulation.api.model.AbstractScesimModel;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.Scenario;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class AbstractScesimModelTest {
    private static final int SCENARIO_DATA = 5;
    private static final int FACT_MAPPINGS = 3;
    private AbstractScesimModel<Scenario> model;

    @Before
    public void init() {
        this.model = (AbstractScesimModel)Mockito.spy((Object)new AbstractScesimModel<Scenario>(){

            public AbstractScesimModel<Scenario> cloneModel() {
                return null;
            }

            public Scenario addData(int index) {
                return null;
            }
        });
        IntStream.range(0, 5).forEach(index -> this.model.scesimData.add(this.getSpyScenario(index)));
        IntStream.range(0, 3).forEach(index -> this.model.scesimModelDescriptor.getFactMappings().add(this.getSpyFactMapping()));
    }

    @Test
    public void getUnmodifiableData() {
        ((ListAssert)Assertions.assertThat((List)this.model.getUnmodifiableData()).isNotNull()).hasSize(5);
    }

    @Test
    public void getUnmodifiableData_isUnmodifiable() {
        Assertions.assertThatExceptionOfType(UnsupportedOperationException.class).isThrownBy(() -> this.model.getUnmodifiableData().add(new Scenario()));
    }

    @Test
    public void getDataByIndex() {
        Scenario dataByIndex = (Scenario)this.model.getDataByIndex(3);
        Assertions.assertThat((Object)dataByIndex).isNotNull();
        Assertions.assertThat((List)this.model.scesimData).contains((Object[])new Scenario[]{dataByIndex});
    }

    @Test
    public void removeDataByIndex() {
        Scenario dataByIndex = (Scenario)this.model.getDataByIndex(3);
        this.model.removeDataByIndex(3);
        ((ListAssert)Assertions.assertThat((List)this.model.scesimData).hasSize(4)).doesNotContain((Object[])new Scenario[]{dataByIndex});
    }

    @Test
    public void removeData() {
        Scenario dataByIndex = (Scenario)this.model.getDataByIndex(3);
        this.model.removeData((AbstractScesimData)dataByIndex);
        ((ListAssert)Assertions.assertThat((List)this.model.scesimData).hasSize(4)).doesNotContain((Object[])new Scenario[]{dataByIndex});
    }

    @Test
    public void replaceData() {
        Scenario replaced = (Scenario)this.model.getDataByIndex(3);
        Scenario replacement = new Scenario();
        this.model.replaceData(3, (AbstractScesimData)replacement);
        ((ListAssert)Assertions.assertThat((List)this.model.scesimData).hasSize(5)).doesNotContain((Object[])new Scenario[]{replaced});
        Assertions.assertThat((Object)((Scenario)this.model.scesimData.get(3))).isEqualTo((Object)replacement);
    }

    @Test
    public void cloneData() {
        Scenario cloned = (Scenario)this.model.getDataByIndex(3);
        Scenario clone = (Scenario)this.model.cloneData(3, 4);
        Assertions.assertThat((Object)clone).isNotNull();
        Assertions.assertThat((Object)((Scenario)this.model.scesimData.get(4))).isEqualTo((Object)clone);
        Assertions.assertThat((String)clone.getDescription()).isEqualTo(cloned.getDescription());
    }

    @Test
    public void clear() {
        this.model.clear();
        ((AbstractScesimModel)Mockito.verify(this.model, (VerificationMode)Mockito.times((int)1))).clearDatas();
    }

    @Test
    public void clearDatas() {
        this.model.clearDatas();
        Assertions.assertThat((List)this.model.scesimData).isEmpty();
    }

    @Test
    public void resetErrors() {
        this.model.resetErrors();
        this.model.scesimData.forEach(scesimData -> ((Scenario)Mockito.verify((Object)scesimData, (VerificationMode)Mockito.times((int)1))).resetErrors());
    }

    @Test
    public void removeFactMappingByIndex() {
        FactMapping factMappingByIndex = this.model.scesimModelDescriptor.getFactMappingByIndex(2);
        this.model.removeFactMappingByIndex(2);
        ((AbstractScesimModel)Mockito.verify(this.model, (VerificationMode)Mockito.times((int)1))).clearDatas((FactMapping)ArgumentMatchers.eq((Object)factMappingByIndex));
        ((ListAssert)Assertions.assertThat((List)this.model.scesimModelDescriptor.getFactMappings()).hasSize(2)).doesNotContain((Object[])new FactMapping[]{factMappingByIndex});
    }

    @Test
    public void removeFactMapping() {
        FactMapping factMappingByIndex = this.model.scesimModelDescriptor.getFactMappingByIndex(2);
        this.model.removeFactMapping(factMappingByIndex);
        ((AbstractScesimModel)Mockito.verify(this.model, (VerificationMode)Mockito.times((int)1))).clearDatas((FactMapping)ArgumentMatchers.eq((Object)factMappingByIndex));
        ((ListAssert)Assertions.assertThat((List)this.model.scesimModelDescriptor.getFactMappings()).hasSize(2)).doesNotContain((Object[])new FactMapping[]{factMappingByIndex});
    }

    @Test
    public void clearDatasByFactMapping() {
        FactMapping factMappingByIndex = this.model.scesimModelDescriptor.getFactMappingByIndex(2);
        this.model.clearDatas(factMappingByIndex);
        FactIdentifier factIdentifier = factMappingByIndex.getFactIdentifier();
        ExpressionIdentifier expressionIdentifier = factMappingByIndex.getExpressionIdentifier();
        this.model.scesimData.forEach(scesimData -> ((Scenario)Mockito.verify((Object)scesimData, (VerificationMode)Mockito.times((int)1))).removeFactMappingValueByIdentifiers((FactIdentifier)ArgumentMatchers.eq((Object)factIdentifier), (ExpressionIdentifier)ArgumentMatchers.eq((Object)expressionIdentifier)));
    }

    private Scenario getSpyScenario(int index) {
        Scenario toReturn = (Scenario)Mockito.spy((Object)new Scenario());
        toReturn.setDescription("INDEX-" + index);
        return toReturn;
    }

    private FactMapping getSpyFactMapping() {
        FactMapping toReturn = (FactMapping)Mockito.spy((Object)new FactMapping());
        Mockito.when((Object)toReturn.getFactIdentifier()).thenReturn((Object)((FactIdentifier)Mockito.mock(FactIdentifier.class)));
        Mockito.when((Object)toReturn.getExpressionIdentifier()).thenReturn((Object)((ExpressionIdentifier)Mockito.mock(ExpressionIdentifier.class)));
        return (FactMapping)Mockito.spy((Object)new FactMapping());
    }
}

