/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.api.model;

import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.api.model.Background;
import org.drools.scenariosimulation.api.model.BackgroundData;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.ScesimModelDescriptor;
import org.junit.Before;
import org.junit.Test;

public class BackgroundDataTest {
    private ScesimModelDescriptor scesimModelDescriptor;
    private BackgroundData backgroundData;
    private FactIdentifier factIdentifier;
    private ExpressionIdentifier expressionIdentifier;
    private Background background;

    @Before
    public void init() {
        this.background = new Background();
        this.scesimModelDescriptor = this.background.getScesimModelDescriptor();
        this.backgroundData = (BackgroundData)this.background.addData();
        this.factIdentifier = FactIdentifier.create((String)"test fact", (String)String.class.getCanonicalName());
        this.expressionIdentifier = ExpressionIdentifier.create((String)"test expression", (FactMappingType)FactMappingType.EXPECT);
    }

    @Test
    public void removeFactMappingValueByIdentifiersTest() {
        this.backgroundData.addMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)"test value");
        this.backgroundData.removeFactMappingValueByIdentifiers(this.factIdentifier, this.expressionIdentifier);
        Assertions.assertThat((Optional)this.backgroundData.getFactMappingValue(this.factIdentifier, this.expressionIdentifier)).isNotPresent();
    }

    @Test
    public void removeFactMappingValue() {
        this.backgroundData.addMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)"test value");
        Optional retrieved = this.backgroundData.getFactMappingValue(this.factIdentifier, this.expressionIdentifier);
        this.backgroundData.removeFactMappingValue((FactMappingValue)retrieved.get());
        Assertions.assertThat((Optional)this.backgroundData.getFactMappingValue(this.factIdentifier, this.expressionIdentifier)).isNotPresent();
    }

    @Test
    public void addOMappingValue() {
        FactMappingValue factMappingValue = this.backgroundData.addMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)"test value");
        Assertions.assertThat((Object)"test value").isEqualTo(factMappingValue.getRawValue());
    }

    @Test
    public void addMappingValue_multipleInvocationsFail() {
        this.backgroundData.addMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)"test value");
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> this.backgroundData.addMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)"test value"));
    }

    @Test
    public void addMappingValue_singleInvocationSucceed() {
        this.backgroundData.addMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)"test value");
        Assertions.assertThat((Optional)this.backgroundData.getFactMappingValue(this.factIdentifier, this.expressionIdentifier)).isPresent();
    }

    @Test
    public void getDescription_initialEmptyDescription() {
        Assertions.assertThat((String)this.backgroundData.getDescription()).isEqualTo("");
    }

    @Test
    public void getDescription_descriptionSetToNullValue() {
        this.backgroundData.addMappingValue(FactIdentifier.DESCRIPTION, ExpressionIdentifier.DESCRIPTION, null);
        Assertions.assertThat((String)this.backgroundData.getDescription()).isEqualTo("");
    }

    @Test
    public void getDescription_descriptionSetToNonNullValue() {
        this.backgroundData.addMappingValue(FactIdentifier.DESCRIPTION, ExpressionIdentifier.DESCRIPTION, (Object)"Test Description");
        Assertions.assertThat((String)this.backgroundData.getDescription()).isEqualTo("Test Description");
    }

    @Test
    public void setDescription_nullValue() {
        this.backgroundData.setDescription(null);
        Assertions.assertThat((String)this.backgroundData.getDescription()).isEqualTo("");
    }

    @Test
    public void setDescription_nonNullValue() {
        this.backgroundData.setDescription("Test Description");
        Assertions.assertThat((String)this.backgroundData.getDescription()).isEqualTo("Test Description");
    }

    @Test
    public void addOrUpdateMappingValue() {
        FactMappingValue oldMappingValue = this.backgroundData.addMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)"Test 1");
        FactMappingValue newMappingValue = this.backgroundData.addOrUpdateMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)"Test 2");
        Assertions.assertThat((Object)newMappingValue).isEqualTo((Object)oldMappingValue);
        Assertions.assertThat((Object)newMappingValue.getRawValue()).isEqualTo((Object)"Test 2");
    }
}

