/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.api.model;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.drools.scenariosimulation.api.model.Background;
import org.drools.scenariosimulation.api.model.BackgroundData;
import org.drools.scenariosimulation.api.model.BackgroundDataWithIndex;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.ScesimModelDescriptor;
import org.junit.Before;
import org.junit.Test;

public class BackgroundTest {
    private Background background;
    private BackgroundData originalBackgroundData;

    @Before
    public void setup() {
        this.background = new Background();
        FactIdentifier factIdentifier = FactIdentifier.create((String)"Test", (String)String.class.getCanonicalName());
        ExpressionIdentifier expressionIdentifier = ExpressionIdentifier.create((String)"Test", (FactMappingType)FactMappingType.GIVEN);
        this.background.getScesimModelDescriptor().addFactMapping(factIdentifier, expressionIdentifier);
        this.originalBackgroundData = (BackgroundData)this.background.addData();
        this.originalBackgroundData.setDescription("Test Description");
        this.originalBackgroundData.addMappingValue(factIdentifier, expressionIdentifier, (Object)"TEST");
    }

    @Test
    public void addData() {
        this.background.addData(1);
        Assertions.assertThatThrownBy(() -> this.background.addData(-1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.background.addData(3)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    public void cloneModel() {
        Background cloned = this.background.cloneModel();
        Assertions.assertThat((Object)cloned).isNotNull();
        ScesimModelDescriptor originalDescriptor = this.background.getScesimModelDescriptor();
        ScesimModelDescriptor clonedDescriptor = cloned.getScesimModelDescriptor();
        Assertions.assertThat((List)clonedDescriptor.getUnmodifiableFactMappings()).hasSameSizeAs((Iterable)originalDescriptor.getUnmodifiableFactMappings());
        Assertions.assertThat((List)clonedDescriptor.getUnmodifiableFactMappings()).isEqualTo((Object)originalDescriptor.getUnmodifiableFactMappings());
        Assertions.assertThat((List)cloned.getUnmodifiableData()).hasSameSizeAs((Iterable)this.background.getUnmodifiableData());
        ((ListAssert)Assertions.assertThat((List)cloned.getUnmodifiableData()).usingElementComparator((x, y) -> x.getDescription().compareTo(y.getDescription()))).isEqualTo((Object)this.background.getUnmodifiableData());
    }

    @Test
    public void cloneData() {
        BackgroundData clonedBackgroundData = (BackgroundData)this.background.cloneData(0, 1);
        Assertions.assertThat((String)clonedBackgroundData.getDescription()).isEqualTo(this.originalBackgroundData.getDescription());
        Assertions.assertThat((List)clonedBackgroundData.getUnmodifiableFactMappingValues()).hasSameSizeAs((Iterable)this.originalBackgroundData.getUnmodifiableFactMappingValues());
        Assertions.assertThat((Object)((BackgroundData)this.background.getDataByIndex(0))).isEqualTo((Object)this.originalBackgroundData);
        Assertions.assertThat((Object)((BackgroundData)this.background.getDataByIndex(1))).isEqualTo((Object)clonedBackgroundData);
        Assertions.assertThat((Object)clonedBackgroundData).isNotEqualTo((Object)this.originalBackgroundData);
        Assertions.assertThat((Object)((FactMappingValue)clonedBackgroundData.getUnmodifiableFactMappingValues().get(0))).isNotEqualTo(this.originalBackgroundData.getUnmodifiableFactMappingValues().get(0));
    }

    @Test
    public void cloneScesimDataFail() {
        Assertions.assertThatThrownBy(() -> this.background.cloneData(-1, 1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.background.cloneData(2, 1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.background.cloneData(0, -1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.background.cloneData(0, 2)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    public void removeFactMappingByIndex() {
        this.background.removeFactMappingByIndex(0);
        Assertions.assertThat((List)((BackgroundData)this.background.getUnmodifiableData().get(0)).getUnmodifiableFactMappingValues()).hasSize(1);
        Assertions.assertThat((List)this.background.getScesimModelDescriptor().getUnmodifiableFactMappings()).hasSize(0);
    }

    @Test
    public void removeFactMapping() {
        this.background.removeFactMapping(this.background.getScesimModelDescriptor().getFactMappingByIndex(0));
        Assertions.assertThat((List)((BackgroundData)this.background.getUnmodifiableData().get(0)).getUnmodifiableFactMappingValues()).hasSize(1);
        Assertions.assertThat((List)this.background.getScesimModelDescriptor().getUnmodifiableFactMappings()).hasSize(0);
    }

    @Test
    public void getBackgroundDataWithIndex() {
        List backgroundDatas = this.background.getBackgroundDataWithIndex();
        Assertions.assertThat((List)backgroundDatas).hasSameSizeAs((Iterable)this.background.getUnmodifiableData());
        BackgroundDataWithIndex backgroundData = (BackgroundDataWithIndex)backgroundDatas.get(0);
        int index = backgroundData.getIndex();
        Assertions.assertThat((Object)((BackgroundData)backgroundData.getScesimData())).isEqualTo((Object)this.background.getDataByIndex(index - 1));
    }
}

