/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.api.model;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.junit.Test;

public class FactMappingTest {
    private FactMapping original;

    @Test
    public void cloneFactMapping() {
        this.original = new FactMapping("FACT_ALIAS", FactIdentifier.create((String)"FI_TEST", (String)"com.test.Foo"), new ExpressionIdentifier("EI_TEST", FactMappingType.GIVEN));
        this.original.addExpressionElement("FIRST_STEP", String.class.getName());
        this.original.setExpressionAlias("EA_TEST");
        this.original.setGenericTypes(new ArrayList());
        Assertions.assertThat((Object)this.original.cloneFactMapping()).isEqualTo((Object)this.original);
    }

    @Test
    public void getExpressionElementsWithoutClass_missingExpression() {
        this.original = new FactMapping("FACT_ALIAS", FactIdentifier.create((String)"FI_TEST", (String)"com.test.Foo"), new ExpressionIdentifier("EI_TEST", FactMappingType.GIVEN));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((FactMapping)this.original).getExpressionElementsWithoutClass()).isInstanceOf(IllegalStateException.class)).hasMessage("ExpressionElements malformed");
        Assertions.assertThat((List)this.original.getExpressionElements()).hasSize(0);
    }

    @Test
    public void getExpressionElementsWithoutClass_properlyFormed() {
        this.original = new FactMapping("FACT_ALIAS", FactIdentifier.create((String)"FI_TEST", (String)"com.test.Foo"), new ExpressionIdentifier("EI_TEST", FactMappingType.GIVEN));
        this.original.addExpressionElement("STEP", String.class.getCanonicalName());
        Assertions.assertThat((List)this.original.getExpressionElementsWithoutClass()).hasSize(0);
        Assertions.assertThat((List)this.original.getExpressionElements()).hasSize(1);
    }
}

