/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.api.model;

import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScesimModelDescriptor;
import org.drools.scenariosimulation.api.model.Simulation;
import org.junit.Before;
import org.junit.Test;

public class ScenarioTest {
    private ScesimModelDescriptor scesimModelDescriptor;
    private Scenario scenario;
    private FactIdentifier factIdentifier;
    private ExpressionIdentifier expressionIdentifier;
    private Simulation simulation;

    @Before
    public void init() {
        this.simulation = new Simulation();
        this.scesimModelDescriptor = this.simulation.getScesimModelDescriptor();
        this.scenario = (Scenario)this.simulation.addData();
        this.factIdentifier = FactIdentifier.create((String)"test fact", (String)String.class.getCanonicalName());
        this.expressionIdentifier = ExpressionIdentifier.create((String)"test expression", (FactMappingType)FactMappingType.EXPECT);
    }

    @Test
    public void addFactMappingValue() {
        FactMappingValue factMappingValue = this.scenario.addMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)"test value");
        Optional retrieved = this.scenario.getFactMappingValue(this.factIdentifier, this.expressionIdentifier);
        Assertions.assertThat((Optional)retrieved).isPresent();
        Assertions.assertThat((Object)factMappingValue.getRawValue()).isEqualTo((Object)"test value");
    }

    @Test
    public void removeFactMappingValueByIdentifiers() {
        this.scenario.addMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)"test value");
        this.scenario.removeFactMappingValueByIdentifiers(this.factIdentifier, this.expressionIdentifier);
        Assertions.assertThat((Optional)this.scenario.getFactMappingValue(this.factIdentifier, this.expressionIdentifier)).isNotPresent();
    }

    @Test
    public void removeFactMappingValue() {
        this.scenario.addMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)"test value");
        Optional retrieved = this.scenario.getFactMappingValue(this.factIdentifier, this.expressionIdentifier);
        this.scenario.removeFactMappingValue((FactMappingValue)retrieved.get());
        Assertions.assertThat((Optional)this.scenario.getFactMappingValue(this.factIdentifier, this.expressionIdentifier)).isNotPresent();
    }

    @Test(expected=IllegalArgumentException.class)
    public void addMappingValueTest() {
        this.scenario.addMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)"test value");
        this.scenario.addMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)"test value");
    }

    @Test
    public void getDescription_initialDescriptionIsEmpty() {
        Assertions.assertThat((String)this.scenario.getDescription()).isEqualTo("");
    }

    @Test
    public void getDescription_descriptionIsSetToNullValue() {
        Object description = null;
        this.scenario.addMappingValue(FactIdentifier.DESCRIPTION, ExpressionIdentifier.DESCRIPTION, description);
        Assertions.assertThat((String)this.scenario.getDescription()).isEqualTo("");
    }

    @Test
    public void getDescription_descriptionIsSetToNonNullValue() {
        String description = "Test Description";
        this.scenario.addMappingValue(FactIdentifier.DESCRIPTION, ExpressionIdentifier.DESCRIPTION, (Object)description);
        Assertions.assertThat((String)this.scenario.getDescription()).isEqualTo(description);
    }

    @Test
    public void setDescription_nullValue() {
        Scenario scenarioWithDescriptionNull = (Scenario)this.simulation.addData();
        scenarioWithDescriptionNull.setDescription(null);
        Assertions.assertThat((String)scenarioWithDescriptionNull.getDescription()).isEqualTo("");
    }

    @Test
    public void getDescription3() {
        Scenario scenarioWithDescriptionNull = (Scenario)this.simulation.addData();
        scenarioWithDescriptionNull.setDescription("Test Description");
        Assertions.assertThat((String)scenarioWithDescriptionNull.getDescription()).isEqualTo("Test Description");
    }

    @Test
    public void addOrUpdateMappingValue() {
        String value2 = "Test 2";
        FactMappingValue factMappingValue = this.scenario.addMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)"Test 1");
        FactMappingValue factMappingValue1 = this.scenario.addOrUpdateMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)value2);
        Assertions.assertThat((Object)factMappingValue1).isEqualTo((Object)factMappingValue);
        Assertions.assertThat((Object)factMappingValue1.getRawValue()).isEqualTo((Object)value2);
    }
}

