/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.api.model;

import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.ScesimModelDescriptor;
import org.junit.Before;
import org.junit.Test;

public class ScesimModelDescriptorTest {
    private ScesimModelDescriptor modelDescriptor;
    private FactIdentifier factIdentifier;
    private ExpressionIdentifier expressionIdentifier;
    private FactIdentifier factIdentifier2;
    private ExpressionIdentifier expressionIdentifier2;

    @Before
    public void init() {
        this.modelDescriptor = new ScesimModelDescriptor();
        this.factIdentifier = FactIdentifier.create((String)"test fact", (String)String.class.getCanonicalName());
        this.expressionIdentifier = ExpressionIdentifier.create((String)"test expression", (FactMappingType)FactMappingType.EXPECT);
        this.factIdentifier2 = FactIdentifier.create((String)"test fact 2", (String)Integer.class.getCanonicalName());
        this.expressionIdentifier2 = ExpressionIdentifier.create((String)"test expression 2", (FactMappingType)FactMappingType.GIVEN);
    }

    @Test
    public void getFactIdentifiers() {
        this.modelDescriptor.addFactMapping(this.factIdentifier, this.expressionIdentifier);
        ((AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat((Collection)this.modelDescriptor.getFactIdentifiers()).isNotNull()).hasSize(1)).containsExactly((Object[])new FactIdentifier[]{this.factIdentifier});
    }

    @Test
    public void addFactMapping_byIndexAndFactMapping() {
        FactMapping toClone = new FactMapping();
        toClone.setFactAlias("ALIAS");
        toClone.setExpressionAlias("EXPRESSION_ALIAS");
        FactMapping cloned = this.modelDescriptor.addFactMapping(0, toClone);
        Assertions.assertThat((String)cloned.getFactAlias()).isEqualTo(toClone.getFactAlias());
        Assertions.assertThat((String)cloned.getExpressionAlias()).isEqualTo(toClone.getExpressionAlias());
    }

    @Test
    public void addFactMapping_byFactIdentifierAndExpressionIdentifier() {
        this.modelDescriptor.addFactMapping(this.factIdentifier, this.expressionIdentifier);
        this.modelDescriptor.addFactMapping(this.factIdentifier2, this.expressionIdentifier2);
        Assertions.assertThat((String)this.modelDescriptor.getFactMappingByIndex(0).getFactAlias()).isEqualTo(this.factIdentifier.getName());
        Assertions.assertThat((Object)this.modelDescriptor.getFactMappingByIndex(0).getFactIdentifier()).isEqualTo((Object)this.factIdentifier);
        Assertions.assertThat((Object)this.modelDescriptor.getFactMappingByIndex(0).getExpressionIdentifier()).isEqualTo((Object)this.expressionIdentifier);
        Assertions.assertThat((String)this.modelDescriptor.getFactMappingByIndex(1).getFactAlias()).isEqualTo(this.factIdentifier2.getName());
        Assertions.assertThat((Object)this.modelDescriptor.getFactMappingByIndex(1).getFactIdentifier()).isEqualTo((Object)this.factIdentifier2);
        Assertions.assertThat((Object)this.modelDescriptor.getFactMappingByIndex(1).getExpressionIdentifier()).isEqualTo((Object)this.expressionIdentifier2);
    }

    @Test
    public void addFactMapping_byFactIdentifierAndExpressionIdentifier_fail() {
        this.modelDescriptor.addFactMapping(this.factIdentifier, this.expressionIdentifier);
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> this.modelDescriptor.addFactMapping(this.factIdentifier, this.expressionIdentifier));
    }

    @Test
    public void addFactMapping_byIndexAndFactIdentifierAndExpressionIdentifier() {
        this.modelDescriptor.addFactMapping(0, this.factIdentifier, this.expressionIdentifier);
        this.modelDescriptor.addFactMapping(0, this.factIdentifier2, this.expressionIdentifier2);
        Assertions.assertThat((String)this.modelDescriptor.getFactMappingByIndex(1).getFactAlias()).isEqualTo(this.factIdentifier.getName());
        Assertions.assertThat((Object)this.modelDescriptor.getFactMappingByIndex(1).getFactIdentifier()).isEqualTo((Object)this.factIdentifier);
        Assertions.assertThat((Object)this.modelDescriptor.getFactMappingByIndex(1).getExpressionIdentifier()).isEqualTo((Object)this.expressionIdentifier);
        Assertions.assertThat((String)this.modelDescriptor.getFactMappingByIndex(0).getFactAlias()).isEqualTo(this.factIdentifier2.getName());
        Assertions.assertThat((Object)this.modelDescriptor.getFactMappingByIndex(0).getFactIdentifier()).isEqualTo((Object)this.factIdentifier2);
        Assertions.assertThat((Object)this.modelDescriptor.getFactMappingByIndex(0).getExpressionIdentifier()).isEqualTo((Object)this.expressionIdentifier2);
    }

    @Test
    public void addFactMappingByIndexAndFactIdentifierAndExpressionIdentifierFail() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> this.modelDescriptor.addFactMapping(1, this.factIdentifier, this.expressionIdentifier));
    }

    @Test
    public void removeFactMappingByIndex() {
        this.modelDescriptor.addFactMapping(this.factIdentifier, this.expressionIdentifier);
        this.modelDescriptor.removeFactMappingByIndex(0);
        Assertions.assertThatExceptionOfType(IndexOutOfBoundsException.class).isThrownBy(() -> this.modelDescriptor.getFactMappingByIndex(0));
    }

    @Test
    public void removeFactMapping() {
        FactMapping retrieved = this.modelDescriptor.addFactMapping(this.factIdentifier, this.expressionIdentifier);
        this.modelDescriptor.removeFactMapping(retrieved);
        Assertions.assertThat((List)this.modelDescriptor.getUnmodifiableFactMappings()).doesNotContain((Object[])new FactMapping[]{retrieved});
    }

    @Test
    public void getIndexByIdentifierTest() {
        FactMapping factMapping0 = this.modelDescriptor.addFactMapping(this.factIdentifier, this.expressionIdentifier);
        FactMapping factMapping1 = this.modelDescriptor.addFactMapping(this.factIdentifier2, this.expressionIdentifier);
        int indexToCheck = 0;
        int indexRetrieved = this.modelDescriptor.getIndexByIdentifier(factMapping0.getFactIdentifier(), this.expressionIdentifier);
        Assertions.assertThat((int)indexRetrieved).isEqualTo(indexToCheck);
        indexToCheck = 1;
        indexRetrieved = this.modelDescriptor.getIndexByIdentifier(factMapping1.getFactIdentifier(), this.expressionIdentifier);
        Assertions.assertThat((int)indexRetrieved).isEqualTo(indexToCheck);
    }

    @Test
    public void getIndexByIdentifierTestFail() {
        FactIdentifier notExisting = new FactIdentifier();
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> this.modelDescriptor.getIndexByIdentifier(notExisting, this.expressionIdentifier));
    }

    @Test
    public void getFactMappingsByFactName() {
        this.modelDescriptor.addFactMapping(FactIdentifier.create((String)"test", (String)String.class.getCanonicalName()), ExpressionIdentifier.create((String)"test expression 0", (FactMappingType)FactMappingType.EXPECT));
        this.modelDescriptor.addFactMapping(FactIdentifier.create((String)"test", (String)String.class.getCanonicalName()), ExpressionIdentifier.create((String)"test expression 1", (FactMappingType)FactMappingType.EXPECT));
        this.modelDescriptor.addFactMapping(FactIdentifier.create((String)"TEST", (String)String.class.getCanonicalName()), ExpressionIdentifier.create((String)"test expression 2", (FactMappingType)FactMappingType.EXPECT));
        this.modelDescriptor.addFactMapping(FactIdentifier.create((String)"Test", (String)String.class.getCanonicalName()), ExpressionIdentifier.create((String)"test expression 3", (FactMappingType)FactMappingType.EXPECT));
        this.modelDescriptor.addFactMapping(FactIdentifier.create((String)"tEsT", (String)String.class.getCanonicalName()), ExpressionIdentifier.create((String)"test expression 4", (FactMappingType)FactMappingType.EXPECT));
        Stream retrieved = this.modelDescriptor.getFactMappingsByFactName("test");
        ((ListAssert)Assertions.assertThat((Stream)retrieved).isNotNull()).hasSize(5);
    }

    @Test
    public void moveFactMappingTest() {
        ExpressionIdentifier expressionIdentifier2 = ExpressionIdentifier.create((String)"Test expression 2", (FactMappingType)FactMappingType.GIVEN);
        ExpressionIdentifier expressionIdentifier3 = ExpressionIdentifier.create((String)"Test expression 3", (FactMappingType)FactMappingType.GIVEN);
        FactMapping factMapping1 = this.modelDescriptor.addFactMapping(this.factIdentifier, this.expressionIdentifier);
        FactMapping factMapping2 = this.modelDescriptor.addFactMapping(this.factIdentifier, expressionIdentifier2);
        FactMapping factMapping3 = this.modelDescriptor.addFactMapping(this.factIdentifier, expressionIdentifier3);
        Assertions.assertThat((List)this.modelDescriptor.getUnmodifiableFactMappings()).containsExactly((Object[])new FactMapping[]{factMapping1, factMapping2, factMapping3});
        this.modelDescriptor.moveFactMapping(0, 1);
        Assertions.assertThat((List)this.modelDescriptor.getUnmodifiableFactMappings()).containsExactly((Object[])new FactMapping[]{factMapping2, factMapping1, factMapping3});
    }

    @Test
    public void moveFactMapping_failsOutsideBoundaries() {
        ExpressionIdentifier expressionIdentifier2 = ExpressionIdentifier.create((String)"Test expression 2", (FactMappingType)FactMappingType.GIVEN);
        this.modelDescriptor.addFactMapping(this.factIdentifier, this.expressionIdentifier);
        this.modelDescriptor.addFactMapping(this.factIdentifier, expressionIdentifier2);
        Assertions.assertThatExceptionOfType(IndexOutOfBoundsException.class).isThrownBy(() -> this.modelDescriptor.moveFactMapping(2, 0));
        Assertions.assertThatExceptionOfType(IndexOutOfBoundsException.class).isThrownBy(() -> this.modelDescriptor.moveFactMapping(-1, 0));
        Assertions.assertThatExceptionOfType(IndexOutOfBoundsException.class).isThrownBy(() -> this.modelDescriptor.moveFactMapping(0, 2));
        Assertions.assertThatExceptionOfType(IndexOutOfBoundsException.class).isThrownBy(() -> this.modelDescriptor.moveFactMapping(2, -1));
    }
}

