/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.expression;

import java.util.Arrays;
import java.util.Collection;
import org.drools.scenariosimulation.backend.expression.BaseExpressionEvaluator;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ParameterizedBaseExpressionEvaluatorTest {
    private static final ClassLoader classLoader = ParameterizedBaseExpressionEvaluatorTest.class.getClassLoader();
    private static final BaseExpressionEvaluator baseExpressionEvaluator = new BaseExpressionEvaluator(classLoader);
    @Parameterized.Parameter(value=0)
    public Boolean expectedResult;
    @Parameterized.Parameter(value=1)
    public Object resultValue;
    @Parameterized.Parameter(value=2)
    public Object exprToTest;
    @Parameterized.Parameter(value=3)
    public Class<?> clazz;

    @Parameterized.Parameters(name="{index}: Expr \"{0} {1}\" should be true")
    public static Collection<Object[]> data() {
        return Arrays.asList({true, 1, 1, Integer.TYPE}, {true, 1, "1", Integer.TYPE}, {true, 2, "!= 1", Integer.TYPE}, {true, -1, "- 1", Integer.TYPE}, {true, -2, "< -  1", Integer.TYPE}, {true, -2L, "< -  1", Long.TYPE}, {true, -2.0, "< -  1", Double.TYPE}, {true, Float.valueOf(-2.0f), "< -  1", Float.TYPE}, {true, (short)-2, "< - 1", Short.TYPE}, {true, "String", "<> Test", String.class}, {true, "Test", "= Test", String.class}, {true, 1, "<2", Integer.TYPE}, {true, 1, "<2; >0", Integer.TYPE}, {true, 2, " <= 2 ", Integer.TYPE}, {true, 2, " >= 2", Integer.TYPE}, {true, 1, "[ 1, 2 ,3]", Integer.TYPE}, {true, 2, "[ 1, 2 ,3]", Integer.TYPE}, {true, "3", "[ 1, 2 ,3]", String.class}, {true, 4, "![ 1, 2 ,3]", Integer.TYPE}, {true, 4, "! < 1", Integer.TYPE}, {true, 1, "> -1", Integer.TYPE}, {true, 10, "!= <10;!= >11", Integer.TYPE}, {true, 10, "= 10; >9", Integer.TYPE}, {true, null, null, Integer.class}, {true, null, "!1", Integer.class}, {true, Character.valueOf('b'), "!a", Character.class}, {true, "0".getBytes()[0], "!b", Byte.class}, {true, (short)1, ">0", Short.class}, {true, null, "[ !false]", Boolean.TYPE}, {true, null, "[! false, ! true]", Boolean.TYPE}, {true, 10, "[> 1]", Integer.TYPE}, {true, 10, "[< 1, > 1]", Integer.TYPE}, {true, "", ";", String.class}, {false, null, ";", String.class}, {false, null, "=", String.class}, {false, null, "[]", String.class}, {true, Error.class, ";", Boolean.TYPE}, {true, Error.class, "[]", Boolean.TYPE}, {true, Error.class, "=", Boolean.TYPE}, {true, Error.class, "!= false; <> false, ! false", Boolean.TYPE}, {true, Error.class, "<> false, ! false", Boolean.TYPE}, {true, Error.class, "! tru", Void.TYPE}, {true, Error.class, "fals", Void.TYPE}, {true, Error.class, "!= fals", Void.TYPE}, {true, Error.class, "tru", Void.TYPE}, {true, Error.class, "<> fals", Void.TYPE}, {true, Error.class, "tru", Void.TYPE}, {true, Error.class, "!m= false", Void.TYPE}, {true, Error.class, ">> 3", Void.TYPE}, {true, Error.class, "< - 1 1", Integer.TYPE});
    }

    @Test
    public void evaluateUnaryExpression() {
        if (!(this.resultValue instanceof Class)) {
            Assert.assertEquals((Object)this.expectedResult, (Object)baseExpressionEvaluator.evaluateUnaryExpression(this.exprToTest, this.resultValue, this.clazz));
        } else {
            try {
                baseExpressionEvaluator.evaluateUnaryExpression(this.exprToTest, (Object)true, this.clazz);
                Assert.fail();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

