/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.fluent;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.backend.fluent.AddCoverageListenerCommand;
import org.drools.scenariosimulation.backend.fluent.RuleStatefulScenarioExecutableBuilder;
import org.drools.scenariosimulation.backend.fluent.ValidateFactCommand;
import org.drools.scenariosimulation.backend.runner.ScenarioException;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResult;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.Executable;
import org.kie.api.runtime.ExecutableRunner;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.RequestContext;
import org.kie.internal.builder.fluent.ExecutableBuilder;
import org.kie.internal.builder.fluent.KieContainerFluent;
import org.kie.internal.builder.fluent.KieSessionFluent;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class RuleStatefulScenarioExecutableBuilderTest {
    @Mock
    private ExecutableBuilder executableBuilderMock;
    @Mock
    private ExecutableRunner<RequestContext> executableRunnerMock;
    @Mock
    private KieContainerFluent kieContainerFluent;
    @Mock
    private KieSessionFluent kieSessionFluentMock;
    @Mock
    private RequestContext requestContextMock;
    @Captor
    private ArgumentCaptor<ExecutableCommand<?>> commandArgumentCaptor;

    @Test
    public void testPseudoClock() {
        KieContainer kieContainerMock = (KieContainer)Mockito.mock(KieContainer.class);
        Mockito.when((Object)kieContainerMock.getKieSessionModel(Matchers.anyString())).thenReturn(null);
        Assertions.assertThatThrownBy(() -> {
            KieContainer cfr_ignored_0 = (KieContainer)RuleStatefulScenarioExecutableBuilder.forcePseudoClock.apply(null, kieContainerMock);
        }).isInstanceOf(ScenarioException.class);
        Mockito.when((Object)kieContainerMock.getKieSessionModel(Matchers.anyString())).thenReturn(Mockito.mock(KieSessionModel.class));
        RuleStatefulScenarioExecutableBuilder.forcePseudoClock.apply(null, kieContainerMock);
    }

    @Test
    public void testBuilder() {
        Mockito.when((Object)this.executableBuilderMock.newApplicationContext(Matchers.anyString())).thenReturn((Object)this.executableBuilderMock);
        Mockito.when((Object)this.executableBuilderMock.setKieContainer((KieContainer)Matchers.any(KieContainer.class))).thenReturn((Object)this.kieContainerFluent);
        Mockito.when((Object)this.kieContainerFluent.newSessionCustomized(Matchers.anyString(), (BiFunction)Matchers.any())).thenReturn((Object)this.kieSessionFluentMock);
        Mockito.when((Object)this.kieSessionFluentMock.dispose()).thenReturn((Object)this.executableBuilderMock);
        Mockito.when((Object)this.kieSessionFluentMock.addCommand((ExecutableCommand)Matchers.any())).thenReturn((Object)this.kieSessionFluentMock);
        Mockito.when((Object)this.executableRunnerMock.execute((Executable)Matchers.any(Executable.class))).thenReturn((Object)this.requestContextMock);
        Mockito.when((Object)this.requestContextMock.getOutputs()).thenReturn(Collections.emptyMap());
        RuleStatefulScenarioExecutableBuilder builder = new RuleStatefulScenarioExecutableBuilder(null, null){

            protected ExecutableBuilder createExecutableBuilder() {
                return RuleStatefulScenarioExecutableBuilderTest.this.executableBuilderMock;
            }

            protected ExecutableRunner<RequestContext> createExecutableRunner() {
                return RuleStatefulScenarioExecutableBuilderTest.this.executableRunnerMock;
            }
        };
        Object toInsert = new Object();
        String agendaGroup = "agendaGroup";
        String ruleFlowGroup = "ruleFlowGroup";
        FactIdentifier indexFI = FactIdentifier.INDEX;
        builder.setActiveAgendaGroup(agendaGroup);
        ((KieSessionFluent)Mockito.verify((Object)this.kieSessionFluentMock, (VerificationMode)Mockito.times((int)1))).setActiveAgendaGroup((String)Matchers.eq((Object)agendaGroup));
        Mockito.reset((Object[])new KieContainerFluent[]{this.kieContainerFluent});
        builder.setActiveRuleFlowGroup(ruleFlowGroup);
        ((KieSessionFluent)Mockito.verify((Object)this.kieSessionFluentMock, (VerificationMode)Mockito.times((int)1))).setActiveAgendaGroup((String)Matchers.eq((Object)agendaGroup));
        Mockito.reset((Object[])new KieContainerFluent[]{this.kieContainerFluent});
        builder.insert(toInsert);
        ((KieSessionFluent)Mockito.verify((Object)this.kieSessionFluentMock, (VerificationMode)Mockito.times((int)1))).insert(Matchers.eq((Object)toInsert));
        Mockito.reset((Object[])new KieContainerFluent[]{this.kieContainerFluent});
        builder.addInternalCondition(String.class, obj -> null, new ScenarioResult(indexFI, null));
        Map result = builder.run();
        ((KieSessionFluent)Mockito.verify((Object)this.kieSessionFluentMock, (VerificationMode)Mockito.times((int)1))).fireAllRules();
        ((KieSessionFluent)Mockito.verify((Object)this.kieSessionFluentMock, (VerificationMode)Mockito.times((int)3))).addCommand((ExecutableCommand)this.commandArgumentCaptor.capture());
        List allAddCommands = this.commandArgumentCaptor.getAllValues();
        Assert.assertTrue((boolean)allAddCommands.stream().map(Object::getClass).anyMatch(ValidateFactCommand.class::isAssignableFrom));
        Assert.assertTrue((boolean)allAddCommands.stream().map(Object::getClass).anyMatch(AddCoverageListenerCommand.class::isAssignableFrom));
        Assert.assertTrue((boolean)result.containsKey("COVERAGE_LISTENER"));
        ((KieSessionFluent)Mockito.verify((Object)this.kieSessionFluentMock, (VerificationMode)Mockito.times((int)1))).out((String)Matchers.eq((Object)"RULES_AVAILABLE"));
    }
}

