/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.fluent;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.drools.core.command.runtime.rule.AgendaGroupSetFocusCommand;
import org.drools.core.command.runtime.rule.FireAllRulesCommand;
import org.drools.core.command.runtime.rule.InsertElementsCommand;
import org.drools.core.fluent.impl.Batch;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.backend.fluent.AddCoverageListenerCommand;
import org.drools.scenariosimulation.backend.fluent.RuleStatelessScenarioExecutableBuilder;
import org.drools.scenariosimulation.backend.fluent.ValidateFactCommand;
import org.drools.scenariosimulation.backend.runner.ScenarioException;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResult;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.KieBase;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.command.Command;
import org.kie.api.runtime.ExecutionResults;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.StatelessKieSession;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class RuleStatelessScenarioExecutableBuilderTest {
    @Mock
    private KieContainer kieContainerMock;
    @Mock
    private StatelessKieSession statelessKieSessionMock;
    @Mock
    private KieBase kieBaseMock;

    @Test
    public void testBuilder() {
        Mockito.when((Object)this.kieContainerMock.newStatelessKieSession(Matchers.anyString())).thenReturn((Object)this.statelessKieSessionMock);
        Mockito.when((Object)this.statelessKieSessionMock.getKieBase()).thenReturn((Object)this.kieBaseMock);
        Mockito.when((Object)this.kieBaseMock.getKiePackages()).thenReturn(Collections.emptyList());
        String sessionName = "sessionName";
        RuleStatelessScenarioExecutableBuilder builder = new RuleStatelessScenarioExecutableBuilder(this.kieContainerMock, sessionName);
        Mockito.when((Object)this.kieContainerMock.getKieSessionModel(Matchers.anyString())).thenReturn(null);
        Assertions.assertThatThrownBy(() -> ((RuleStatelessScenarioExecutableBuilder)builder).run()).isInstanceOf(ScenarioException.class);
        Mockito.when((Object)this.kieContainerMock.getKieSessionModel(Matchers.anyString())).thenReturn(Mockito.mock(KieSessionModel.class));
        Map result = builder.run();
        ((KieContainer)Mockito.verify((Object)this.kieContainerMock, (VerificationMode)Mockito.times((int)1))).newStatelessKieSession((String)Matchers.eq((Object)sessionName));
        Assert.assertTrue((boolean)result.containsKey("COVERAGE_LISTENER"));
        Assert.assertTrue((boolean)result.containsKey("RULES_AVAILABLE"));
    }

    @Test
    public void generateCommands() {
        RuleStatelessScenarioExecutableBuilder builder = new RuleStatelessScenarioExecutableBuilder(null, null);
        Command batchCommand = builder.generateCommands(null);
        Assert.assertTrue((boolean)this.verifyCommand((Command<ExecutionResults>)batchCommand, AddCoverageListenerCommand.class));
        Assert.assertTrue((boolean)this.verifyCommand((Command<ExecutionResults>)batchCommand, FireAllRulesCommand.class));
        Assert.assertFalse((boolean)this.verifyCommand((Command<ExecutionResults>)batchCommand, AgendaGroupSetFocusCommand.class));
        Assert.assertFalse((boolean)this.verifyCommand((Command<ExecutionResults>)batchCommand, InsertElementsCommand.class));
        Assert.assertFalse((boolean)this.verifyCommand((Command<ExecutionResults>)batchCommand, ValidateFactCommand.class));
        builder.setActiveAgendaGroup("test");
        batchCommand = builder.generateCommands(null);
        Assert.assertTrue((boolean)this.verifyCommand((Command<ExecutionResults>)batchCommand, AddCoverageListenerCommand.class));
        Assert.assertTrue((boolean)this.verifyCommand((Command<ExecutionResults>)batchCommand, FireAllRulesCommand.class));
        Assert.assertTrue((boolean)this.verifyCommand((Command<ExecutionResults>)batchCommand, AgendaGroupSetFocusCommand.class));
        Assert.assertFalse((boolean)this.verifyCommand((Command<ExecutionResults>)batchCommand, InsertElementsCommand.class));
        Assert.assertFalse((boolean)this.verifyCommand((Command<ExecutionResults>)batchCommand, ValidateFactCommand.class));
        builder.insert(new Object());
        batchCommand = builder.generateCommands(null);
        Assert.assertTrue((boolean)this.verifyCommand((Command<ExecutionResults>)batchCommand, AddCoverageListenerCommand.class));
        Assert.assertTrue((boolean)this.verifyCommand((Command<ExecutionResults>)batchCommand, FireAllRulesCommand.class));
        Assert.assertTrue((boolean)this.verifyCommand((Command<ExecutionResults>)batchCommand, AgendaGroupSetFocusCommand.class));
        Assert.assertTrue((boolean)this.verifyCommand((Command<ExecutionResults>)batchCommand, InsertElementsCommand.class));
        Assert.assertFalse((boolean)this.verifyCommand((Command<ExecutionResults>)batchCommand, ValidateFactCommand.class));
        builder.addInternalCondition(String.class, obj -> null, new ScenarioResult(FactIdentifier.EMPTY, null));
        batchCommand = builder.generateCommands(null);
        Assert.assertTrue((boolean)this.verifyCommand((Command<ExecutionResults>)batchCommand, AddCoverageListenerCommand.class));
        Assert.assertTrue((boolean)this.verifyCommand((Command<ExecutionResults>)batchCommand, FireAllRulesCommand.class));
        Assert.assertTrue((boolean)this.verifyCommand((Command<ExecutionResults>)batchCommand, AgendaGroupSetFocusCommand.class));
        Assert.assertTrue((boolean)this.verifyCommand((Command<ExecutionResults>)batchCommand, InsertElementsCommand.class));
        Assert.assertTrue((boolean)this.verifyCommand((Command<ExecutionResults>)batchCommand, ValidateFactCommand.class));
    }

    private boolean verifyCommand(Command<ExecutionResults> batchCommand, Class<?> classToFind) {
        if (!(batchCommand instanceof Batch)) {
            Assert.fail();
        }
        List commands = ((Batch)batchCommand).getCommands();
        return commands.stream().anyMatch(classToFind::isInstance);
    }
}

