/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.runner;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.api.model.AuditLogLine;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.FactMappingValueStatus;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.scenariosimulation.backend.TestUtils;
import org.drools.scenariosimulation.backend.expression.DMNFeelExpressionEvaluator;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluator;
import org.drools.scenariosimulation.backend.fluent.DMNScenarioExecutableBuilder;
import org.drools.scenariosimulation.backend.model.Dispute;
import org.drools.scenariosimulation.backend.model.Person;
import org.drools.scenariosimulation.backend.runner.DMNScenarioRunnerHelper;
import org.drools.scenariosimulation.backend.runner.RuleScenarioRunnerHelperTest;
import org.drools.scenariosimulation.backend.runner.ScenarioException;
import org.drools.scenariosimulation.backend.runner.model.ResultWrapper;
import org.drools.scenariosimulation.backend.runner.model.ScenarioExpect;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResult;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResultMetadata;
import org.drools.scenariosimulation.backend.runner.model.ScenarioRunnerData;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.dmn.api.core.DMNDecisionResult;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.ast.DecisionNode;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DMNScenarioRunnerHelperTest {
    private static final String NAME = "NAME";
    private static final String FEEL_EXPRESSION_NAME = "\"NAME\"";
    private static final BigDecimal AMOUNT = BigDecimal.valueOf(10L);
    private static final String TEST_DESCRIPTION = "Test description";
    private static final ClassLoader classLoader = RuleScenarioRunnerHelperTest.class.getClassLoader();
    private static final ExpressionEvaluator expressionEvaluator = new DMNFeelExpressionEvaluator(classLoader);
    private static final DMNScenarioRunnerHelper runnerHelper = new DMNScenarioRunnerHelper();
    @Mock
    protected Map<String, Object> requestContextMock;
    @Mock
    protected DMNResult dmnResultMock;
    @Mock
    protected DMNDecisionResult dmnDecisionResultMock;
    @Mock
    protected DMNModel dmnModelMock;
    private Simulation simulation;
    private FactIdentifier personFactIdentifier;
    private ExpressionIdentifier firstNameGivenExpressionIdentifier;
    private FactMapping firstNameGivenFactMapping;
    private Scenario scenario1;
    private Scenario scenario2;
    private ExpressionIdentifier firstNameExpectedExpressionIdentifier;
    private FactMapping firstNameExpectedFactMapping;
    private FactIdentifier disputeFactIdentifier;
    private ExpressionIdentifier amountGivenExpressionIdentifier;
    private FactMapping amountNameGivenFactMapping;
    private ExpressionIdentifier amountExpectedExpressionIdentifier;
    private FactMapping amountNameExpectedFactMapping;
    private FactMappingValue amountNameExpectedFactMappingValue;
    private FactMappingValue firstNameExpectedValue;

    @Before
    public void init() {
        this.simulation = new Simulation();
        this.personFactIdentifier = FactIdentifier.create((String)"Fact 1", (String)Person.class.getCanonicalName());
        this.firstNameGivenExpressionIdentifier = ExpressionIdentifier.create((String)"First Name Given", (FactMappingType)FactMappingType.GIVEN);
        this.firstNameGivenFactMapping = this.simulation.getSimulationDescriptor().addFactMapping(this.personFactIdentifier, this.firstNameGivenExpressionIdentifier);
        this.firstNameGivenFactMapping.addExpressionElement("Fact 1", String.class.getCanonicalName());
        this.firstNameGivenFactMapping.addExpressionElement("firstName", String.class.getCanonicalName());
        this.disputeFactIdentifier = FactIdentifier.create((String)"Fact 2", (String)Dispute.class.getCanonicalName());
        this.amountGivenExpressionIdentifier = ExpressionIdentifier.create((String)"Amount Given", (FactMappingType)FactMappingType.GIVEN);
        this.amountNameGivenFactMapping = this.simulation.getSimulationDescriptor().addFactMapping(this.disputeFactIdentifier, this.amountGivenExpressionIdentifier);
        this.amountNameGivenFactMapping.addExpressionElement("Fact 2", BigDecimal.class.getCanonicalName());
        this.amountNameGivenFactMapping.addExpressionElement("amount", BigDecimal.class.getCanonicalName());
        this.firstNameExpectedExpressionIdentifier = ExpressionIdentifier.create((String)"First Name Expected", (FactMappingType)FactMappingType.EXPECT);
        this.firstNameExpectedFactMapping = this.simulation.getSimulationDescriptor().addFactMapping(this.personFactIdentifier, this.firstNameExpectedExpressionIdentifier);
        this.firstNameExpectedFactMapping.addExpressionElement("Fact 1", String.class.getCanonicalName());
        this.firstNameExpectedFactMapping.addExpressionElement("firstName", String.class.getCanonicalName());
        this.amountExpectedExpressionIdentifier = ExpressionIdentifier.create((String)"Amount Expected", (FactMappingType)FactMappingType.EXPECT);
        this.amountNameExpectedFactMapping = this.simulation.getSimulationDescriptor().addFactMapping(this.disputeFactIdentifier, this.amountExpectedExpressionIdentifier);
        this.amountNameExpectedFactMapping.addExpressionElement("Fact 2", Double.class.getCanonicalName());
        this.amountNameExpectedFactMapping.addExpressionElement("amount", Double.class.getCanonicalName());
        this.scenario1 = this.simulation.addScenario();
        this.scenario1.setDescription(TEST_DESCRIPTION);
        this.scenario1.addMappingValue(this.personFactIdentifier, this.firstNameGivenExpressionIdentifier, (Object)FEEL_EXPRESSION_NAME);
        this.firstNameExpectedValue = this.scenario1.addMappingValue(this.personFactIdentifier, this.firstNameExpectedExpressionIdentifier, (Object)FEEL_EXPRESSION_NAME);
        this.scenario2 = this.simulation.addScenario();
        this.scenario2.setDescription(TEST_DESCRIPTION);
        this.scenario2.addMappingValue(this.personFactIdentifier, this.firstNameGivenExpressionIdentifier, (Object)FEEL_EXPRESSION_NAME);
        this.scenario2.addMappingValue(this.personFactIdentifier, this.firstNameExpectedExpressionIdentifier, (Object)FEEL_EXPRESSION_NAME);
        this.scenario2.addMappingValue(this.disputeFactIdentifier, this.amountGivenExpressionIdentifier, (Object)AMOUNT);
        this.amountNameExpectedFactMappingValue = this.scenario2.addMappingValue(this.disputeFactIdentifier, this.amountExpectedExpressionIdentifier, (Object)AMOUNT);
        Mockito.when((Object)this.requestContextMock.get(DMNScenarioExecutableBuilder.DMN_RESULT)).thenReturn((Object)this.dmnResultMock);
        Mockito.when((Object)this.requestContextMock.get(DMNScenarioExecutableBuilder.DMN_MODEL)).thenReturn((Object)this.dmnModelMock);
    }

    @Test
    public void verifyConditions() {
        ScenarioRunnerData scenarioRunnerData1 = new ScenarioRunnerData();
        scenarioRunnerData1.addExpect(new ScenarioExpect(this.personFactIdentifier, Collections.singletonList(this.firstNameExpectedValue)));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> runnerHelper.verifyConditions(this.simulation.getSimulationDescriptor(), scenarioRunnerData1, expressionEvaluator, this.requestContextMock)).isInstanceOf(ScenarioException.class)).hasMessage("DMN execution has not generated a decision result with name Fact 1");
        Mockito.when((Object)this.dmnResultMock.getDecisionResultByName(Mockito.anyString())).thenReturn((Object)this.dmnDecisionResultMock);
        Mockito.when((Object)this.dmnDecisionResultMock.getEvaluationStatus()).thenReturn((Object)DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED);
        runnerHelper.verifyConditions(this.simulation.getSimulationDescriptor(), scenarioRunnerData1, expressionEvaluator, this.requestContextMock);
        Assert.assertEquals((long)1L, (long)scenarioRunnerData1.getResults().size());
        Assert.assertFalse((boolean)((ScenarioResult)scenarioRunnerData1.getResults().get(0)).getResult());
        Mockito.when((Object)this.dmnDecisionResultMock.getResult()).thenReturn((Object)"");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> runnerHelper.verifyConditions(this.simulation.getSimulationDescriptor(), scenarioRunnerData1, expressionEvaluator, this.requestContextMock)).isInstanceOf(ScenarioException.class)).hasMessage("Wrong resultRaw structure because it is not a complex type as expected");
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("firstName", "WrongValue");
        Mockito.when((Object)this.dmnDecisionResultMock.getResult()).thenReturn(resultMap);
        ScenarioRunnerData scenarioRunnerData2 = new ScenarioRunnerData();
        scenarioRunnerData2.addExpect(new ScenarioExpect(this.personFactIdentifier, Collections.singletonList(this.firstNameExpectedValue)));
        runnerHelper.verifyConditions(this.simulation.getSimulationDescriptor(), scenarioRunnerData2, expressionEvaluator, this.requestContextMock);
        Assert.assertEquals((long)1L, (long)scenarioRunnerData2.getResults().size());
        Assert.assertFalse((boolean)((ScenarioResult)scenarioRunnerData2.getResults().get(0)).getResult());
        ScenarioRunnerData scenarioRunnerData3 = new ScenarioRunnerData();
        scenarioRunnerData3.addExpect(new ScenarioExpect(this.personFactIdentifier, Collections.singletonList(this.firstNameExpectedValue)));
        resultMap.put("firstName", NAME);
        runnerHelper.verifyConditions(this.simulation.getSimulationDescriptor(), scenarioRunnerData3, expressionEvaluator, this.requestContextMock);
        Assert.assertEquals((long)1L, (long)scenarioRunnerData3.getResults().size());
        Assert.assertTrue((boolean)((ScenarioResult)scenarioRunnerData3.getResults().get(0)).getResult());
        runnerHelper.verifyConditions(this.simulation.getSimulationDescriptor(), scenarioRunnerData3, (ExpressionEvaluator)Mockito.mock(ExpressionEvaluator.class), this.requestContextMock);
        Assert.assertEquals((Object)FactMappingValueStatus.FAILED_WITH_ERROR, (Object)((ScenarioResult)scenarioRunnerData3.getResults().get(0)).getFactMappingValue().getStatus());
    }

    @Test
    public void createObject() {
        HashMap<List<String>, Object> params = new HashMap<List<String>, Object>();
        params.put(Arrays.asList("creator", "name"), "TestName");
        params.put(Arrays.asList("creator", "surname"), "TestSurname");
        params.put(Collections.singletonList("age"), BigDecimal.valueOf(10L));
        Object objectRaw = runnerHelper.createObject(String.class.getCanonicalName(), params, this.getClass().getClassLoader());
        Assert.assertTrue((boolean)(objectRaw instanceof Map));
        Map object = (Map)objectRaw;
        Assert.assertEquals((Object)BigDecimal.valueOf(10L), object.get("age"));
        Assert.assertTrue((boolean)(object.get("creator") instanceof Map));
        Map creator = (Map)object.get("creator");
        Assert.assertEquals((Object)"TestName", creator.get("name"));
        Assert.assertEquals((Object)"TestSurname", creator.get("surname"));
    }

    @Test
    public void extractResultMetadataNoDecisionResultMessages() {
        this.commonExtractResultMetadata(null);
    }

    @Test
    public void extractResultMetadataDecisionResultMessages() {
        List<DMNMessage> messages = TestUtils.getRandomlyGeneratedDMNMessageList();
        this.commonExtractResultMetadata(messages);
    }

    @Test
    public void getSingleFactValueResultFailDecision() {
        DMNDecisionResult failedDecision = this.createDecisionResultMock("Test", false, new ArrayList<DMNMessage>());
        ResultWrapper failedResult = runnerHelper.getSingleFactValueResult(null, null, failedDecision, expressionEvaluator);
        Assert.assertFalse((boolean)failedResult.isSatisfied());
        Assert.assertEquals((Object)("The decision " + failedDecision.getDecisionName() + " has not been successfully evaluated: " + failedDecision.getEvaluationStatus()), failedResult.getErrorMessage().get());
    }

    @Test
    public void getResultWrapper() {
        ExpressionEvaluator expressionEvaluatorMock = (ExpressionEvaluator)Mockito.mock(ExpressionEvaluator.class);
        String resultRaw = "test";
        String expectedResultRaw = "";
        String collectionError = "Impossible to find elements in the collection to satisfy the conditions";
        String genericErrorMessage = "errorMessage";
        Mockito.when((Object)expressionEvaluatorMock.evaluateUnaryExpression(Matchers.any(), Matchers.any(), (Class)Matchers.any(Class.class))).thenReturn((Object)true);
        ResultWrapper resultWrapper = runnerHelper.getResultWrapper(String.class.getCanonicalName(), new FactMappingValue(), expressionEvaluatorMock, (Object)expectedResultRaw, (Object)resultRaw, String.class);
        Assert.assertTrue((boolean)resultWrapper.isSatisfied());
        Mockito.when((Object)expressionEvaluatorMock.evaluateUnaryExpression(Matchers.any(), Matchers.any(), (Class)Matchers.any(Class.class))).thenReturn((Object)false);
        resultWrapper = runnerHelper.getResultWrapper(String.class.getCanonicalName(), new FactMappingValue(), expressionEvaluatorMock, (Object)expectedResultRaw, (Object)resultRaw, String.class);
        Assert.assertFalse((boolean)resultWrapper.isSatisfied());
        Assert.assertEquals((Object)resultRaw, (Object)resultWrapper.getResult());
        resultWrapper = runnerHelper.getResultWrapper(List.class.getCanonicalName(), new FactMappingValue(), expressionEvaluatorMock, (Object)expectedResultRaw, (Object)resultRaw, List.class);
        Assert.assertEquals((Object)collectionError, resultWrapper.getErrorMessage().get());
        resultWrapper = runnerHelper.getResultWrapper(Map.class.getCanonicalName(), new FactMappingValue(), expressionEvaluatorMock, (Object)expectedResultRaw, (Object)resultRaw, Map.class);
        Assert.assertEquals((Object)collectionError, resultWrapper.getErrorMessage().get());
        Mockito.when((Object)expressionEvaluatorMock.evaluateUnaryExpression(Matchers.any(), Matchers.any(), (Class)Matchers.any(Class.class))).thenThrow(new Throwable[]{new IllegalArgumentException(genericErrorMessage)});
        FactMappingValue expectedResult5 = new FactMappingValue();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> runnerHelper.getResultWrapper(Map.class.getCanonicalName(), expectedResult5, expressionEvaluatorMock, expectedResultRaw, resultRaw, Map.class)).isInstanceOf(ScenarioException.class)).hasMessage(genericErrorMessage);
        Assert.assertEquals((Object)genericErrorMessage, (Object)expectedResult5.getExceptionMessage());
    }

    public void commonExtractResultMetadata(List<DMNMessage> messages) {
        HashSet decisions = new HashSet();
        IntStream.range(0, 5).forEach(index -> decisions.add(this.createDecisionMock("decision" + index)));
        Mockito.when((Object)this.dmnModelMock.getDecisions()).thenReturn(decisions);
        ArrayList<DMNDecisionResult> decisionResults = new ArrayList<DMNDecisionResult>();
        decisionResults.add(this.createDecisionResultMock("decision2", true, messages));
        decisionResults.add(this.createDecisionResultMock("decision3", false, messages));
        Mockito.when((Object)this.dmnResultMock.getDecisionResults()).thenReturn(decisionResults);
        ScenarioWithIndex scenarioWithIndex = new ScenarioWithIndex(1, this.scenario1);
        ScenarioResultMetadata scenarioResultMetadata = runnerHelper.extractResultMetadata(this.requestContextMock, scenarioWithIndex);
        Assert.assertEquals((Object)scenarioWithIndex, (Object)scenarioResultMetadata.getScenarioWithIndex());
        Assert.assertEquals((long)5L, (long)scenarioResultMetadata.getAvailable().size());
        Assert.assertTrue((boolean)scenarioResultMetadata.getAvailable().contains("decision1"));
        Assert.assertEquals((long)1L, (long)scenarioResultMetadata.getExecuted().size());
        Assert.assertTrue((boolean)scenarioResultMetadata.getExecuted().contains("decision2"));
        Assert.assertFalse((boolean)scenarioResultMetadata.getExecuted().contains("decision3"));
        List auditLogLines = scenarioResultMetadata.getAuditLogLines();
        Assert.assertNotNull((Object)auditLogLines);
        if (messages == null) {
            Assert.assertEquals((long)decisionResults.size(), (long)auditLogLines.size());
            for (int i = 0; i < decisionResults.size(); ++i) {
                TestUtils.commonCheckAuditLogLine((AuditLogLine)auditLogLines.get(i), ((DMNDecisionResult)decisionResults.get(i)).getDecisionName(), ((DMNDecisionResult)decisionResults.get(i)).getEvaluationStatus().name());
            }
        } else {
            int scenarios = 2;
            int expectedLines = messages.size() * scenarios;
            Assert.assertEquals((long)expectedLines, (long)auditLogLines.size());
            for (int i = 0; i < auditLogLines.size(); ++i) {
                int messagesIndex = i < messages.size() ? i : i - messages.size();
                TestUtils.commonCheckAuditLogLine((AuditLogLine)auditLogLines.get(i), messages.get(messagesIndex).getText(), messages.get(messagesIndex).getLevel().name());
            }
        }
    }

    private DecisionNode createDecisionMock(String decisionName) {
        DecisionNode decisionMock = (DecisionNode)Mockito.mock(DecisionNode.class);
        Mockito.when((Object)decisionMock.getName()).thenReturn((Object)decisionName);
        return decisionMock;
    }

    private DMNDecisionResult createDecisionResultMock(String decisionName, boolean success, List<DMNMessage> messages) {
        DMNDecisionResult decisionResultMock = (DMNDecisionResult)Mockito.mock(DMNDecisionResult.class);
        Mockito.when((Object)decisionResultMock.getDecisionName()).thenReturn((Object)decisionName);
        Mockito.when((Object)decisionResultMock.getEvaluationStatus()).thenReturn((Object)(success ? DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED : DMNDecisionResult.DecisionEvaluationStatus.FAILED));
        if (messages != null) {
            Mockito.when((Object)decisionResultMock.getMessages()).thenReturn(messages);
        }
        return decisionResultMock;
    }
}

