/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.util;

import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.backend.TestUtils;
import org.drools.scenariosimulation.backend.util.DOMParserUtil;
import org.drools.scenariosimulation.backend.util.InMemoryMigrationStrategy;
import org.drools.scenariosimulation.backend.util.MigrationStrategy;
import org.drools.scenariosimulation.backend.util.ScenarioSimulationXMLPersistence;
import org.junit.Assert;
import org.junit.Test;
import org.kie.soup.project.datamodel.imports.Import;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ScenarioSimulationXMLPersistenceTest {
    protected ScenarioSimulationXMLPersistence instance = ScenarioSimulationXMLPersistence.getInstance();
    protected String currentVersion = new ScenarioSimulationModel().getVersion();
    protected MigrationStrategy migrationInstance = new InMemoryMigrationStrategy();

    @Test
    public void noFQCNUsed() {
        ScenarioSimulationModel simulationModel = new ScenarioSimulationModel();
        simulationModel.getImports().addImport(new Import("org.test.Test"));
        String xml = this.instance.marshal(simulationModel);
        Assert.assertFalse((boolean)xml.contains("org.drools.scenariosimulation.api.model"));
        Assert.assertFalse((boolean)xml.contains("org.kie.soup.project.datamodel.imports"));
    }

    @Test
    public void versionAttributeExists() {
        String xml = this.instance.marshal(new ScenarioSimulationModel());
        Assert.assertTrue((boolean)xml.startsWith("<ScenarioSimulationModel version=\"" + ScenarioSimulationXMLPersistence.getCurrentVersion() + "\">"));
    }

    @Test
    public void migrateIfNecessary_1_0_to_1_1() throws Exception {
        String toMigrate = TestUtils.getFileContent("scesim-1-0.scesim");
        Document document = DOMParserUtil.getDocument((String)toMigrate);
        this.migrationInstance.from1_0to1_1().accept((Object)document);
        Map retrieved = DOMParserUtil.getChildrenNodesMap((Document)document, (String)"expressionIdentifier", (String)"type");
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((long)1L, (long)retrieved.size());
        retrieved.forEach((node, typeNodes) -> {
            Assert.assertEquals((long)1L, (long)typeNodes.size());
            Assert.assertEquals((Object)"EXPECT", (Object)((Node)typeNodes.get(0)).getTextContent());
        });
        this.commonCheck(toMigrate, document, "1.1");
    }

    @Test
    public void migrateIfNecessary_1_1_to_1_2() throws Exception {
        String toMigrate = TestUtils.getFileContent("scesim-1-1.scesim");
        Document document = DOMParserUtil.getDocument((String)toMigrate);
        this.migrationInstance.from1_1to1_2().accept((Object)document);
        Map retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)"simulation", (String)"simulationDescriptor", (String)"dmoSession");
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((long)1L, (long)retrieved.size());
        Assert.assertEquals((long)1L, (long)((List)retrieved.values().iterator().next()).size());
        retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)"simulation", (String)"simulationDescriptor", (String)"type");
        this.commonVerifySingleNodeSingleChild(retrieved, "RULE");
        this.commonCheck(toMigrate, document, "1.2");
    }

    @Test
    public void migrateIfNecessary_1_2_to_1_3() throws Exception {
        String toMigrate = TestUtils.getFileContent("scesim-1-2.scesim");
        Document document = DOMParserUtil.getDocument((String)toMigrate);
        this.migrationInstance.from1_2to1_3().accept((Object)document);
        List factMappingsNodes = DOMParserUtil.getNestedChildrenNodesList((Document)document, (String)"simulation", (String)"simulationDescriptor", (String)"factMappings");
        Assert.assertNotNull((Object)factMappingsNodes);
        Assert.assertEquals((long)1L, (long)factMappingsNodes.size());
        List factMappingNodes = DOMParserUtil.getChildrenNodesList((Node)((Node)factMappingsNodes.get(0)), (String)"FactMapping");
        for (Node factMappingNode : factMappingNodes) {
            List expressionElementsNodes = DOMParserUtil.getChildrenNodesList((Node)factMappingNode, (String)"expressionElements");
            Assert.assertEquals((long)1L, (long)expressionElementsNodes.size());
            List stepNodes = DOMParserUtil.getNestedChildrenNodesList((Node)((Node)expressionElementsNodes.get(0)), (String)"ExpressionElement", (String)"step");
            Assert.assertEquals((long)1L, (long)stepNodes.size());
        }
        this.commonCheck(toMigrate, document, "1.3");
    }

    @Test
    public void migrateIfNecessary_1_3_to_1_4() throws Exception {
        String toMigrate = TestUtils.getFileContent("scesim-1-3-rule.scesim");
        Document document = DOMParserUtil.getDocument((String)toMigrate);
        this.migrationInstance.from1_3to1_4().accept((Object)document);
        Map retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)"simulation", (String)"simulationDescriptor", (String)"fileName");
        this.commonVerifySingleNodeSingleChild(retrieved, null);
        retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)"simulation", (String)"simulationDescriptor", (String)"kieSession");
        this.commonVerifySingleNodeSingleChild(retrieved, "default");
        retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)"simulation", (String)"simulationDescriptor", (String)"kieBase");
        this.commonVerifySingleNodeSingleChild(retrieved, "default");
        retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)"simulation", (String)"simulationDescriptor", (String)"ruleFlowGroup");
        this.commonVerifySingleNodeSingleChild(retrieved, "default");
        retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)"simulation", (String)"simulationDescriptor", (String)"dmoSession");
        this.commonVerifySingleNodeSingleChild(retrieved, "default");
        retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)"simulation", (String)"simulationDescriptor", (String)"skipFromBuild");
        this.commonVerifySingleNodeSingleChild(retrieved, "false");
        retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)"simulation", (String)"simulationDescriptor", (String)"type");
        this.commonVerifySingleNodeSingleChild(retrieved, "RULE");
        this.commonCheck(toMigrate, document, "1.4");
        toMigrate = TestUtils.getFileContent("scesim-1-3-dmn_1.scesim");
        document = DOMParserUtil.getDocument((String)toMigrate);
        this.migrationInstance.from1_3to1_4().accept((Object)document);
        retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)"simulation", (String)"simulationDescriptor", (String)"dmnNamespace");
        this.commonVerifySingleNodeSingleChild(retrieved, null);
        retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)"simulation", (String)"simulationDescriptor", (String)"dmnName");
        this.commonVerifySingleNodeSingleChild(retrieved, null);
        retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)"simulation", (String)"simulationDescriptor", (String)"skipFromBuild");
        this.commonVerifySingleNodeSingleChild(retrieved, "false");
        retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)"simulation", (String)"simulationDescriptor", (String)"type");
        this.commonVerifySingleNodeSingleChild(retrieved, "DMN");
        this.commonCheck(toMigrate, document, "1.4");
        toMigrate = TestUtils.getFileContent("scesim-1-3-dmn_2.scesim");
        document = DOMParserUtil.getDocument((String)toMigrate);
        this.migrationInstance.from1_3to1_4().accept((Object)document);
        retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)"simulation", (String)"simulationDescriptor", (String)"dmnNamespace");
        this.commonVerifySingleNodeSingleChild(retrieved, null);
        retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)"simulation", (String)"simulationDescriptor", (String)"dmnName");
        this.commonVerifySingleNodeSingleChild(retrieved, null);
        retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)"simulation", (String)"simulationDescriptor", (String)"skipFromBuild");
        this.commonVerifySingleNodeSingleChild(retrieved, "false");
        retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)"simulation", (String)"simulationDescriptor", (String)"type");
        this.commonVerifySingleNodeSingleChild(retrieved, "DMN");
        this.commonCheck(toMigrate, document, "1.4");
    }

    @Test
    public void migrateIfNecessary_1_4_to_1_5() throws Exception {
        String toMigrate = TestUtils.getFileContent("scesim-1-4-rule.scesim");
        Document document = DOMParserUtil.getDocument((String)toMigrate);
        this.migrationInstance.from1_4to1_5().accept((Object)document);
        List retrieved = DOMParserUtil.getNestedChildrenNodesList((Document)document, (String)"simulation", (String)"simulationDescriptor", (String)"dmoSession");
        Assert.assertNotNull((Object)retrieved);
        Assert.assertTrue((boolean)retrieved.isEmpty());
        this.commonCheck(toMigrate, document, "1.5");
    }

    @Test
    public void migrateIfNecessary_1_5_to_1_6() throws Exception {
        String toMigrate = TestUtils.getFileContent("scesim-1-5-dmn.scesim");
        Document document = DOMParserUtil.getDocument((String)toMigrate);
        this.migrationInstance.from1_5to1_6().accept((Object)document);
        Map retrieved = DOMParserUtil.getAttributeValues((Document)document, (String)"reference");
        Assert.assertNotNull((Object)retrieved);
        Assert.assertTrue((boolean)retrieved.isEmpty());
        this.commonCheck(toMigrate, document, "1.6");
    }

    @Test
    public void migrateIfNecessary() throws Exception {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.instance.migrateIfNecessary("<ScenarioSimulationModel version=\"9999999999.99999999999\" />")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Version 9999999999.99999999999 of the file is not supported. Current version is " + ScenarioSimulationXMLPersistence.getCurrentVersion());
        String noMigrationNeeded = "<ScenarioSimulationModel version=\"" + this.currentVersion + "\" />";
        String afterMigration = this.instance.migrateIfNecessary(noMigrationNeeded);
        Document document = DOMParserUtil.getDocument((String)afterMigration);
        this.commonCheckVersion(document, "1.6");
    }

    @Test
    public void extractVersion() {
        String version = this.instance.extractVersion("<ScenarioSimulationModel version=\"1.0\" version=\"1.1\">");
        Assert.assertEquals((Object)"1.0", (Object)version);
    }

    @Test
    public void unmarshalRULE() throws Exception {
        String toUnmarshal = TestUtils.getFileContent("scesim-rule.scesim");
        ScenarioSimulationModel retrieved = ScenarioSimulationXMLPersistence.getInstance().unmarshal(toUnmarshal);
        Assert.assertEquals((Object)retrieved.getSimulation().getSimulationDescriptor().getType(), (Object)ScenarioSimulationModel.Type.RULE);
        this.commonCheckScenarioSimulationModel(retrieved);
    }

    @Test
    public void unmarshalDMN() throws Exception {
        String toUnmarshal = TestUtils.getFileContent("scesim-dmn.scesim");
        ScenarioSimulationModel retrieved = ScenarioSimulationXMLPersistence.getInstance().unmarshal(toUnmarshal);
        Assert.assertEquals((Object)retrieved.getSimulation().getSimulationDescriptor().getType(), (Object)ScenarioSimulationModel.Type.DMN);
        this.commonCheckScenarioSimulationModel(retrieved);
    }

    private void commonVerifySingleNodeSingleChild(Map<Node, List<Node>> toCheck, String expectedTextContent) {
        Assert.assertNotNull(toCheck);
        Assert.assertEquals((long)1L, (long)toCheck.size());
        Assert.assertNotNull(toCheck.values());
        Assert.assertEquals((long)1L, (long)toCheck.values().iterator().next().size());
        if (expectedTextContent != null) {
            Assert.assertEquals((Object)expectedTextContent, (Object)toCheck.values().iterator().next().get(0).getTextContent());
        }
    }

    private void commonCheck(String toMigrate, Document document, String expectedVersion) throws Exception {
        this.commonCheckVersion(document, expectedVersion);
        this.commonCheckScenarioSimulationModel(document);
        this.instance.migrateIfNecessary(toMigrate);
    }

    private void commonCheckVersion(Document document, String expectedVersion) {
        Map attributeValues = DOMParserUtil.getAttributeValues((Document)document, (String)"ScenarioSimulationModel", (String)"version");
        Assert.assertNotNull((Object)attributeValues);
        Assert.assertEquals((long)1L, (long)attributeValues.size());
        Assert.assertEquals((Object)expectedVersion, (Object)((String)attributeValues.values().toArray()[0]));
    }

    private void commonCheckScenarioSimulationModel(Document toCheck) throws Exception {
        String migrated = DOMParserUtil.getString((Document)toCheck);
        ScenarioSimulationModel scenarioSimulationModel = this.instance.internalUnmarshal(migrated);
        this.commonCheckScenarioSimulationModel(scenarioSimulationModel);
    }

    private void commonCheckScenarioSimulationModel(ScenarioSimulationModel toCheck) throws Exception {
        Assert.assertNotNull((Object)toCheck);
        Assert.assertNotNull((Object)toCheck.getSimulation());
        Assert.assertNotNull((Object)toCheck.getSimulation().getSimulationDescriptor());
        toCheck.getSimulation().getUnmodifiableScenarios().forEach(scenario -> scenario.getUnmodifiableFactMappingValues().forEach(factMappingValue -> {}));
    }
}

