/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.expression;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.drools.scenariosimulation.backend.expression.AbstractExpressionEvaluator;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.core.compiler.profiles.ExtendedDMNProfile;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.impl.EvaluationContextImpl;
import org.kie.dmn.feel.lang.impl.FEELEventListenersManager;
import org.kie.dmn.feel.runtime.events.SyntaxErrorEvent;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.extended.CodeFunction;

public class DMNFeelExpressionEvaluator
extends AbstractExpressionEvaluator {
    private final ClassLoader classLoader;
    private final CodeFunction codeFunction = new CodeFunction();

    public DMNFeelExpressionEvaluator(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public boolean evaluateUnaryExpression(Object rawExpression, Object resultValue, Class<?> resultClass) {
        if (rawExpression != null && !(rawExpression instanceof String)) {
            throw new IllegalArgumentException("Raw expression should be a string");
        }
        return this.commonEvaluateUnaryExpression(rawExpression, resultValue, resultClass);
    }

    @Override
    public Object evaluateLiteralExpression(String className, List<String> genericClasses, Object raw) {
        if (!(raw instanceof String)) {
            return raw;
        }
        return this.commonEvaluationLiteralExpression(className, genericClasses, (String)raw);
    }

    @Override
    public String fromObjectToExpression(Object value) {
        FEELFnResult invoke = this.codeFunction.invoke(value);
        return (String)invoke.getOrElseThrow(feelEvent -> new IllegalArgumentException("This should not happen", feelEvent.getSourceException()));
    }

    protected EvaluationContext newEvaluationContext() {
        FEELEventListenersManager eventsManager = new FEELEventListenersManager();
        return new EvaluationContextImpl(this.classLoader, eventsManager);
    }

    protected FEEL newFeelEvaluator(AtomicReference<FEELEvent> errorHolder) {
        errorHolder.set(null);
        FEEL feel = FEEL.newInstance(Collections.singletonList(new ExtendedDMNProfile()));
        feel.addListener(event -> {
            FEELEvent feelEvent = (FEELEvent)errorHolder.get();
            if (!(feelEvent instanceof SyntaxErrorEvent) && FEELEvent.Severity.ERROR.equals((Object)event.getSeverity())) {
                errorHolder.set(event);
            }
        });
        return feel;
    }

    @Override
    protected Object internalLiteralEvaluation(String raw, String className) {
        EvaluationContext evaluationContext = this.newEvaluationContext();
        return this.executeAndVerifyErrors(feel -> feel.evaluate(raw, evaluationContext));
    }

    @Override
    protected boolean internalUnaryEvaluation(String rawExpression, Object resultValue, Class<?> resultClass, boolean skipEmptyString) {
        if (rawExpression != null && skipEmptyString && rawExpression.isEmpty()) {
            return true;
        }
        EvaluationContext evaluationContext = this.newEvaluationContext();
        List unaryTests = this.executeAndVerifyErrors(feel -> feel.evaluateUnaryTests(rawExpression));
        return unaryTests.stream().allMatch(unaryTest -> (Boolean)Optional.ofNullable(unaryTest.apply((Object)evaluationContext, resultValue)).orElse(false));
    }

    protected <T> T executeAndVerifyErrors(Function<FEEL, T> command) {
        AtomicReference<FEELEvent> errorHolder = new AtomicReference<FEELEvent>();
        FEEL feel = this.newFeelEvaluator(errorHolder);
        T result = command.apply(feel);
        FEELEvent errorEvent = errorHolder.get();
        if (errorEvent != null) {
            if (errorEvent instanceof SyntaxErrorEvent) {
                throw new IllegalArgumentException("Syntax error: " + errorEvent.getMessage());
            }
            throw new IllegalArgumentException("Error during evaluation: " + errorEvent.getMessage());
        }
        return result;
    }

    @Override
    protected Object extractFieldValue(Object result, String fieldName) {
        return ((Map)result).get(fieldName);
    }

    @Override
    protected Object createObject(String className, List<String> genericClasses) {
        return new HashMap();
    }

    @Override
    protected void setField(Object toReturn, String fieldName, Object fieldValue) {
        Map returnMap = (Map)toReturn;
        returnMap.put(fieldName, fieldValue);
    }

    @Override
    protected Map.Entry<String, List<String>> getFieldClassNameAndGenerics(Object element, String fieldName, String className, List<String> genericClasses) {
        return new AbstractMap.SimpleEntry<String, List<String>>("", Collections.singletonList(""));
    }
}

