/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.expression;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.backend.expression.AbstractExpressionEvaluator;
import org.junit.Assert;
import org.junit.Test;

public class AbstractExpressionEvaluatorTest {
    JsonNodeFactory factory = JsonNodeFactory.instance;
    AbstractExpressionEvaluator expressionEvaluatorMock = new AbstractExpressionEvaluator(){

        public boolean evaluateUnaryExpression(Object rawExpression, Object resultValue, Class<?> resultClass) {
            throw new UnsupportedOperationException();
        }

        public Object evaluateLiteralExpression(String className, List<String> genericClasses, Object rawExpression) {
            throw new UnsupportedOperationException();
        }

        public String fromObjectToExpression(Object value) {
            throw new UnsupportedOperationException();
        }

        protected Object extractFieldValue(Object result, String fieldName) {
            return result;
        }

        protected boolean internalUnaryEvaluation(String rawExpression, Object resultValue, Class<?> resultClass, boolean skipEmptyString) {
            return true;
        }

        protected Object internalLiteralEvaluation(String raw, String className) {
            return raw;
        }

        protected Object createObject(String className, List<String> genericClasses) {
            return new HashMap();
        }

        protected void setField(Object toReturn, String fieldName, Object fieldValue) {
            ((Map)toReturn).put(fieldName, fieldValue);
        }

        protected Map.Entry<String, List<String>> getFieldClassNameAndGenerics(Object element, String fieldName, String className, List<String> genericClasses) {
            return new AbstractMap.SimpleEntry<String, List<String>>("", Collections.singletonList(""));
        }
    };

    @Test
    public void convertList() {
        ArrayNode jsonNodes = new ArrayNode(this.factory);
        ObjectNode objectNode = new ObjectNode(this.factory);
        objectNode.put("value", "data");
        jsonNodes.add((JsonNode)objectNode);
        List objects = this.expressionEvaluatorMock.createAndFillList(jsonNodes, new ArrayList(), List.class.getCanonicalName(), Collections.singletonList(String.class.getCanonicalName()));
        Assert.assertEquals((Object)"data", objects.get(0));
    }

    @Test
    public void convertObject() {
        ObjectNode objectNode = new ObjectNode(this.factory);
        objectNode.put("age", "1");
        Object result = this.expressionEvaluatorMock.createAndFillObject(objectNode, new HashMap(), Map.class.getCanonicalName(), Collections.singletonList(String.class.getCanonicalName()));
        Assert.assertTrue((boolean)(result instanceof Map));
        Map resultMap = (Map)result;
        Assert.assertEquals((Object)"1", resultMap.get("age"));
        objectNode.removeAll();
        ObjectNode nestedObject = new ObjectNode(this.factory);
        objectNode.set("nested", (JsonNode)nestedObject);
        nestedObject.put("field", "fieldValue");
        result = this.expressionEvaluatorMock.createAndFillObject(objectNode, new HashMap(), String.class.getCanonicalName(), Collections.emptyList());
        Assert.assertTrue((boolean)(result instanceof Map));
        resultMap = (Map)result;
        Assert.assertEquals((long)1L, (long)resultMap.size());
        Map nested = (Map)resultMap.get("nested");
        Assert.assertEquals((long)1L, (long)nested.size());
        Assert.assertEquals((Object)"fieldValue", nested.get("field"));
        objectNode.removeAll();
        ArrayNode jsonNodes = new ArrayNode(this.factory);
        objectNode.set("listField", (JsonNode)jsonNodes);
        jsonNodes.add((JsonNode)nestedObject);
        result = this.expressionEvaluatorMock.createAndFillObject(objectNode, new HashMap(), String.class.getCanonicalName(), Collections.emptyList());
        Assert.assertTrue((boolean)(result instanceof Map));
        resultMap = (Map)result;
        Assert.assertEquals((long)1L, (long)resultMap.size());
        List nestedList = (List)resultMap.get("listField");
        Assert.assertEquals((long)1L, (long)nestedList.size());
        Assert.assertEquals((Object)"fieldValue", ((Map)nestedList.get(0)).get("field"));
    }

    @Test
    public void isSimpleTypeNode() {
        Assert.assertFalse((boolean)this.expressionEvaluatorMock.isSimpleTypeNode((JsonNode)new ArrayNode(this.factory)));
        ObjectNode jsonNode = new ObjectNode(this.factory);
        jsonNode.set("value", (JsonNode)new TextNode("test"));
        Assert.assertTrue((boolean)this.expressionEvaluatorMock.isSimpleTypeNode((JsonNode)jsonNode));
        jsonNode.set("otherField", (JsonNode)new TextNode("testValue"));
        Assert.assertFalse((boolean)this.expressionEvaluatorMock.isSimpleTypeNode((JsonNode)jsonNode));
    }

    @Test
    public void getSimpleTypeNodeTextValue() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.expressionEvaluatorMock.getSimpleTypeNodeTextValue((JsonNode)new ArrayNode(this.factory))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter does not contains a simple type");
        ObjectNode jsonNode = new ObjectNode(this.factory);
        jsonNode.set("value", (JsonNode)new TextNode("testValue"));
        Assert.assertEquals((Object)"testValue", (Object)this.expressionEvaluatorMock.getSimpleTypeNodeTextValue((JsonNode)jsonNode));
        jsonNode.set("value", (JsonNode)new IntNode(10));
        Assert.assertNull((Object)this.expressionEvaluatorMock.getSimpleTypeNodeTextValue((JsonNode)jsonNode));
    }

    @Test
    public void isNodeEmpty() {
        ObjectNode objectNode = new ObjectNode(this.factory);
        Assert.assertTrue((boolean)this.expressionEvaluatorMock.isNodeEmpty((JsonNode)objectNode));
        objectNode.set("empty array", (JsonNode)new ArrayNode(this.factory));
        Assert.assertTrue((boolean)this.expressionEvaluatorMock.isNodeEmpty((JsonNode)objectNode));
        objectNode.set("key", (JsonNode)new TextNode("value"));
        Assert.assertFalse((boolean)this.expressionEvaluatorMock.isNodeEmpty((JsonNode)objectNode));
        ArrayNode arrayNode = new ArrayNode(this.factory);
        Assert.assertTrue((boolean)this.expressionEvaluatorMock.isNodeEmpty((JsonNode)arrayNode));
        arrayNode.add((JsonNode)new TextNode("value"));
        Assert.assertFalse((boolean)this.expressionEvaluatorMock.isNodeEmpty((JsonNode)arrayNode));
        Assert.assertTrue((boolean)this.expressionEvaluatorMock.isNodeEmpty((JsonNode)new TextNode("")));
        Assert.assertTrue((boolean)this.expressionEvaluatorMock.isNodeEmpty((JsonNode)new TextNode(null)));
        Assert.assertFalse((boolean)this.expressionEvaluatorMock.isNodeEmpty((JsonNode)new TextNode("value")));
    }

    @Test
    public void isListEmpty() {
        ArrayNode json = new ArrayNode(this.factory);
        Assert.assertTrue((boolean)this.expressionEvaluatorMock.isListEmpty(json));
        ObjectNode nestedNode = new ObjectNode(this.factory);
        json.add((JsonNode)nestedNode);
        Assert.assertTrue((boolean)this.expressionEvaluatorMock.isListEmpty(json));
        nestedNode.set("emptyField", (JsonNode)new TextNode(""));
        Assert.assertTrue((boolean)this.expressionEvaluatorMock.isListEmpty(json));
        nestedNode.set("notEmptyField", (JsonNode)new TextNode("text"));
        Assert.assertFalse((boolean)this.expressionEvaluatorMock.isListEmpty(json));
    }

    @Test
    public void isObjectEmpty() {
        ObjectNode json = new ObjectNode(this.factory);
        Assert.assertTrue((boolean)this.expressionEvaluatorMock.isObjectEmpty(json));
        ObjectNode nestedNode = new ObjectNode(this.factory);
        json.set("emptyField", (JsonNode)nestedNode);
        Assert.assertTrue((boolean)this.expressionEvaluatorMock.isObjectEmpty(json));
        nestedNode.set("notEmptyField", (JsonNode)new TextNode("text"));
        Assert.assertFalse((boolean)this.expressionEvaluatorMock.isObjectEmpty(json));
    }

    @Test
    public void isEmptyText() {
        Assert.assertTrue((boolean)this.expressionEvaluatorMock.isEmptyText((JsonNode)new TextNode("")));
        Assert.assertFalse((boolean)this.expressionEvaluatorMock.isEmptyText((JsonNode)new TextNode("value")));
        Assert.assertTrue((boolean)this.expressionEvaluatorMock.isEmptyText((JsonNode)new ObjectNode(this.factory)));
    }
}

