/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.expression;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.backend.expression.MVELExpressionEvaluator;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class MVELExpressionEvaluatorTest {
    MVELExpressionEvaluator evaluator = new MVELExpressionEvaluator(MVELExpressionEvaluatorTest.class.getClassLoader());

    @Test
    public void evaluateUnaryExpression() {
        Assert.assertTrue((boolean)this.evaluator.evaluateUnaryExpression((Object)MVELExpressionEvaluatorTest.mvelExpression("java.util.Objects.equals(actualValue, \"Test\")"), (Object)"Test", String.class));
        Assert.assertFalse((boolean)this.evaluator.evaluateUnaryExpression((Object)MVELExpressionEvaluatorTest.mvelExpression("java.util.Objects.equals(actualValue, \"Test\")"), (Object)"Test1", String.class));
        Assert.assertTrue((boolean)this.evaluator.evaluateUnaryExpression((Object)MVELExpressionEvaluatorTest.mvelExpression("1"), (Object)1, Integer.class));
        Assert.assertFalse((boolean)this.evaluator.evaluateUnaryExpression((Object)MVELExpressionEvaluatorTest.mvelExpression("2"), (Object)1, Integer.class));
        Assert.assertTrue((boolean)this.evaluator.evaluateUnaryExpression((Object)MVELExpressionEvaluatorTest.mvelExpression("actualValue == 123"), (Object)123, Integer.class));
        Assert.assertTrue((boolean)this.evaluator.evaluateUnaryExpression((Object)MVELExpressionEvaluatorTest.mvelExpression("actualValue != 123"), (Object)321, Integer.class));
        Assert.assertFalse((boolean)this.evaluator.evaluateUnaryExpression((Object)MVELExpressionEvaluatorTest.mvelExpression("actualValue == 123"), (Object)321, Integer.class));
        Assert.assertFalse((boolean)this.evaluator.evaluateUnaryExpression((Object)MVELExpressionEvaluatorTest.mvelExpression("actualValue != 123"), (Object)123, Integer.class));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.evaluator.evaluateUnaryExpression(new Object(), (Object)"", String.class)).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Raw expression should be a String");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.evaluator.evaluateUnaryExpression(null, (Object)"", String.class)).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Raw expression should be a String");
    }

    @Test
    public void evaluateLiteralExpression() {
        Assert.assertEquals((Object)1, (Object)this.evaluator.evaluateLiteralExpression(Integer.class.getCanonicalName(), Collections.emptyList(), (Object)MVELExpressionEvaluatorTest.mvelExpression("1")));
        Assert.assertEquals((Object)"Value", (Object)this.evaluator.evaluateLiteralExpression(String.class.getCanonicalName(), Collections.emptyList(), (Object)MVELExpressionEvaluatorTest.mvelExpression("\"Value\"")));
        Assert.assertEquals((Object)6, (Object)this.evaluator.evaluateLiteralExpression(Integer.class.getCanonicalName(), Collections.emptyList(), (Object)MVELExpressionEvaluatorTest.mvelExpression("2 * 3")));
        Assert.assertEquals((Object)14, (Object)this.evaluator.evaluateLiteralExpression(Integer.class.getCanonicalName(), Collections.emptyList(), (Object)MVELExpressionEvaluatorTest.mvelExpression("-1 + (3 * 5)")));
        Assert.assertEquals(Arrays.asList("Jim"), (Object)this.evaluator.evaluateLiteralExpression(ArrayList.class.getCanonicalName(), Collections.emptyList(), (Object)MVELExpressionEvaluatorTest.mvelExpression("[\"Jim\"]")));
        Assert.assertEquals(Collections.emptyList(), (Object)this.evaluator.evaluateLiteralExpression(ArrayList.class.getCanonicalName(), Collections.emptyList(), (Object)MVELExpressionEvaluatorTest.mvelExpression("[]")));
        Assertions.assertThat((Object)this.evaluator.evaluateLiteralExpression(Character.class.getCanonicalName(), Collections.emptyList(), (Object)MVELExpressionEvaluatorTest.mvelExpression("\"abc..\"[2]"))).isEqualTo((Object)Character.valueOf('c'));
        Assertions.assertThat((Object)this.evaluator.evaluateLiteralExpression(BigDecimal.class.getCanonicalName(), Collections.emptyList(), (Object)MVELExpressionEvaluatorTest.mvelExpression("1.234B"))).isEqualTo((Object)new BigDecimal("1.234"));
        Assertions.assertThat((Object)this.evaluator.evaluateLiteralExpression(Double.class.getCanonicalName(), Collections.emptyList(), (Object)MVELExpressionEvaluatorTest.mvelExpression("1.234d"))).isEqualTo((Object)Double.valueOf("1.234"));
        Assert.assertEquals((Object)"Value", (Object)this.evaluator.evaluateLiteralExpression(String.class.getCanonicalName(), Collections.emptyList(), (Object)"# \"Value\""));
        Assertions.assertThatThrownBy(() -> this.evaluator.evaluateLiteralExpression(String.class.getCanonicalName(), Collections.emptyList(), (Object)"1+")).isInstanceOf(RuntimeException.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.evaluator.evaluateLiteralExpression(String.class.getCanonicalName(), Collections.emptyList(), new Object())).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Raw expression should be a String");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.evaluator.evaluateLiteralExpression(String.class.getCanonicalName(), Collections.emptyList(), (Object)MVELExpressionEvaluatorTest.mvelExpression("1"))).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Cannot assign a 'java.lang.Integer");
    }

    @Ignore(value="https://issues.jboss.org/browse/DROOLS-4649")
    @Test
    public void evaluateLiteralExpression_Array() {
        Assertions.assertThat((Object)this.evaluator.evaluateLiteralExpression(Object[].class.getCanonicalName(), Collections.emptyList(), (Object)MVELExpressionEvaluatorTest.mvelExpression("{\"Jim\", \"Michael\"}"))).isEqualTo((Object)new String[]{"Jim", "Michael"});
        Assertions.assertThat((Object)this.evaluator.evaluateLiteralExpression(Object[].class.getCanonicalName(), Collections.emptyList(), (Object)MVELExpressionEvaluatorTest.mvelExpression("{ }"))).isEqualTo((Object)new String[0]);
    }

    @Test
    public void fromObjectToExpression() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.evaluator.fromObjectToExpression(null)).isInstanceOf(UnsupportedOperationException.class)).hasMessage("The condition has not been satisfied");
    }

    @Test
    public void cleanExpression() {
        Assert.assertEquals((Object)"test", (Object)this.evaluator.cleanExpression("#test"));
        Assert.assertEquals((Object)" test", (Object)this.evaluator.cleanExpression("# test"));
        Assert.assertEquals((Object)" # test", (Object)this.evaluator.cleanExpression("# # test"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.evaluator.cleanExpression("test")).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Malformed MVEL expression");
    }

    private static String mvelExpression(String expression) {
        return "# " + expression;
    }
}

