/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.runner;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.api.model.AuditLogLine;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.FactMappingValueStatus;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.Settings;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.scenariosimulation.backend.TestUtils;
import org.drools.scenariosimulation.backend.expression.DMNFeelExpressionEvaluator;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluator;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluatorFactory;
import org.drools.scenariosimulation.backend.fluent.DMNScenarioExecutableBuilder;
import org.drools.scenariosimulation.backend.model.Dispute;
import org.drools.scenariosimulation.backend.model.Person;
import org.drools.scenariosimulation.backend.runner.DMNScenarioRunnerHelper;
import org.drools.scenariosimulation.backend.runner.RuleScenarioRunnerHelperTest;
import org.drools.scenariosimulation.backend.runner.ScenarioException;
import org.drools.scenariosimulation.backend.runner.model.InstanceGiven;
import org.drools.scenariosimulation.backend.runner.model.ResultWrapper;
import org.drools.scenariosimulation.backend.runner.model.ScenarioExpect;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResult;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResultMetadata;
import org.drools.scenariosimulation.backend.runner.model.ScenarioRunnerData;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.RequestContext;
import org.kie.dmn.api.core.DMNDecisionResult;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.ast.DecisionNode;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DMNScenarioRunnerHelperTest {
    private static final String NAME = "NAME";
    private static final String FEEL_EXPRESSION_NAME = "\"NAME\"";
    private static final BigDecimal AMOUNT = BigDecimal.valueOf(10L);
    private static final String DMN_FILE_PATH = "dmnFilePath";
    private static final String TEST_DESCRIPTION = "Test description";
    private static final ClassLoader classLoader = RuleScenarioRunnerHelperTest.class.getClassLoader();
    private static final ExpressionEvaluatorFactory expressionEvaluatorFactory = ExpressionEvaluatorFactory.create((ClassLoader)classLoader, (ScenarioSimulationModel.Type)ScenarioSimulationModel.Type.DMN);
    private static final ExpressionEvaluator expressionEvaluator = new DMNFeelExpressionEvaluator(classLoader);
    private final DMNScenarioRunnerHelper runnerHelper = new DMNScenarioRunnerHelper(){

        protected DMNScenarioExecutableBuilder createBuilderWrapper(KieContainer kieContainer) {
            return DMNScenarioRunnerHelperTest.this.dmnScenarioExecutableBuilderMock;
        }
    };
    @Mock
    protected Map<String, Object> requestContextMock;
    @Mock
    protected DMNResult dmnResultMock;
    @Mock
    protected DMNDecisionResult dmnDecisionResultMock;
    @Mock
    protected DMNModel dmnModelMock;
    @Mock
    protected DMNScenarioExecutableBuilder dmnScenarioExecutableBuilderMock;
    @Mock
    protected KieContainer kieContainerMock;
    private Simulation simulation;
    private Settings settings;
    private FactIdentifier personFactIdentifier;
    private ExpressionIdentifier firstNameGivenExpressionIdentifier;
    private FactMapping firstNameGivenFactMapping;
    private Scenario scenario1;
    private Scenario scenario2;
    private ExpressionIdentifier firstNameExpectedExpressionIdentifier;
    private FactMapping firstNameExpectedFactMapping;
    private FactIdentifier disputeFactIdentifier;
    private ExpressionIdentifier amountGivenExpressionIdentifier;
    private FactMapping amountNameGivenFactMapping;
    private ExpressionIdentifier amountExpectedExpressionIdentifier;
    private FactMapping amountNameExpectedFactMapping;
    private FactMappingValue amountNameExpectedFactMappingValue;
    private FactMappingValue firstNameExpectedValue;

    @Before
    public void init() {
        Mockito.when((Object)this.dmnScenarioExecutableBuilderMock.run()).thenReturn(Mockito.mock(RequestContext.class));
        this.simulation = new Simulation();
        this.settings = new Settings();
        this.settings.setType(ScenarioSimulationModel.Type.DMN);
        this.settings.setDmnFilePath(DMN_FILE_PATH);
        this.personFactIdentifier = FactIdentifier.create((String)"Fact 1", (String)Person.class.getCanonicalName());
        this.firstNameGivenExpressionIdentifier = ExpressionIdentifier.create((String)"First Name Given", (FactMappingType)FactMappingType.GIVEN);
        this.firstNameGivenFactMapping = this.simulation.getScesimModelDescriptor().addFactMapping(this.personFactIdentifier, this.firstNameGivenExpressionIdentifier);
        this.firstNameGivenFactMapping.addExpressionElement("Fact 1", String.class.getCanonicalName());
        this.firstNameGivenFactMapping.addExpressionElement("firstName", String.class.getCanonicalName());
        this.disputeFactIdentifier = FactIdentifier.create((String)"Fact 2", (String)Dispute.class.getCanonicalName());
        this.amountGivenExpressionIdentifier = ExpressionIdentifier.create((String)"Amount Given", (FactMappingType)FactMappingType.GIVEN);
        this.amountNameGivenFactMapping = this.simulation.getScesimModelDescriptor().addFactMapping(this.disputeFactIdentifier, this.amountGivenExpressionIdentifier);
        this.amountNameGivenFactMapping.addExpressionElement("Fact 2", BigDecimal.class.getCanonicalName());
        this.amountNameGivenFactMapping.addExpressionElement("amount", BigDecimal.class.getCanonicalName());
        this.firstNameExpectedExpressionIdentifier = ExpressionIdentifier.create((String)"First Name Expected", (FactMappingType)FactMappingType.EXPECT);
        this.firstNameExpectedFactMapping = this.simulation.getScesimModelDescriptor().addFactMapping(this.personFactIdentifier, this.firstNameExpectedExpressionIdentifier);
        this.firstNameExpectedFactMapping.addExpressionElement("Fact 1", String.class.getCanonicalName());
        this.firstNameExpectedFactMapping.addExpressionElement("firstName", String.class.getCanonicalName());
        this.amountExpectedExpressionIdentifier = ExpressionIdentifier.create((String)"Amount Expected", (FactMappingType)FactMappingType.EXPECT);
        this.amountNameExpectedFactMapping = this.simulation.getScesimModelDescriptor().addFactMapping(this.disputeFactIdentifier, this.amountExpectedExpressionIdentifier);
        this.amountNameExpectedFactMapping.addExpressionElement("Fact 2", Double.class.getCanonicalName());
        this.amountNameExpectedFactMapping.addExpressionElement("amount", Double.class.getCanonicalName());
        this.scenario1 = (Scenario)this.simulation.addData();
        this.scenario1.setDescription(TEST_DESCRIPTION);
        this.scenario1.addMappingValue(this.personFactIdentifier, this.firstNameGivenExpressionIdentifier, (Object)FEEL_EXPRESSION_NAME);
        this.firstNameExpectedValue = this.scenario1.addMappingValue(this.personFactIdentifier, this.firstNameExpectedExpressionIdentifier, (Object)FEEL_EXPRESSION_NAME);
        this.scenario2 = (Scenario)this.simulation.addData();
        this.scenario2.setDescription(TEST_DESCRIPTION);
        this.scenario2.addMappingValue(this.personFactIdentifier, this.firstNameGivenExpressionIdentifier, (Object)FEEL_EXPRESSION_NAME);
        this.scenario2.addMappingValue(this.personFactIdentifier, this.firstNameExpectedExpressionIdentifier, (Object)FEEL_EXPRESSION_NAME);
        this.scenario2.addMappingValue(this.disputeFactIdentifier, this.amountGivenExpressionIdentifier, (Object)AMOUNT);
        this.amountNameExpectedFactMappingValue = this.scenario2.addMappingValue(this.disputeFactIdentifier, this.amountExpectedExpressionIdentifier, (Object)AMOUNT);
        Mockito.when((Object)this.requestContextMock.get(DMNScenarioExecutableBuilder.DMN_RESULT)).thenReturn((Object)this.dmnResultMock);
        Mockito.when((Object)this.requestContextMock.get(DMNScenarioExecutableBuilder.DMN_MODEL)).thenReturn((Object)this.dmnModelMock);
    }

    @Test
    public void verifyConditions() {
        ScenarioRunnerData scenarioRunnerData1 = new ScenarioRunnerData();
        scenarioRunnerData1.addExpect(new ScenarioExpect(this.personFactIdentifier, Collections.singletonList(this.firstNameExpectedValue)));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runnerHelper.verifyConditions(this.simulation.getScesimModelDescriptor(), scenarioRunnerData1, expressionEvaluatorFactory, this.requestContextMock)).isInstanceOf(ScenarioException.class)).hasMessage("DMN execution has not generated a decision result with name Fact 1");
        Mockito.when((Object)this.dmnResultMock.getDecisionResultByName(Mockito.anyString())).thenReturn((Object)this.dmnDecisionResultMock);
        Mockito.when((Object)this.dmnDecisionResultMock.getEvaluationStatus()).thenReturn((Object)DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED);
        this.runnerHelper.verifyConditions(this.simulation.getScesimModelDescriptor(), scenarioRunnerData1, expressionEvaluatorFactory, this.requestContextMock);
        Assert.assertEquals((long)1L, (long)scenarioRunnerData1.getResults().size());
        Assert.assertFalse((boolean)((ScenarioResult)scenarioRunnerData1.getResults().get(0)).getResult());
        Mockito.when((Object)this.dmnDecisionResultMock.getResult()).thenReturn((Object)"");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runnerHelper.verifyConditions(this.simulation.getScesimModelDescriptor(), scenarioRunnerData1, expressionEvaluatorFactory, this.requestContextMock)).isInstanceOf(ScenarioException.class)).hasMessage("Wrong resultRaw structure because it is not a complex type as expected");
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("firstName", "WrongValue");
        Mockito.when((Object)this.dmnDecisionResultMock.getResult()).thenReturn(resultMap);
        ScenarioRunnerData scenarioRunnerData2 = new ScenarioRunnerData();
        scenarioRunnerData2.addExpect(new ScenarioExpect(this.personFactIdentifier, Collections.singletonList(this.firstNameExpectedValue)));
        this.runnerHelper.verifyConditions(this.simulation.getScesimModelDescriptor(), scenarioRunnerData2, expressionEvaluatorFactory, this.requestContextMock);
        Assert.assertEquals((long)1L, (long)scenarioRunnerData2.getResults().size());
        Assert.assertFalse((boolean)((ScenarioResult)scenarioRunnerData2.getResults().get(0)).getResult());
        ScenarioRunnerData scenarioRunnerData3 = new ScenarioRunnerData();
        scenarioRunnerData3.addExpect(new ScenarioExpect(this.personFactIdentifier, Collections.singletonList(this.firstNameExpectedValue)));
        resultMap.put("firstName", NAME);
        this.runnerHelper.verifyConditions(this.simulation.getScesimModelDescriptor(), scenarioRunnerData3, expressionEvaluatorFactory, this.requestContextMock);
        Assert.assertEquals((long)1L, (long)scenarioRunnerData3.getResults().size());
        Assert.assertTrue((boolean)((ScenarioResult)scenarioRunnerData3.getResults().get(0)).getResult());
        ExpressionEvaluatorFactory expressionEvaluatorFactoryMock = (ExpressionEvaluatorFactory)Mockito.mock(ExpressionEvaluatorFactory.class);
        Mockito.when((Object)expressionEvaluatorFactoryMock.getOrCreate((FactMappingValue)Matchers.any())).thenReturn(Mockito.mock(ExpressionEvaluator.class));
        this.runnerHelper.verifyConditions(this.simulation.getScesimModelDescriptor(), scenarioRunnerData3, expressionEvaluatorFactoryMock, this.requestContextMock);
        Assert.assertEquals((Object)FactMappingValueStatus.FAILED_WITH_ERROR, (Object)((ScenarioResult)scenarioRunnerData3.getResults().get(0)).getFactMappingValue().getStatus());
    }

    @Test
    public void createObject() {
        HashMap<List<String>, Object> params = new HashMap<List<String>, Object>();
        params.put(Arrays.asList("creator", "name"), "TestName");
        params.put(Arrays.asList("creator", "surname"), "TestSurname");
        params.put(Collections.singletonList("age"), BigDecimal.valueOf(10L));
        Optional initialInstance = this.runnerHelper.getDirectMapping(params).getOptional();
        Object objectRaw = this.runnerHelper.createObject(initialInstance, String.class.getCanonicalName(), params, this.getClass().getClassLoader());
        Assert.assertTrue((boolean)(objectRaw instanceof Map));
        Map object = (Map)objectRaw;
        Assert.assertEquals((Object)BigDecimal.valueOf(10L), object.get("age"));
        Assert.assertTrue((boolean)(object.get("creator") instanceof Map));
        Map creator = (Map)object.get("creator");
        Assert.assertEquals((Object)"TestName", creator.get("name"));
        Assert.assertEquals((Object)"TestSurname", creator.get("surname"));
    }

    @Test
    public void createObjectDirectMappingSimpleType() {
        HashMap params = new HashMap();
        String directMappingSimpleTypeValue = "TestName";
        params.put(Collections.emptyList(), directMappingSimpleTypeValue);
        Optional initialInstance = this.runnerHelper.getDirectMapping(params).getOptional();
        Object objectRaw = this.runnerHelper.createObject(initialInstance, String.class.getCanonicalName(), params, this.getClass().getClassLoader());
        Assert.assertTrue((boolean)(objectRaw instanceof String));
        Assert.assertEquals((Object)directMappingSimpleTypeValue, (Object)objectRaw);
    }

    @Test
    public void createObjectDirectMappingComplexType() {
        HashMap<List<Object>, Object> params = new HashMap<List<Object>, Object>();
        HashMap<String, String> directMappingComplexTypeValue = new HashMap<String, String>();
        directMappingComplexTypeValue.put("key1", "value1");
        params.put(Collections.emptyList(), directMappingComplexTypeValue);
        params.put(Collections.singletonList("key2"), "value2");
        Optional initialInstance = this.runnerHelper.getDirectMapping(params).getOptional();
        Object objectRaw = this.runnerHelper.createObject(initialInstance, Map.class.getCanonicalName(), params, this.getClass().getClassLoader());
        Assert.assertTrue((boolean)(objectRaw instanceof Map));
        Map object = (Map)objectRaw;
        Assert.assertEquals((Object)"value1", object.get("key1"));
        Assert.assertEquals((Object)"value2", object.get("key2"));
    }

    @Test
    public void extractResultMetadataNoDecisionResultMessages() {
        this.commonExtractResultMetadata(null);
    }

    @Test
    public void extractResultMetadataDecisionResultMessages() {
        List<DMNMessage> messages = TestUtils.getRandomlyGeneratedDMNMessageList();
        this.commonExtractResultMetadata(messages);
    }

    @Test
    public void getSingleFactValueResultFailDecision() {
        DMNDecisionResult failedDecision = this.createDecisionResultMock("Test", false, new ArrayList<DMNMessage>());
        ResultWrapper failedResult = this.runnerHelper.getSingleFactValueResult(null, null, failedDecision, expressionEvaluator);
        Assert.assertFalse((boolean)failedResult.isSatisfied());
        Assert.assertEquals((Object)("The decision " + failedDecision.getDecisionName() + " has not been successfully evaluated: " + failedDecision.getEvaluationStatus()), failedResult.getErrorMessage().get());
    }

    @Test
    public void executeScenario() {
        ArgumentCaptor setValueCaptor = ArgumentCaptor.forClass(Object.class);
        ScenarioRunnerData scenarioRunnerData = new ScenarioRunnerData();
        scenarioRunnerData.addBackground(new InstanceGiven(this.personFactIdentifier, (Object)new Person()));
        scenarioRunnerData.addBackground(new InstanceGiven(this.disputeFactIdentifier, (Object)new Dispute()));
        scenarioRunnerData.addGiven(new InstanceGiven(this.personFactIdentifier, (Object)new Person()));
        FactMappingValue factMappingValue = new FactMappingValue(this.personFactIdentifier, this.firstNameExpectedExpressionIdentifier, (Object)NAME);
        scenarioRunnerData.addExpect(new ScenarioExpect(this.personFactIdentifier, Collections.singletonList(factMappingValue), false));
        scenarioRunnerData.addExpect(new ScenarioExpect(this.personFactIdentifier, Collections.singletonList(factMappingValue), true));
        int inputObjects = scenarioRunnerData.getBackgrounds().size() + scenarioRunnerData.getGivens().size();
        this.runnerHelper.executeScenario(this.kieContainerMock, scenarioRunnerData, expressionEvaluatorFactory, this.simulation.getScesimModelDescriptor(), this.settings);
        ((DMNScenarioExecutableBuilder)Mockito.verify((Object)this.dmnScenarioExecutableBuilderMock, (VerificationMode)Mockito.times((int)1))).setActiveModel((String)Matchers.eq((Object)DMN_FILE_PATH));
        ((DMNScenarioExecutableBuilder)Mockito.verify((Object)this.dmnScenarioExecutableBuilderMock, (VerificationMode)Mockito.times((int)inputObjects))).setValue(Mockito.anyString(), setValueCaptor.capture());
        for (Object value : setValueCaptor.getAllValues()) {
            Assert.assertTrue((value instanceof Person || value instanceof Dispute ? 1 : 0) != 0);
        }
        ((DMNScenarioExecutableBuilder)Mockito.verify((Object)this.dmnScenarioExecutableBuilderMock, (VerificationMode)Mockito.times((int)1))).run();
        this.settings.setType(ScenarioSimulationModel.Type.RULE);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runnerHelper.executeScenario(this.kieContainerMock, scenarioRunnerData, expressionEvaluatorFactory, this.simulation.getScesimModelDescriptor(), this.settings)).isInstanceOf(ScenarioException.class)).hasMessageStartingWith("Impossible to run");
    }

    public void commonExtractResultMetadata(List<DMNMessage> messages) {
        HashSet decisions = new HashSet();
        IntStream.range(0, 5).forEach(index -> decisions.add(this.createDecisionMock("decision" + index)));
        Mockito.when((Object)this.dmnModelMock.getDecisions()).thenReturn(decisions);
        ArrayList<DMNDecisionResult> decisionResults = new ArrayList<DMNDecisionResult>();
        decisionResults.add(this.createDecisionResultMock("decision2", true, messages));
        decisionResults.add(this.createDecisionResultMock("decision3", false, messages));
        Mockito.when((Object)this.dmnResultMock.getDecisionResults()).thenReturn(decisionResults);
        ScenarioWithIndex scenarioWithIndex = new ScenarioWithIndex(1, this.scenario1);
        ScenarioResultMetadata scenarioResultMetadata = this.runnerHelper.extractResultMetadata(this.requestContextMock, scenarioWithIndex);
        Assert.assertEquals((Object)scenarioWithIndex, (Object)scenarioResultMetadata.getScenarioWithIndex());
        Assert.assertEquals((long)5L, (long)scenarioResultMetadata.getAvailable().size());
        Assert.assertTrue((boolean)scenarioResultMetadata.getAvailable().contains("decision1"));
        Assert.assertEquals((long)1L, (long)scenarioResultMetadata.getExecuted().size());
        Assert.assertTrue((boolean)scenarioResultMetadata.getExecuted().contains("decision2"));
        Assert.assertFalse((boolean)scenarioResultMetadata.getExecuted().contains("decision3"));
        List auditLogLines = scenarioResultMetadata.getAuditLogLines();
        Assert.assertNotNull((Object)auditLogLines);
        if (messages == null) {
            Assert.assertEquals((long)decisionResults.size(), (long)auditLogLines.size());
            for (int i = 0; i < decisionResults.size(); ++i) {
                TestUtils.commonCheckAuditLogLine((AuditLogLine)auditLogLines.get(i), ((DMNDecisionResult)decisionResults.get(i)).getDecisionName(), ((DMNDecisionResult)decisionResults.get(i)).getEvaluationStatus().name());
            }
        } else {
            int scenarios = 2;
            int expectedLines = messages.size() * scenarios;
            Assert.assertEquals((long)expectedLines, (long)auditLogLines.size());
            for (int i = 0; i < auditLogLines.size(); ++i) {
                int messagesIndex = i < messages.size() ? i : i - messages.size();
                TestUtils.commonCheckAuditLogLine((AuditLogLine)auditLogLines.get(i), messages.get(messagesIndex).getText(), messages.get(messagesIndex).getLevel().name());
            }
        }
    }

    private DecisionNode createDecisionMock(String decisionName) {
        DecisionNode decisionMock = (DecisionNode)Mockito.mock(DecisionNode.class);
        Mockito.when((Object)decisionMock.getName()).thenReturn((Object)decisionName);
        return decisionMock;
    }

    private DMNDecisionResult createDecisionResultMock(String decisionName, boolean success, List<DMNMessage> messages) {
        DMNDecisionResult decisionResultMock = (DMNDecisionResult)Mockito.mock(DMNDecisionResult.class);
        Mockito.when((Object)decisionResultMock.getDecisionName()).thenReturn((Object)decisionName);
        Mockito.when((Object)decisionResultMock.getEvaluationStatus()).thenReturn((Object)(success ? DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED : DMNDecisionResult.DecisionEvaluationStatus.FAILED));
        if (messages != null) {
            Mockito.when((Object)decisionResultMock.getMessages()).thenReturn(messages);
        }
        return decisionResultMock;
    }
}

