/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.expression;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.backend.expression.AbstractExpressionEvaluator;
import org.junit.Assert;
import org.junit.Test;

public class AbstractExpressionEvaluatorTest {
    private static final JsonNodeFactory factory = JsonNodeFactory.instance;
    private static final AbstractExpressionEvaluator expressionEvaluatorLocal = new AbstractExpressionEvaluator(){

        public String fromObjectToExpression(Object value) {
            throw new UnsupportedOperationException();
        }

        protected Object extractFieldValue(Object result, String fieldName) {
            return result;
        }

        protected boolean internalUnaryEvaluation(String rawExpression, Object resultValue, Class<?> resultClass, boolean skipEmptyString) {
            return true;
        }

        protected Object internalLiteralEvaluation(String raw, String className) {
            return raw;
        }

        protected Object createObject(String className, List<String> genericClasses) {
            return new HashMap();
        }

        protected void setField(Object toReturn, String fieldName, Object fieldValue) {
            ((Map)toReturn).put(fieldName, fieldValue);
        }

        protected Map.Entry<String, List<String>> getFieldClassNameAndGenerics(Object element, String fieldName, String className, List<String> genericClasses) {
            return new AbstractMap.SimpleEntry<String, List<String>>("", Collections.singletonList(""));
        }
    };

    @Test
    public void evaluateLiteralExpression() {
        Assert.assertNull((Object)expressionEvaluatorLocal.evaluateLiteralExpression(null, String.class.getCanonicalName(), null));
        Assert.assertNull((Object)expressionEvaluatorLocal.evaluateLiteralExpression(null, List.class.getCanonicalName(), null));
        Assert.assertNull((Object)expressionEvaluatorLocal.evaluateLiteralExpression(null, Map.class.getCanonicalName(), null));
    }

    @Test
    public void evaluateUnaryExpression() {
        Assert.assertTrue((boolean)expressionEvaluatorLocal.evaluateUnaryExpression(null, null, String.class));
        Assert.assertTrue((boolean)expressionEvaluatorLocal.evaluateUnaryExpression(null, null, Map.class));
        Assert.assertTrue((boolean)expressionEvaluatorLocal.evaluateUnaryExpression(null, null, List.class));
    }

    @Test
    public void convertList() {
        ArrayNode jsonNodes = new ArrayNode(factory);
        ObjectNode objectNode = new ObjectNode(factory);
        objectNode.put("value", "data");
        jsonNodes.add((JsonNode)objectNode);
        List objects = expressionEvaluatorLocal.createAndFillList(jsonNodes, new ArrayList(), List.class.getCanonicalName(), Collections.singletonList(String.class.getCanonicalName()));
        Assert.assertEquals((Object)"data", objects.get(0));
    }

    @Test
    public void convertObject() {
        ObjectNode objectNode = new ObjectNode(factory);
        objectNode.put("age", "1");
        Object result = expressionEvaluatorLocal.createAndFillObject(objectNode, new HashMap(), Map.class.getCanonicalName(), Collections.singletonList(String.class.getCanonicalName()));
        Assert.assertTrue((boolean)(result instanceof Map));
        Map resultMap = (Map)result;
        Assert.assertEquals((Object)"1", resultMap.get("age"));
        objectNode.removeAll();
        ObjectNode nestedObject = new ObjectNode(factory);
        objectNode.set("nested", (JsonNode)nestedObject);
        nestedObject.put("field", "fieldValue");
        result = expressionEvaluatorLocal.createAndFillObject(objectNode, new HashMap(), String.class.getCanonicalName(), Collections.emptyList());
        Assert.assertTrue((boolean)(result instanceof Map));
        resultMap = (Map)result;
        Assert.assertEquals((long)1L, (long)resultMap.size());
        Map nested = (Map)resultMap.get("nested");
        Assert.assertEquals((long)1L, (long)nested.size());
        Assert.assertEquals((Object)"fieldValue", nested.get("field"));
        objectNode.removeAll();
        ArrayNode jsonNodes = new ArrayNode(factory);
        objectNode.set("listField", (JsonNode)jsonNodes);
        jsonNodes.add((JsonNode)nestedObject);
        result = expressionEvaluatorLocal.createAndFillObject(objectNode, new HashMap(), String.class.getCanonicalName(), Collections.emptyList());
        Assert.assertTrue((boolean)(result instanceof Map));
        resultMap = (Map)result;
        Assert.assertEquals((long)1L, (long)resultMap.size());
        List nestedList = (List)resultMap.get("listField");
        Assert.assertEquals((long)1L, (long)nestedList.size());
        Assert.assertEquals((Object)"fieldValue", ((Map)nestedList.get(0)).get("field"));
    }

    @Test
    public void isSimpleTypeNode() {
        Assert.assertFalse((boolean)expressionEvaluatorLocal.isSimpleTypeNode((JsonNode)new ArrayNode(factory)));
        ObjectNode jsonNode = new ObjectNode(factory);
        jsonNode.set("value", (JsonNode)new TextNode("test"));
        Assert.assertTrue((boolean)expressionEvaluatorLocal.isSimpleTypeNode((JsonNode)jsonNode));
        jsonNode.set("otherField", (JsonNode)new TextNode("testValue"));
        Assert.assertFalse((boolean)expressionEvaluatorLocal.isSimpleTypeNode((JsonNode)jsonNode));
    }

    @Test
    public void getSimpleTypeNodeTextValue() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> expressionEvaluatorLocal.getSimpleTypeNodeTextValue((JsonNode)new ArrayNode(factory))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter does not contains a simple type");
        ObjectNode jsonNode = new ObjectNode(factory);
        jsonNode.set("value", (JsonNode)new TextNode("testValue"));
        Assert.assertEquals((Object)"testValue", (Object)expressionEvaluatorLocal.getSimpleTypeNodeTextValue((JsonNode)jsonNode));
        jsonNode.set("value", (JsonNode)new IntNode(10));
        Assert.assertNull((Object)expressionEvaluatorLocal.getSimpleTypeNodeTextValue((JsonNode)jsonNode));
    }

    @Test
    public void isNodeEmpty() {
        ObjectNode objectNode = new ObjectNode(factory);
        Assert.assertTrue((boolean)expressionEvaluatorLocal.isNodeEmpty((JsonNode)objectNode));
        objectNode.set("empty array", (JsonNode)new ArrayNode(factory));
        Assert.assertTrue((boolean)expressionEvaluatorLocal.isNodeEmpty((JsonNode)objectNode));
        objectNode.set("key", (JsonNode)new TextNode("value"));
        Assert.assertFalse((boolean)expressionEvaluatorLocal.isNodeEmpty((JsonNode)objectNode));
        ArrayNode arrayNode = new ArrayNode(factory);
        Assert.assertTrue((boolean)expressionEvaluatorLocal.isNodeEmpty((JsonNode)arrayNode));
        arrayNode.add((JsonNode)new TextNode("value"));
        Assert.assertFalse((boolean)expressionEvaluatorLocal.isNodeEmpty((JsonNode)arrayNode));
        Assert.assertTrue((boolean)expressionEvaluatorLocal.isNodeEmpty((JsonNode)new TextNode("")));
        Assert.assertTrue((boolean)expressionEvaluatorLocal.isNodeEmpty((JsonNode)new TextNode(null)));
        Assert.assertFalse((boolean)expressionEvaluatorLocal.isNodeEmpty((JsonNode)new TextNode("value")));
    }

    @Test
    public void isListEmpty() {
        ArrayNode json = new ArrayNode(factory);
        Assert.assertTrue((boolean)expressionEvaluatorLocal.isListEmpty(json));
        ObjectNode nestedNode = new ObjectNode(factory);
        json.add((JsonNode)nestedNode);
        Assert.assertTrue((boolean)expressionEvaluatorLocal.isListEmpty(json));
        nestedNode.set("emptyField", (JsonNode)new TextNode(""));
        Assert.assertTrue((boolean)expressionEvaluatorLocal.isListEmpty(json));
        nestedNode.set("notEmptyField", (JsonNode)new TextNode("text"));
        Assert.assertFalse((boolean)expressionEvaluatorLocal.isListEmpty(json));
    }

    @Test
    public void isObjectEmpty() {
        ObjectNode json = new ObjectNode(factory);
        Assert.assertTrue((boolean)expressionEvaluatorLocal.isObjectEmpty(json));
        ObjectNode nestedNode = new ObjectNode(factory);
        json.set("emptyField", (JsonNode)nestedNode);
        Assert.assertTrue((boolean)expressionEvaluatorLocal.isObjectEmpty(json));
        nestedNode.set("notEmptyField", (JsonNode)new TextNode("text"));
        Assert.assertFalse((boolean)expressionEvaluatorLocal.isObjectEmpty(json));
    }

    @Test
    public void isEmptyText() {
        Assert.assertTrue((boolean)expressionEvaluatorLocal.isEmptyText((JsonNode)new TextNode("")));
        Assert.assertFalse((boolean)expressionEvaluatorLocal.isEmptyText((JsonNode)new TextNode("value")));
        Assert.assertTrue((boolean)expressionEvaluatorLocal.isEmptyText((JsonNode)new ObjectNode(factory)));
    }
}

