/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.expression;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.backend.expression.DMNFeelExpressionEvaluator;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.runtime.events.FEELEventBase;
import org.kie.dmn.feel.runtime.events.SyntaxErrorEvent;

public class DMNFeelExpressionEvaluatorTest {
    DMNFeelExpressionEvaluator expressionEvaluator = new DMNFeelExpressionEvaluator(this.getClass().getClassLoader());

    @Test
    public void evaluateUnaryExpression() {
        Assert.assertTrue((boolean)this.expressionEvaluator.evaluateUnaryExpression("not( true )", (Object)false, Boolean.TYPE));
        Assert.assertTrue((boolean)this.expressionEvaluator.evaluateUnaryExpression(">2, >5", (Object)BigDecimal.valueOf(6L), BigDecimal.class));
        Assert.assertTrue((boolean)this.expressionEvaluator.evaluateUnaryExpression("abs(-1)", (Object)BigDecimal.valueOf(1L), BigDecimal.class));
        Assert.assertFalse((boolean)this.expressionEvaluator.evaluateUnaryExpression("abs(-1)", (Object)BigDecimal.valueOf(-1L), BigDecimal.class));
        Assert.assertTrue((boolean)this.expressionEvaluator.evaluateUnaryExpression("max(1, ?) > 1", (Object)BigDecimal.valueOf(2L), BigDecimal.class));
        Assert.assertFalse((boolean)this.expressionEvaluator.evaluateUnaryExpression("max(1, ?) < 1", (Object)BigDecimal.valueOf(2L), BigDecimal.class));
        Assert.assertTrue((boolean)this.expressionEvaluator.evaluateUnaryExpression("? = 2", (Object)BigDecimal.valueOf(2L), BigDecimal.class));
        Assert.assertFalse((boolean)this.expressionEvaluator.evaluateUnaryExpression("? > 2", (Object)BigDecimal.valueOf(2L), BigDecimal.class));
        Assert.assertTrue((boolean)this.expressionEvaluator.evaluateUnaryExpression("? + 1 > ?", (Object)BigDecimal.valueOf(2L), BigDecimal.class));
        Map<String, BigDecimal> contextValue = Collections.singletonMap("key_a", BigDecimal.valueOf(1L));
        Assert.assertTrue((boolean)this.expressionEvaluator.evaluateUnaryExpression("{key_a : 1}", contextValue, Map.class));
        Assert.assertFalse((boolean)this.expressionEvaluator.evaluateUnaryExpression("{key_a : 2}", contextValue, Map.class));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.expressionEvaluator.evaluateUnaryExpression("variable", null, null)).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Error during evaluation:");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.expressionEvaluator.evaluateUnaryExpression("! true", null, null)).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Syntax error:");
        Assertions.assertThatThrownBy(() -> this.expressionEvaluator.evaluateUnaryExpression("? > 2", null, BigDecimal.class)).isInstanceOf(NullPointerException.class);
    }

    @Test
    public void evaluateLiteralExpression() {
        Assert.assertEquals((Object)BigDecimal.valueOf(5L), (Object)this.expressionEvaluator.evaluateLiteralExpression("2 + 3", BigDecimal.class.getCanonicalName(), null));
        Map parsedValue = (Map)this.expressionEvaluator.evaluateLiteralExpression("{key_a : 1}", Map.class.getCanonicalName(), Collections.emptyList());
        Assert.assertTrue((boolean)parsedValue.containsKey("key_a"));
        Assert.assertEquals(parsedValue.get("key_a"), (Object)BigDecimal.valueOf(1L));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.expressionEvaluator.evaluateLiteralExpression("SPEED", String.class.getCanonicalName(), null)).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Error during evaluation:");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.expressionEvaluator.evaluateLiteralExpression("\"SPEED", String.class.getCanonicalName(), null)).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Syntax error:");
    }

    @Test
    public void expressionTest() {
        String listJsonString = "[{\"name\": \"\\\"John\\\"\"}, {\"name\": \"\\\"John\\\"\", \"names\" : [{\"value\": \"\\\"Anna\\\"\"}, {\"value\": \"\\\"Mario\\\"\"}]}]";
        List parsedValue = (List)this.expressionEvaluator.convertResult(listJsonString, List.class.getCanonicalName(), Collections.singletonList(Map.class.getCanonicalName()));
        Assert.assertEquals((long)2L, (long)parsedValue.size());
        Assert.assertEquals((long)2L, (long)((List)((Map)parsedValue.get(1)).get("names")).size());
        Assert.assertTrue((boolean)((List)((Map)parsedValue.get(1)).get("names")).contains("Anna"));
        String mapJsonString = "{\"first\": {\"name\": \"\\\"John\\\"\"}}";
        Map parsedMap = (Map)this.expressionEvaluator.convertResult(mapJsonString, Map.class.getCanonicalName(), Arrays.asList(String.class.getCanonicalName(), Object.class.getCanonicalName()));
        Assert.assertEquals((long)1L, (long)parsedMap.size());
        Assert.assertEquals((Object)"John", ((Map)parsedMap.get("first")).get("name"));
        mapJsonString = "{\"first\": {\"siblings\": [{\"name\" : \"\\\"John\\\"\"}]}}";
        parsedMap = (Map)this.expressionEvaluator.convertResult(mapJsonString, Map.class.getCanonicalName(), Arrays.asList(String.class.getCanonicalName(), Object.class.getCanonicalName()));
        Assert.assertEquals((long)1L, (long)parsedMap.size());
        Assert.assertEquals((Object)"John", ((Map)((List)((Map)parsedMap.get("first")).get("siblings")).get(0)).get("name"));
        mapJsonString = "{\"first\": {\"phones\": {\"number\" : \"1\"}}}";
        parsedMap = (Map)this.expressionEvaluator.convertResult(mapJsonString, Map.class.getCanonicalName(), Arrays.asList(String.class.getCanonicalName(), Object.class.getCanonicalName()));
        Assert.assertEquals((long)1L, (long)parsedMap.size());
        Assert.assertEquals((Object)BigDecimal.valueOf(1L), ((Map)((Map)parsedMap.get("first")).get("phones")).get("number"));
    }

    @Test
    public void fromObjectToExpressionTest() {
        Assert.assertEquals((Object)"\"Test\"", (Object)this.expressionEvaluator.fromObjectToExpression((Object)"Test"));
        Assert.assertEquals((Object)"false", (Object)this.expressionEvaluator.fromObjectToExpression((Object)false));
        Assert.assertEquals((Object)"1", (Object)this.expressionEvaluator.fromObjectToExpression((Object)BigDecimal.valueOf(1L)));
        Assert.assertEquals((Object)"date( \"2019-05-13\" )", (Object)this.expressionEvaluator.fromObjectToExpression((Object)LocalDate.of(2019, 5, 13)));
        Assert.assertEquals((Object)"null", (Object)this.expressionEvaluator.fromObjectToExpression(null));
    }

    @Test
    public void listenerTest() {
        SyntaxErrorEvent syntaxErrorEvent = new SyntaxErrorEvent(FEELEvent.Severity.ERROR, "test", null, 0, 0, null);
        FEELEventBase genericError = new FEELEventBase(FEELEvent.Severity.ERROR, "error", null);
        FEELEventBase notError = new FEELEventBase(FEELEvent.Severity.INFO, "info", null);
        AtomicReference error = new AtomicReference();
        FEEL feel = this.expressionEvaluator.newFeelEvaluator(error);
        this.applyEvents(Collections.singletonList(syntaxErrorEvent), feel);
        Assert.assertEquals((Object)syntaxErrorEvent, error.get());
        error.set(null);
        this.applyEvents(Arrays.asList(genericError, syntaxErrorEvent), feel);
        Assert.assertEquals((Object)syntaxErrorEvent, error.get());
        error.set(null);
        this.applyEvents(Arrays.asList(syntaxErrorEvent, genericError), feel);
        Assert.assertEquals((Object)syntaxErrorEvent, error.get());
        error.set(null);
        this.applyEvents(Collections.singletonList(notError), feel);
        Assert.assertNull(error.get());
    }

    private void applyEvents(List<FEELEvent> events, FEEL feel) {
        for (FEELEvent event : events) {
            feel.getListeners().forEach(listener -> listener.onEvent(event));
        }
    }
}

