/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.expression;

import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.backend.expression.BaseExpressionEvaluator;
import org.drools.scenariosimulation.backend.expression.DMNFeelExpressionEvaluator;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluatorFactory;
import org.drools.scenariosimulation.backend.expression.MVELExpressionEvaluator;
import org.junit.Assert;
import org.junit.Test;

public class ExpressionEvaluatorFactoryTest {
    ClassLoader classLoader = ExpressionEvaluatorFactoryTest.class.getClassLoader();

    @Test
    public void create() {
        Assert.assertNotNull((Object)ExpressionEvaluatorFactory.create((ClassLoader)this.classLoader, (ScenarioSimulationModel.Type)ScenarioSimulationModel.Type.RULE));
    }

    @Test
    public void getOrCreate() {
        FactMappingValue simpleFMV = new FactMappingValue(FactIdentifier.INDEX, ExpressionIdentifier.INDEX, (Object)"10");
        FactMappingValue objectFMV = new FactMappingValue(FactIdentifier.INDEX, ExpressionIdentifier.INDEX, (Object)"10");
        FactMappingValue mvelFMV = new FactMappingValue(FactIdentifier.INDEX, ExpressionIdentifier.INDEX, (Object)"# 10");
        FactMappingValue mvelWithSpacesFMV = new FactMappingValue(FactIdentifier.INDEX, ExpressionIdentifier.INDEX, (Object)"     # 10");
        ExpressionEvaluatorFactory ruleEvaluatorFactory = ExpressionEvaluatorFactory.create((ClassLoader)this.classLoader, (ScenarioSimulationModel.Type)ScenarioSimulationModel.Type.RULE);
        ExpressionEvaluatorFactory dmnEvaluatorFactory = ExpressionEvaluatorFactory.create((ClassLoader)this.classLoader, (ScenarioSimulationModel.Type)ScenarioSimulationModel.Type.DMN);
        Assert.assertTrue((boolean)(ruleEvaluatorFactory.getOrCreate(simpleFMV) instanceof BaseExpressionEvaluator));
        Assert.assertTrue((boolean)(ruleEvaluatorFactory.getOrCreate(objectFMV) instanceof BaseExpressionEvaluator));
        Assert.assertTrue((boolean)(ruleEvaluatorFactory.getOrCreate(mvelFMV) instanceof MVELExpressionEvaluator));
        Assert.assertTrue((boolean)(ruleEvaluatorFactory.getOrCreate(mvelWithSpacesFMV) instanceof MVELExpressionEvaluator));
        Assert.assertTrue((boolean)(dmnEvaluatorFactory.getOrCreate(simpleFMV) instanceof DMNFeelExpressionEvaluator));
        Assert.assertTrue((boolean)(dmnEvaluatorFactory.getOrCreate(objectFMV) instanceof DMNFeelExpressionEvaluator));
        Assert.assertTrue((boolean)(dmnEvaluatorFactory.getOrCreate(mvelFMV) instanceof DMNFeelExpressionEvaluator));
        Assert.assertTrue((boolean)(dmnEvaluatorFactory.getOrCreate(mvelWithSpacesFMV) instanceof DMNFeelExpressionEvaluator));
    }
}

